/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Iterator;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;

public final class IterableIntervalSubset<T>
extends AbstractWrappedInterval<IterableInterval<T>>
implements IterableInterval<T> {
    protected final long firstIndex;
    private final long size;
    protected final long lastIndex;

    public IterableIntervalSubset(IterableInterval<T> interval, long firstIndex, long size) {
        super(interval);
        this.firstIndex = firstIndex;
        this.size = Math.min(size, interval.size() - firstIndex);
        this.lastIndex = firstIndex + this.size - 1L;
    }

    @Override
    public final Cursor<T> cursor() {
        if (this.firstIndex == 0L && this.size == ((IterableInterval)this.sourceInterval).size()) {
            return ((IterableInterval)this.sourceInterval).cursor();
        }
        return new IISCursor(false);
    }

    @Override
    public final Cursor<T> localizingCursor() {
        if (this.firstIndex == 0L && this.size == ((IterableInterval)this.sourceInterval).size()) {
            return ((IterableInterval)this.sourceInterval).localizingCursor();
        }
        return new IISCursor(true);
    }

    @Override
    public Object iterationOrder() {
        return new IISIterationOrder();
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public final T firstElement() {
        return (T)this.cursor().next();
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.cursor();
    }

    private class IISIterationOrder {
        private IISIterationOrder() {
        }

        long firstIndex() {
            return IterableIntervalSubset.this.firstIndex;
        }

        long size() {
            return IterableIntervalSubset.this.size;
        }

        IterableInterval<T> interval() {
            return (IterableInterval)IterableIntervalSubset.this.sourceInterval;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IISIterationOrder)) {
                return false;
            }
            IISIterationOrder o = (IISIterationOrder)obj;
            return o.firstIndex() == this.firstIndex() && o.size() == this.size() && o.interval().iterationOrder().equals(this.interval().iterationOrder());
        }
    }

    private final class IISCursor
    implements Cursor<T> {
        private long index;
        private final Cursor<T> cursor;
        private final boolean localizing;

        private IISCursor(IISCursor cursor) {
            this.localizing = cursor.localizing;
            this.cursor = this.localizing ? ((IterableInterval)IterableIntervalSubset.this.sourceInterval).localizingCursor() : ((IterableInterval)IterableIntervalSubset.this.sourceInterval).cursor();
            this.index = cursor.index;
            cursor.jumpFwd(this.index + 1L);
        }

        IISCursor(boolean localizing) {
            this.localizing = localizing;
            this.cursor = localizing ? ((IterableInterval)IterableIntervalSubset.this.sourceInterval).localizingCursor() : ((IterableInterval)IterableIntervalSubset.this.sourceInterval).cursor();
            this.index = IterableIntervalSubset.this.firstIndex - 1L;
            this.cursor.jumpFwd(IterableIntervalSubset.this.firstIndex);
        }

        @Override
        public final double getDoublePosition(int d) {
            return this.cursor.getDoublePosition(d);
        }

        @Override
        public final float getFloatPosition(int d) {
            return this.cursor.getFloatPosition(d);
        }

        @Override
        public final void localize(float[] position) {
            this.cursor.localize(position);
        }

        @Override
        public final void localize(double[] position) {
            this.cursor.localize(position);
        }

        @Override
        public final int numDimensions() {
            return ((IterableInterval)IterableIntervalSubset.this.sourceInterval).numDimensions();
        }

        @Override
        public final T get() {
            return this.cursor.get();
        }

        public final IISCursor copy() {
            return new IISCursor(this);
        }

        public final IISCursor copyCursor() {
            return this.copy();
        }

        @Override
        public final void fwd() {
            ++this.index;
            this.cursor.fwd();
        }

        @Override
        public final boolean hasNext() {
            return this.index < IterableIntervalSubset.this.lastIndex;
        }

        @Override
        public final void jumpFwd(long steps) {
            this.index += steps;
            this.cursor.jumpFwd(steps);
        }

        @Override
        public final void reset() {
            this.index = IterableIntervalSubset.this.firstIndex - 1L;
            this.cursor.reset();
            this.cursor.jumpFwd(IterableIntervalSubset.this.firstIndex);
        }

        @Override
        public final T next() {
            this.fwd();
            return this.get();
        }

        @Override
        public final void remove() {
        }

        @Override
        public final int getIntPosition(int d) {
            return this.cursor.getIntPosition(d);
        }

        @Override
        public final long getLongPosition(int d) {
            return this.cursor.getLongPosition(d);
        }

        @Override
        public final void localize(int[] position) {
            this.cursor.localize(position);
        }

        @Override
        public final void localize(long[] position) {
            this.cursor.localize(position);
        }
    }
}

