/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.action;

import java.util.Collection;
import java.util.Collections;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.GroupAction;
import net.imagej.updater.UpdateSite;

public class Upload
implements GroupAction {
    private String updateSite;

    public Upload(String updateSite) {
        this.updateSite = updateSite;
    }

    @Override
    public boolean isValid(FilesCollection files, FileObject file2) {
        boolean shadowing;
        FileObject.Status status = file2.getStatus();
        boolean canUpload = status.isValid(FileObject.Action.UPLOAD);
        boolean bl = shadowing = file2.updateSite != null && !this.updateSite.equals(file2.updateSite);
        if (!canUpload && status != FileObject.Status.INSTALLED) {
            return false;
        }
        Collection<String> sites = files.getSiteNamesToUpload();
        if (sites.size() > 0 && !sites.contains(this.updateSite)) {
            return false;
        }
        if (shadowing) {
            UpdateSite shadowingSite = files.getUpdateSite(this.updateSite, false);
            UpdateSite shadowedSite = files.getUpdateSite(file2.updateSite, false);
            if (shadowingSite.getRank() < shadowedSite.getRank()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setAction(FilesCollection files, FileObject file2) {
        if (file2.updateSite != null && !file2.updateSite.equals(this.updateSite) && file2.originalUpdateSite == null) {
            file2.originalUpdateSite = file2.updateSite;
        }
        file2.updateSite = this.updateSite;
        if (file2.getStatus() == FileObject.Status.INSTALLED) {
            file2.setStatus(FileObject.Status.MODIFIED);
        }
        file2.setAction(files, FileObject.Action.UPLOAD);
    }

    @Override
    public String getLabel(FilesCollection files, Iterable<FileObject> selected) {
        boolean shadowing = false;
        for (FileObject file2 : selected) {
            FileObject.Status status = file2.getStatus();
            if (!status.isValid(FileObject.Action.UPLOAD) && status != FileObject.Status.INSTALLED || file2.updateSite == null || file2.updateSite.equals(this.updateSite)) continue;
            shadowing = true;
        }
        return "Upload" + (shadowing ? " (shadowing)" : "") + " to " + this.updateSite;
    }

    public String toString() {
        return this.getLabel(null, Collections.emptyList());
    }
}

