/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.action;

import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.GroupAction;

public class InstallOrUpdate
implements GroupAction {
    @Override
    public boolean isValid(FilesCollection files, FileObject file2) {
        FileObject.Status status = file2.getStatus();
        return status.isValid(FileObject.Action.INSTALL) || status.isValid(FileObject.Action.UPDATE);
    }

    @Override
    public void setAction(FilesCollection files, FileObject file2) {
        file2.setFirstValidAction(files, FileObject.Action.INSTALL, FileObject.Action.UPDATE);
    }

    @Override
    public String getLabel(FilesCollection files, Iterable<FileObject> selected) {
        boolean install = false;
        boolean update = false;
        for (FileObject file2 : selected) {
            FileObject.Status status = file2.getStatus();
            install = install || status.isValid(FileObject.Action.INSTALL);
            update = update || status.isValid(FileObject.Action.UPDATE);
        }
        if (!(install ^ update)) {
            return "Install / Update";
        }
        return update ? "Update" : "Install";
    }

    public String toString() {
        return "Install / Update";
    }
}

