/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imagej.updater.Conflicts;
import net.imagej.updater.Dependency;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.Uploadable;
import net.imagej.updater.UploadableFile;
import net.imagej.updater.Uploader;
import net.imagej.updater.UploaderService;
import net.imagej.updater.XMLFileWriter;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.StderrProgress;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.Context;
import org.scijava.log.LogService;

public class FilesUploader {
    private FilesCollection files;
    private Uploader uploader;
    private String siteName;
    private UpdateSite site;
    private List<Uploadable> uploadables;
    private String compressed;
    private boolean loggedIn;

    private static UploaderService createUploaderService() {
        FilesUploader.setClassLoaderIfNecessary();
        Context context = new Context(UploaderService.class);
        return context.getService(UploaderService.class);
    }

    private static void setClassLoaderIfNecessary() {
        ClassLoader thisLoader = FilesUploader.class.getClassLoader();
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (thisLoader != loader) continue;
            return;
        }
        Thread.currentThread().setContextClassLoader(thisLoader);
    }

    @Deprecated
    public FilesUploader(FilesCollection files, String updateSite) {
        this(FilesUploader.createUploaderService(), files, updateSite);
    }

    @Deprecated
    public FilesUploader(UploaderService uploaderService, FilesCollection files, String updateSite) {
        this(uploaderService, files, updateSite, null);
    }

    public FilesUploader(UploaderService uploaderService, FilesCollection files, String updateSite, Progress progress) {
        if (uploaderService == null) {
            uploaderService = FilesUploader.createUploaderService();
        }
        this.files = files;
        this.siteName = updateSite;
        this.site = files.getUpdateSite(updateSite, false);
        this.compressed = "db.xml.gz";
        String protocol = this.site.getUploadProtocol();
        this.uploader = uploaderService.installUploader(protocol, files, progress == null ? new StderrProgress() : progress);
        if (this.uploader == null) {
            throw new IllegalArgumentException("No uploader found for protocol " + protocol);
        }
    }

    public boolean hasUploader() {
        return this.uploader != null;
    }

    public FilesCollection getFilesCollection() {
        return this.files;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getDefaultUsername() {
        int at;
        String host = this.site.getHost();
        if (host.startsWith("sftp:")) {
            host = host.substring(5);
        }
        if ((at = host.indexOf(64)) > 0) {
            return host.substring(0, at);
        }
        String name = UpdaterUserInterface.get().getPref("imagej.updater.login");
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getUploadHost() {
        String protocol;
        String host = this.site.getHost();
        if (this.uploader != null && (protocol = this.uploader.getProtocol()) != null && host.startsWith(protocol + ":")) {
            host = host.substring(protocol.length() + 1);
        }
        return host.substring(host.indexOf(64) + 1);
    }

    public String getUploadDirectory() {
        return this.site.getUploadDirectory();
    }

    public void upload(Progress progress) throws Exception {
        UploadableFile file2;
        if (this.uploader == null) {
            throw new RuntimeException("No uploader set for " + this.site.getHost());
        }
        if (!this.loggedIn) {
            throw new RuntimeException("Not logged in!");
        }
        Iterable<Conflicts.Conflict> conflicts = new Conflicts(this.files).getConflicts(true);
        if (Conflicts.needsFeedback(conflicts)) {
            throw new RuntimeException("Unresolved upload conflicts!\n\n" + UpdaterUtil.join("\n", conflicts));
        }
        this.uploader.addProgress(progress);
        this.uploader.addProgress(new VerifyTimestamp());
        this.uploadables = new ArrayList<Uploadable>();
        ArrayList<String> locks = new ArrayList<String>();
        this.uploadables.add(new DbXmlFile());
        for (FileObject file3 : this.files.forUpdateSite(this.siteName)) {
            if (file3.getAction() != FileObject.Action.INSTALLED || !file3.metadataChanged || file3.localFilename == null || file3.localFilename.equals(file3.filename)) continue;
            file3.addPreviousVersion(file3.current.checksum, file3.current.timestamp, file3.filename);
            file3.setAction(this.files, FileObject.Action.UPLOAD);
        }
        for (FileObject file3 : this.files.toUpload(this.siteName)) {
            Iterator<Dependency> iter = file3.getDependencies().iterator();
            while (iter.hasNext()) {
                String filename = iter.next().filename;
                FileObject other = this.files.get(filename);
                if (other != null && !other.isObsolete()) continue;
                this.files.log.warn("Removed obsolete dependency " + filename + " of " + file3.filename);
                iter.remove();
            }
            this.uploadables.add(new UploadableFile(this.files, file3));
        }
        locks.add("db.xml.gz");
        long[] timestamps = new long[this.uploadables.size()];
        int counter = 0;
        for (Uploadable uploadable : this.uploadables) {
            if (uploadable instanceof UploadableFile) {
                file2 = (UploadableFile)uploadable;
                timestamps[counter] = UpdaterUtil.getTimestamp(file2.source);
            }
            this.verifyUnchanged(uploadable, true);
            ++counter;
        }
        this.uploader.upload(this.uploadables, locks);
        counter = 0;
        for (Uploadable uploadable : this.uploadables) {
            if (uploadable instanceof UploadableFile) {
                file2 = (UploadableFile)uploadable;
                if (timestamps[counter] != UpdaterUtil.getTimestamp(file2.source)) {
                    throw new RuntimeException("Timestamp of " + file2.getFilename() + "changed since being checksummed (was " + timestamps[counter] + " but is " + UpdaterUtil.getTimestamp(file2.source) + "!)");
                }
            }
            ++counter;
        }
        this.site.setLastModified(this.getCurrentLastModified());
    }

    protected void verifyUnchanged(Uploadable file2, boolean checkTimestamp) {
        if (!(file2 instanceof UploadableFile)) {
            return;
        }
        UploadableFile uploadable = (UploadableFile)file2;
        long size = uploadable.source.length();
        if (uploadable.filesize != size) {
            throw new RuntimeException("File size of " + uploadable.file.filename + " changed since being checksummed (was " + uploadable.filesize + " but is " + size + ")!");
        }
        if (checkTimestamp) {
            long stored;
            long l = stored = uploadable.file.getStatus() == FileObject.Status.LOCAL_ONLY ? uploadable.file.current.timestamp : uploadable.file.localTimestamp;
            if (stored != UpdaterUtil.getTimestamp(uploadable.source)) {
                throw new RuntimeException("Timestamp of " + uploadable.file.filename + " changed since being checksummed (was " + stored + " but is " + UpdaterUtil.getTimestamp(uploadable.source) + ")!");
            }
        }
    }

    protected void updateUploadTimestamp(long timestamp) throws Exception {
        for (Uploadable f : this.uploadables) {
            if (!(f instanceof UploadableFile)) continue;
            UploadableFile uploadable = (UploadableFile)f;
            FileObject file2 = uploadable.file;
            if (file2 == null) continue;
            file2.filesize = uploadable.filesize = uploadable.source.length();
            file2.localTimestamp = timestamp;
            uploadable.filename = file2.filename + "-" + timestamp;
            if (file2.getStatus() != FileObject.Status.LOCAL_ONLY) continue;
            file2.setStatus(FileObject.Status.INSTALLED);
            file2.current.timestamp = timestamp;
        }
        XMLFileWriter writer = new XMLFileWriter(this.files.clone(this.files.forUpdateSite(this.siteName, true)));
        if (this.files.size() > 0) {
            writer.validate(false);
        }
        ((DbXmlFile)this.uploadables.get((int)0)).bytes = writer.toCompressedByteArray(false);
        this.uploader.calculateTotalSize(this.uploadables);
    }

    protected long getCurrentLastModified() {
        try {
            URLConnection connection;
            try {
                connection = this.files.util.openConnection(new URL(this.site.getURL() + "db.xml.gz"));
            }
            catch (FileNotFoundException e) {
                this.files.log.error(e);
                Thread.sleep(500L);
                connection = this.files.util.openConnection(new URL(this.site.getURL() + "db.xml.gz"));
            }
            connection.setUseCaches(false);
            long lastModified = connection.getLastModified();
            connection.getInputStream().close();
            UpdaterUserInterface.get().debug("got last modified " + lastModified + " = timestamp " + UpdaterUtil.timestamp(lastModified));
            return lastModified;
        }
        catch (Exception e) {
            UpdaterUserInterface.get().debug(e.getMessage());
            if (this.files.size() == 0) {
                return -1L;
            }
            if (e instanceof FileNotFoundException) {
                this.files.log.debug(e);
            } else {
                this.files.log.error(e);
            }
            return 0L;
        }
    }

    protected void verifyTimestamp() {
        if (this.site.getTimestamp() == 0L) {
            return;
        }
        long lastModified = this.getCurrentLastModified();
        if (!this.site.isLastModified(lastModified)) {
            throw new RuntimeException("db.xml.gz was changed in the meantime (was " + this.site.getTimestamp() + " but now is " + UpdaterUtil.timestamp(lastModified) + ")");
        }
    }

    public boolean login() {
        if (this.loggedIn) {
            return this.loggedIn;
        }
        this.loggedIn = this.uploader.login(this);
        return this.loggedIn;
    }

    public void logout() {
        if (this.uploader != null) {
            this.uploader.logout();
        }
    }

    @Deprecated
    public static FilesUploader initialUpload(String url, String sshHost, String uploadDirectory) {
        return FilesUploader.initialUploader(null, url, sshHost, uploadDirectory, null);
    }

    public static FilesUploader initialUploader(UploaderService uploaderService, String url, String sshHost, String uploadDirectory, Progress progress) {
        String updateSiteName = "Dummy";
        FilesCollection files = new FilesCollection(null);
        files.addUpdateSite("Dummy", url, sshHost, uploadDirectory, Long.parseLong(UpdaterUtil.timestamp(-1L)));
        return new FilesUploader(uploaderService, files, "Dummy", progress);
    }

    public LogService getLog() {
        return this.files.log;
    }

    protected class VerifyTimestamp
    implements Progress {
        protected VerifyTimestamp() {
        }

        @Override
        public void addItem(Object item) {
            if (item != FilesUploader.this.uploadables.get(0)) {
                return;
            }
            FilesUploader.this.verifyTimestamp();
        }

        @Override
        public void setTitle(String string) {
            try {
                FilesUploader.this.updateUploadTimestamp(FilesUploader.this.uploader.getTimestamp());
            }
            catch (Exception e) {
                ((FilesUploader)FilesUploader.this).files.log.error(e);
                throw new RuntimeException("Could not update the timestamps in db.xml.gz");
            }
        }

        @Override
        public void itemDone(Object item) {
            if (item instanceof UploadableFile) {
                FilesUploader.this.verifyUnchanged((UploadableFile)item, false);
            }
        }

        @Override
        public void setCount(int count, int total) {
        }

        @Override
        public void setItemCount(int count, int total) {
        }

        @Override
        public void done() {
        }
    }

    protected class DbXmlFile
    implements Uploadable {
        public byte[] bytes;

        protected DbXmlFile() {
        }

        @Override
        public String getFilename() {
            return FilesUploader.this.compressed + ".lock";
        }

        @Override
        public String getPermissions() {
            return "C0444";
        }

        @Override
        public long getFilesize() {
            return this.bytes.length;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public String toString() {
            return FilesUploader.this.compressed;
        }
    }
}

