/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import net.imagej.updater.Checksummer;
import net.imagej.updater.Conflicts;
import net.imagej.updater.Dependency;
import net.imagej.updater.FileObject;
import net.imagej.updater.GroupAction;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.UploaderService;
import net.imagej.updater.XMLFileDownloader;
import net.imagej.updater.XMLFileReader;
import net.imagej.updater.XMLFileWriter;
import net.imagej.updater.action.InstallOrUpdate;
import net.imagej.updater.action.KeepAsIs;
import net.imagej.updater.action.Remove;
import net.imagej.updater.action.Uninstall;
import net.imagej.updater.action.Upload;
import net.imagej.updater.util.DependencyAnalyzer;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.UpdateCanceledException;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.log.LogService;
import org.xml.sax.SAXException;

public class FilesCollection
extends LinkedHashMap<String, FileObject>
implements Iterable<FileObject> {
    public static final String DEFAULT_UPDATE_SITE = "ImageJ";
    private File imagejRoot;
    public final LogService log;
    protected Set<FileObject> ignoredConflicts = new HashSet<FileObject>();
    protected List<Conflicts.Conflict> conflicts = new ArrayList<Conflicts.Conflict>();
    private Map<String, UpdateSite> updateSites;
    private boolean updateSitesChanged = false;
    private DependencyAnalyzer dependencyAnalyzer;
    public final UpdaterUtil util;

    public FilesCollection(File imagejRoot) {
        this(UpdaterUtil.getLogService(), imagejRoot);
    }

    public FilesCollection(LogService log, File imagejRoot) {
        this.log = log;
        this.imagejRoot = imagejRoot;
        this.util = new UpdaterUtil(imagejRoot);
        this.updateSites = new LinkedHashMap<String, UpdateSite>();
        UpdateSite updateSite = this.addUpdateSite(DEFAULT_UPDATE_SITE, UpdaterUtil.MAIN_URL, null, null, this.timestamp());
        updateSite.setOfficial(true);
    }

    public UpdateSite addUpdateSite(String name, String url, String sshHost, String uploadDirectory, long timestamp) {
        UpdateSite site = new UpdateSite(name, url, sshHost, uploadDirectory, null, null, timestamp);
        site.setActive(true);
        return this.addUpdateSite(site);
    }

    public UpdateSite addUpdateSite(UpdateSite site) {
        this.addUpdateSite(site.getName(), site);
        return site;
    }

    protected void addUpdateSite(String name, UpdateSite updateSite) {
        UpdateSite already = this.updateSites.get(name);
        int n = updateSite.rank = already != null ? already.rank : this.updateSites.size();
        if (already != null) {
            updateSite.setOfficial(already.isOfficial());
        }
        this.updateSites.put(name, updateSite);
        if (updateSite != already) {
            this.setUpdateSitesChanged(true);
        }
    }

    public void renameUpdateSite(String oldName, String newName) {
        if (this.getUpdateSite(newName, true) != null) {
            throw new RuntimeException("Update site " + newName + " exists already!");
        }
        if (this.getUpdateSite(oldName, true) == null) {
            throw new RuntimeException("Update site " + oldName + " does not exist!");
        }
        for (FileObject file2 : this) {
            if (!oldName.equals(file2.updateSite)) continue;
            file2.updateSite = newName;
        }
        Map<String, UpdateSite> oldMap = this.updateSites;
        this.updateSites = new LinkedHashMap<String, UpdateSite>();
        for (String name : oldMap.keySet()) {
            UpdateSite site = oldMap.get(name);
            if (name.equals(oldName)) {
                site.setName(newName);
            }
            this.addUpdateSite(site.getName(), site);
        }
    }

    public void removeUpdateSite(String name) {
        for (FileObject file2 : this.clone(this.forUpdateSite(name))) {
            file2.removeFromUpdateSite(name, this);
        }
        this.updateSites.remove(name);
        this.setUpdateSitesChanged(true);
        int counter = 1;
        for (Map.Entry<String, UpdateSite> entry : this.updateSites.entrySet()) {
            entry.getValue().rank = counter++;
        }
    }

    @Deprecated
    public UpdateSite getUpdateSite(String name) {
        return this.getUpdateSite(name, false);
    }

    public UpdateSite getUpdateSite(String name, boolean evenDisabled) {
        if (name == null) {
            return null;
        }
        UpdateSite site = this.updateSites.get(name);
        return evenDisabled || site == null || site.isActive() ? site : null;
    }

    @Deprecated
    public Collection<String> getUpdateSiteNames() {
        return this.getUpdateSiteNames(false);
    }

    public Collection<String> getUpdateSiteNames(boolean evenDisabled) {
        if (evenDisabled) {
            return this.updateSites.keySet();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, UpdateSite> entry : this.updateSites.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Collection<UpdateSite> getUpdateSites(boolean evenDisabled) {
        if (evenDisabled) {
            return this.updateSites.values();
        }
        ArrayList<UpdateSite> result = new ArrayList<UpdateSite>();
        for (UpdateSite site : this.updateSites.values()) {
            if (!site.isActive()) continue;
            result.add(site);
        }
        return result;
    }

    public Collection<String> getSiteNamesToUpload() {
        HashSet<String> set = new HashSet<String>();
        for (FileObject file2 : this.toUpload(false)) {
            set.add(file2.updateSite);
        }
        for (FileObject file2 : this.toRemove()) {
            set.add(file2.updateSite);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.getUpdateSiteNames(false)) {
            if (!set.contains(name)) continue;
            result.add(name);
        }
        if (result.size() != set.size()) {
            throw new RuntimeException("Unknown update site in " + ((Object)set).toString() + " (known: " + ((Object)result).toString() + ")");
        }
        return result;
    }

    public boolean hasUploadableSites() {
        for (UpdateSite site : this.updateSites.values()) {
            if (!site.isActive() || !site.isUploadable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpdateSitesChanges() {
        return this.updateSitesChanged;
    }

    public void setUpdateSitesChanged(boolean updateSitesChanged) {
        this.updateSitesChanged = updateSitesChanged;
    }

    public int deactivateUpdateSite(UpdateSite site) {
        if (!site.isActive()) {
            return 0;
        }
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        String updateSite = site.getName();
        for (FileObject file2 : this.forUpdateSite(updateSite)) {
            list.add(file2);
        }
        for (FileObject file2 : list) {
            file2.removeFromUpdateSite(updateSite, this);
        }
        site.setActive(false);
        return list.size();
    }

    public void activateUpdateSite(UpdateSite updateSite, Progress progress) throws ParserConfigurationException, IOException, SAXException {
        if (updateSite.isActive()) {
            return;
        }
        updateSite.setActive(true);
        this.reReadUpdateSite(updateSite.getName(), progress);
        this.markForUpdate(updateSite.getName(), false);
    }

    private void markForUpdate(String updateSite, boolean evenForcedUpdates) {
        for (FileObject file2 : this.forUpdateSite(updateSite)) {
            if (!file2.isUpdateable(evenForcedUpdates) && !file2.getStatus().isValid(FileObject.Action.INSTALL) || !file2.isUpdateablePlatform(this)) continue;
            file2.setFirstValidAction(this, FileObject.Action.UPDATE, FileObject.Action.UNINSTALL, FileObject.Action.INSTALL);
        }
    }

    public void reReadUpdateSite(String name, Progress progress) throws ParserConfigurationException, IOException, SAXException {
        new XMLFileReader(this).read(name);
        ArrayList<String> filesFromSite = new ArrayList<String>();
        for (FileObject file2 : this.forUpdateSite(name)) {
            filesFromSite.add(file2.localFilename != null ? file2.localFilename : file2.filename);
        }
        Checksummer checksummer = new Checksummer(this, progress);
        checksummer.updateFromLocal(filesFromSite);
    }

    public String protocolsMissingUploaders(UploaderService uploaderService, Progress progress) {
        LinkedHashMap<String, LinkedHashSet<String>> map = new LinkedHashMap<String, LinkedHashSet<String>>();
        for (Map.Entry<String, UpdateSite> entry : this.updateSites.entrySet()) {
            UpdateSite site = entry.getValue();
            if (!site.isUploadable()) continue;
            String protocol = site.getUploadProtocol();
            try {
                uploaderService.installUploader(protocol, this, progress);
            }
            catch (IllegalArgumentException e) {
                LinkedHashSet<String> set = (LinkedHashSet<String>)map.get(protocol);
                if (set == null) {
                    set = new LinkedHashSet<String>();
                    map.put(protocol, set);
                }
                set.add(entry.getKey());
            }
        }
        if (map.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.prefixUpdate("").isDirectory() ? "Uploads via these protocols require a restart:\n" : "Missing uploaders:\n");
        for (Map.Entry entry : map.entrySet()) {
            String list = Arrays.toString(((Set)entry.getValue()).toArray());
            builder.append("'").append((String)entry.getKey()).append("': ").append(list).append("\n");
        }
        return builder.toString();
    }

    public Set<GroupAction> getValidActions() {
        LinkedHashSet<GroupAction> actions2 = new LinkedHashSet<GroupAction>();
        actions2.add(new KeepAsIs());
        boolean hasChanges = this.hasChanges();
        boolean hasUploadOrRemove = this.hasUploadOrRemove();
        if (!hasUploadOrRemove) {
            actions2.add(new InstallOrUpdate());
        }
        if (hasUploadOrRemove || !hasChanges) {
            Map<String, UpdateSite> updateSites;
            Collection<String> siteNames = this.getSiteNamesToUpload();
            if (siteNames.size() == 0) {
                updateSites = this.updateSites;
            } else {
                updateSites = new LinkedHashMap<String, UpdateSite>();
                for (String name : siteNames) {
                    updateSites.put(name, this.getUpdateSite(name, true));
                }
            }
            for (UpdateSite updateSite : this.getUpdateSites(false)) {
                if (!updateSite.isUploadable()) continue;
                String name = updateSite.getName();
                actions2.add(new Upload(name));
                actions2.add(new Remove(name));
            }
        }
        if (!hasUploadOrRemove) {
            actions2.add(new Uninstall());
        }
        return actions2;
    }

    public Set<GroupAction> getValidActions(Iterable<FileObject> selected) {
        Set<GroupAction> actions2 = this.getValidActions();
        Iterator<GroupAction> iter = actions2.iterator();
        block0: while (iter.hasNext()) {
            GroupAction action = iter.next();
            for (FileObject file2 : selected) {
                if (action.isValid(this, file2)) continue;
                iter.remove();
                continue block0;
            }
        }
        return actions2;
    }

    @Deprecated
    public FileObject.Action[] getActions(FileObject file2) {
        return file2.isUploadable(this, false) ? file2.getStatus().getDeveloperActions() : file2.getStatus().getActions();
    }

    @Deprecated
    public FileObject.Action[] getActions(Iterable<FileObject> files) {
        ArrayList<FileObject.Action> result = null;
        for (FileObject file2 : files) {
            FileObject.Action[] actions2 = this.getActions(file2);
            if (result == null) {
                result = new ArrayList<FileObject.Action>();
                for (FileObject.Action action : actions2) {
                    result.add(action);
                }
                continue;
            }
            TreeSet<FileObject.Action> set = new TreeSet<FileObject.Action>();
            for (FileObject.Action action : actions2) {
                set.add(action);
            }
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                if (set.contains(iter.next())) continue;
                iter.remove();
            }
        }
        if (result == null) {
            return new FileObject.Action[0];
        }
        return result.toArray(new FileObject.Action[result.size()]);
    }

    public void read() throws IOException, ParserConfigurationException, SAXException {
        this.read(this.prefix("db.xml.gz"));
    }

    public void read(File file2) throws IOException, ParserConfigurationException, SAXException {
        this.read(new FileInputStream(file2));
    }

    public void read(FileInputStream in) throws IOException, ParserConfigurationException, SAXException {
        new XMLFileReader(this).read(in);
        in.close();
    }

    public void write() throws IOException, SAXException, TransformerConfigurationException {
        File out = this.prefix("db.xml.gz");
        File tmp = this.prefix("db.xml.gz.tmp");
        new XMLFileWriter(this).write(new GZIPOutputStream(new FileOutputStream(tmp)), true);
        if (out.exists() && !out.delete()) {
            out.renameTo(this.prefix("db.xml.gz.backup"));
        }
        tmp.renameTo(out);
        this.setUpdateSitesChanged(false);
    }

    public FilesCollection clone(Iterable<FileObject> iterable) {
        FilesCollection result = new FilesCollection(this.imagejRoot);
        for (FileObject file2 : iterable) {
            result.add(file2);
        }
        for (String name : this.updateSites.keySet()) {
            result.updateSites.put(name, (UpdateSite)this.updateSites.get(name).clone());
        }
        return result;
    }

    public Iterable<FileObject> toUploadOrRemove() {
        return this.filter(this.or(this.is(FileObject.Action.UPLOAD), this.is(FileObject.Action.REMOVE)));
    }

    public Iterable<FileObject> toUpload() {
        return this.toUpload(false);
    }

    public Iterable<FileObject> toUpload(boolean includeMetadataChanges) {
        if (!includeMetadataChanges) {
            return this.filter(this.is(FileObject.Action.UPLOAD));
        }
        return this.filter(this.or(this.is(FileObject.Action.UPLOAD), new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.metadataChanged && file2.isUploadable(FilesCollection.this, false);
            }
        }));
    }

    public Iterable<FileObject> toUpload(String updateSite) {
        return this.filter(this.and(this.is(FileObject.Action.UPLOAD), this.isUpdateSite(updateSite)));
    }

    public Iterable<FileObject> toUninstall() {
        return this.filter(this.is(FileObject.Action.UNINSTALL));
    }

    public Iterable<FileObject> toRemove() {
        return this.filter(this.is(FileObject.Action.REMOVE));
    }

    public Iterable<FileObject> toUpdate() {
        return this.filter(this.is(FileObject.Action.UPDATE));
    }

    public Iterable<FileObject> upToDate() {
        return this.filter(this.is(FileObject.Action.INSTALLED));
    }

    public Iterable<FileObject> toInstall() {
        return this.filter(this.is(FileObject.Action.INSTALL));
    }

    public Iterable<FileObject> toInstallOrUpdate() {
        return this.filter(this.oneOf(FileObject.Action.INSTALL, FileObject.Action.UPDATE));
    }

    public Iterable<FileObject> notHidden() {
        return this.filter(this.and(this.not(this.is(FileObject.Status.OBSOLETE_UNINSTALLED)), this.doesPlatformMatch()));
    }

    public Iterable<FileObject> uninstalled() {
        return this.filter(this.is(FileObject.Status.NOT_INSTALLED));
    }

    public Iterable<FileObject> installed() {
        return this.filter(this.not(this.oneOf(FileObject.Status.LOCAL_ONLY, FileObject.Status.NOT_INSTALLED)));
    }

    public Iterable<FileObject> locallyModified() {
        return this.filter(this.oneOf(FileObject.Status.MODIFIED, FileObject.Status.OBSOLETE_MODIFIED));
    }

    public Iterable<FileObject> forUpdateSite(String name) {
        return this.forUpdateSite(name, false);
    }

    public Iterable<FileObject> forUpdateSite(String name, boolean includeObsoletes) {
        Filter filter = this.and(this.doesPlatformMatch(), this.isUpdateSite(name));
        if (!includeObsoletes) {
            filter = this.and(this.not(this.is(FileObject.Status.OBSOLETE_UNINSTALLED)), filter);
            return this.filter(filter);
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (FileObject file2 : this) {
            if (filter.matches(file2)) {
                result.add(file2);
                continue;
            }
            FileObject overridden = file2.overriddenUpdateSites.get(name);
            if (overridden == null) continue;
            result.add(overridden);
        }
        return result;
    }

    public Iterable<FileObject> managedFiles() {
        return this.filter(this.not(this.is(FileObject.Status.LOCAL_ONLY)));
    }

    public Iterable<FileObject> localOnly() {
        return this.filter(this.is(FileObject.Status.LOCAL_ONLY));
    }

    public Iterable<FileObject> shownByDefault() {
        FileObject.Status[] oneOf = new FileObject.Status[]{FileObject.Status.UPDATEABLE, FileObject.Status.NEW, FileObject.Status.OBSOLETE, FileObject.Status.OBSOLETE_MODIFIED};
        return this.filter(this.or(this.oneOf(oneOf), this.oneOf(FileObject.Action.INSTALL, FileObject.Action.UPDATE, FileObject.Action.UNINSTALL)));
    }

    public Iterable<FileObject> uploadable() {
        return this.uploadable(false);
    }

    public Iterable<FileObject> uploadable(final boolean assumeModified) {
        return this.filter(new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.isUploadable(FilesCollection.this, assumeModified);
            }
        });
    }

    public Iterable<FileObject> changes() {
        return this.filter(new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.getAction() != file2.getStatus().getNoAction();
            }
        });
    }

    public static Iterable<FileObject> filter(final Filter filter, final Iterable<FileObject> files) {
        return new Iterable<FileObject>(){

            @Override
            public Iterator<FileObject> iterator() {
                return new FilteredIterator(filter, files);
            }
        };
    }

    public static Iterable<FileObject> filter(String search, Iterable<FileObject> files) {
        final String keyword = search.trim().toLowerCase();
        return FilesCollection.filter(new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.getFilename().trim().toLowerCase().indexOf(keyword) >= 0;
            }
        }, files);
    }

    public Filter yes() {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return true;
            }
        };
    }

    public Filter doesPlatformMatch() {
        if (this.hasUploadableSites()) {
            return this.yes();
        }
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.isUpdateablePlatform(FilesCollection.this);
            }
        };
    }

    public Filter is(final FileObject.Action action) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.getAction() == action;
            }
        };
    }

    public Filter isNoAction() {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.getAction() == file2.getStatus().getNoAction();
            }
        };
    }

    public Filter oneOf(FileObject.Action ... actions2) {
        final HashSet<FileObject.Action> oneOf = new HashSet<FileObject.Action>();
        for (FileObject.Action action : actions2) {
            oneOf.add(action);
        }
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return oneOf.contains((Object)file2.getAction());
            }
        };
    }

    public Filter is(final FileObject.Status status) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.getStatus() == status;
            }
        };
    }

    public Filter hasMetadataChanges() {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.metadataChanged;
            }
        };
    }

    public Filter isUpdateSite(final String updateSite) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.updateSite != null && file2.updateSite.equals(updateSite);
            }
        };
    }

    public Filter oneOf(FileObject.Status ... states) {
        final HashSet<FileObject.Status> oneOf = new HashSet<FileObject.Status>();
        for (FileObject.Status status : states) {
            oneOf.add(status);
        }
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return oneOf.contains((Object)file2.getStatus());
            }
        };
    }

    public Filter startsWith(final String prefix) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.filename.startsWith(prefix);
            }
        };
    }

    public Filter startsWith(final String ... prefixes) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                for (String prefix : prefixes) {
                    if (!file2.filename.startsWith(prefix)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Filter endsWith(final String suffix) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.filename.endsWith(suffix);
            }
        };
    }

    public Filter not(final Filter filter) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return !filter.matches(file2);
            }
        };
    }

    public Filter or(final Filter a, final Filter b) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return a.matches(file2) || b.matches(file2);
            }
        };
    }

    public Filter and(final Filter a, final Filter b) {
        return new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return a.matches(file2) && b.matches(file2);
            }
        };
    }

    public Iterable<FileObject> filter(Filter filter) {
        return FilesCollection.filter(filter, (Iterable<FileObject>)this);
    }

    public FileObject getFileFromDigest(String filename, String digest) {
        for (FileObject file2 : this) {
            if (!file2.getFilename().equals(filename) || !file2.getChecksum().equals(digest)) continue;
            return file2;
        }
        return null;
    }

    public Iterable<String> analyzeDependencies(FileObject file2) {
        try {
            if (this.dependencyAnalyzer == null) {
                this.dependencyAnalyzer = new DependencyAnalyzer(this.imagejRoot);
            }
            return this.dependencyAnalyzer.getDependencies(this.imagejRoot, file2);
        }
        catch (IOException e) {
            this.log.error(e);
            return null;
        }
    }

    public void updateDependencies(FileObject file2) {
        Iterable<String> dependencies = this.analyzeDependencies(file2);
        if (dependencies == null) {
            return;
        }
        for (String dependency : dependencies) {
            file2.addDependency(dependency, this.prefix(dependency));
        }
    }

    public boolean has(Filter filter) {
        for (FileObject file2 : this) {
            if (!filter.matches(file2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanges() {
        return this.changes().iterator().hasNext();
    }

    public boolean hasUploadOrRemove() {
        return this.has(this.oneOf(FileObject.Action.UPLOAD, FileObject.Action.REMOVE));
    }

    public boolean hasForcableUpdates() {
        for (FileObject file2 : this.updateable(true)) {
            if (file2.isUpdateable(false)) continue;
            return true;
        }
        return false;
    }

    public Iterable<FileObject> updateable(final boolean evenForcedOnes) {
        return this.filter(new Filter(){

            @Override
            public boolean matches(FileObject file2) {
                return file2.isUpdateable(evenForcedOnes) && file2.isUpdateablePlatform(FilesCollection.this);
            }
        });
    }

    public void markForUpdate(boolean evenForcedUpdates) {
        for (FileObject file2 : this.updateable(evenForcedUpdates)) {
            file2.setFirstValidAction(this, FileObject.Action.UPDATE, FileObject.Action.UNINSTALL, FileObject.Action.INSTALL);
        }
    }

    public String getURL(FileObject file2) {
        String siteName = file2.updateSite;
        assert (siteName != null && !siteName.equals(""));
        UpdateSite site = this.getUpdateSite(siteName, false);
        if (site == null) {
            return null;
        }
        return site.getURL() + file2.filename.replace(" ", "%20") + "-" + file2.getTimestamp();
    }

    void addDependencies(FileObject file2, DependencyMap map, boolean overriding) {
        for (Dependency dependency : file2.getDependencies()) {
            FileObject other = this.get(dependency.filename);
            if (other == null || overriding != dependency.overrides || !other.isUpdateablePlatform(this)) continue;
            if (other.isObsolete() && other.willNotBeInstalled()) {
                this.log.debug("Ignoring obsolete dependency " + dependency.filename + " of " + file2.filename);
                continue;
            }
            if (!dependency.overrides ? other.willBeUpToDate() : other.willNotBeInstalled()) continue;
            if (!map.add(other, file2) || overriding) continue;
            this.addDependencies(other, map, overriding);
        }
    }

    public DependencyMap getDependencies(boolean overridingOnes) {
        return this.getDependencies(this.toInstallOrUpdate(), overridingOnes);
    }

    public DependencyMap getDependencies(Iterable<FileObject> files, boolean overridingOnes) {
        DependencyMap result = new DependencyMap();
        for (FileObject file2 : files) {
            this.addDependencies(file2, result, overridingOnes);
        }
        return result;
    }

    public void sort() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (FileObject file2 : this) {
            files.add(file2);
        }
        Collections.sort(files, new Comparator<FileObject>(){

            @Override
            public int compare(FileObject a, FileObject b) {
                int result = this.firstChar(a) - this.firstChar(b);
                return result != 0 ? result : a.filename.compareTo(b.filename);
            }

            int firstChar(FileObject file2) {
                char c = file2.filename.charAt(0);
                int index = "CIfpjsim".indexOf(c);
                return index < 0 ? 512 + c : index;
            }
        });
        this.clear();
        for (FileObject file2 : files) {
            super.put(file2.filename, file2);
        }
    }

    String checkForCircularDependency(FileObject file2, Set<FileObject> seen, String updateSite) {
        if (seen.contains(file2)) {
            return "";
        }
        String result = this.checkForCircularDependency(file2, seen, new HashSet<FileObject>(), updateSite);
        if (result == null) {
            return "";
        }
        int last = result.lastIndexOf(32);
        int off = result.lastIndexOf(result.substring(last), last - 1);
        return "Circular dependency detected: " + result.substring(off + 1) + "\n";
    }

    String checkForCircularDependency(FileObject file2, Set<FileObject> seen, Set<FileObject> chain, String updateSite) {
        if (seen.contains(file2)) {
            return null;
        }
        for (String dependency : file2.dependencies.keySet()) {
            FileObject dep = this.get(dependency);
            if (dep == null || updateSite != null && !updateSite.equals(dep.updateSite)) continue;
            if (chain.contains(dep)) {
                return " " + dependency;
            }
            chain.add(dep);
            String result = this.checkForCircularDependency(dep, seen, chain, updateSite);
            seen.add(dep);
            if (result != null) {
                return " " + dependency + " ->" + result;
            }
            chain.remove(dep);
        }
        return null;
    }

    public String checkConsistency() {
        Collection<String> uploadSiteNames = this.getSiteNamesToUpload();
        String uploadSiteName = uploadSiteNames.isEmpty() ? null : uploadSiteNames.iterator().next();
        StringBuilder result = new StringBuilder();
        HashSet<FileObject> circularChecked = new HashSet<FileObject>();
        for (FileObject file2 : this) {
            if (uploadSiteName != null && !uploadSiteName.equals(file2.updateSite) || file2.getAction() == FileObject.Action.REMOVE) continue;
            result.append(this.checkForCircularDependency(file2, circularChecked, uploadSiteName));
            Set<String> deps = file2.dependencies.keySet();
            if (deps.size() > 0 && file2.isObsolete() && file2.getAction() != FileObject.Action.UPLOAD) {
                result.append("Obsolete file " + file2 + " has dependencies: " + UpdaterUtil.join(", ", deps) + "!\n");
            }
            for (String dependency : deps) {
                FileObject dep = this.get(dependency);
                if (dep != null && dep.current != null) continue;
                result.append("The file " + file2 + " has the obsolete/local-only dependency " + dependency + "!\n");
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public File prefix(FileObject file2) {
        return this.prefix(file2.getFilename());
    }

    public File prefix(String path) {
        File file2 = new File(path);
        if (file2.isAbsolute()) {
            return file2;
        }
        assert (this.imagejRoot != null);
        return new File(this.imagejRoot, path);
    }

    public File prefixUpdate(String path) {
        return this.prefix("update/" + path);
    }

    public boolean fileExists(String filename) {
        return this.prefix(filename).exists();
    }

    @Override
    public String toString() {
        return UpdaterUtil.join(", ", this);
    }

    @Deprecated
    public FileObject get(int index) {
        throw new UnsupportedOperationException();
    }

    public void add(FileObject file2) {
        super.put(file2.getFilename(true), file2);
    }

    @Override
    public FileObject get(Object filename) {
        return (FileObject)super.get(FileObject.getFilename((String)filename, true));
    }

    @Override
    public FileObject put(String key, FileObject file2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileObject remove(Object file2) {
        if (file2 instanceof FileObject) {
            super.remove(((FileObject)file2).getFilename(true));
        }
        if (file2 instanceof String) {
            return (FileObject)super.remove(FileObject.getFilename((String)file2, true));
        }
        return null;
    }

    @Override
    public Iterator<FileObject> iterator() {
        final Iterator iterator = this.entrySet().iterator();
        return new Iterator<FileObject>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public FileObject next() {
                return (FileObject)((Map.Entry)iterator.next()).getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String downloadIndexAndChecksum(Progress progress) throws ParserConfigurationException, SAXException {
        try {
            this.read();
        }
        catch (FileNotFoundException e) {
            UpdateSite fiji;
            if (this.prefix("plugins/Fiji_Updater.jar").exists() && (fiji = this.getUpdateSite("Fiji", true)) == null) {
                this.addUpdateSite("Fiji", "http://update.fiji.sc/", null, null, 0L);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.clear();
        XMLFileDownloader downloader = new XMLFileDownloader(this);
        downloader.addProgress(progress);
        try {
            downloader.start(false);
        }
        catch (UpdateCanceledException e) {
            downloader.done();
            throw e;
        }
        new Checksummer(this, progress).updateFromLocal();
        for (FileObject file2 : this.upToDate()) {
            for (FileObject dependency : file2.getFileDependencies(this, false)) {
                if (dependency.getAction() != FileObject.Action.NOT_INSTALLED || !dependency.isUpdateablePlatform(this)) continue;
                dependency.setAction(this, FileObject.Action.INSTALL);
            }
        }
        return downloader.getWarnings();
    }

    public List<Conflicts.Conflict> getConflicts() {
        return this.conflicts;
    }

    public static String getInstalledVersions(File ijDirectory, Progress progress) {
        StringBuilder sb = new StringBuilder();
        FilesCollection files = new FilesCollection(ijDirectory);
        try {
            files.read();
        }
        catch (Exception e) {
            sb.append("Error while reading db.xml.gz: ").append(e.getMessage()).append("\n\n");
        }
        Checksummer checksummer = new Checksummer(files, progress);
        try {
            checksummer.updateFromLocal();
        }
        catch (UpdateCanceledException t) {
            return null;
        }
        Map<String, FileObject.Version> checksums = checksummer.getCachedChecksums();
        sb.append("Activated update sites:\n");
        for (UpdateSite site : files.getUpdateSites(false)) {
            sb.append(site.getName()).append(": ").append(site.getURL()).append(" (last check:").append(site.getTimestamp()).append(")\n");
        }
        boolean notUpToDateShown = false;
        for (Map.Entry<String, FileObject.Version> entry : checksums.entrySet()) {
            FileObject fileObject;
            String file2 = entry.getKey();
            if (file2.startsWith(":") && file2.length() == 41 || (fileObject = files.get(file2)) != null && fileObject.getStatus() == FileObject.Status.INSTALLED) continue;
            if (!notUpToDateShown) {
                sb.append("\nFiles not up-to-date:\n");
                notUpToDateShown = true;
            }
            FileObject.Version version = entry.getValue();
            String checksum = version.checksum;
            if (version.checksum != null && version.checksum.length() > 8) {
                StringBuilder rebuild = new StringBuilder();
                for (String element : checksum.split(":")) {
                    if (rebuild.length() > 0) {
                        rebuild.append(":");
                    }
                    if (element == null || element.length() <= 8) {
                        rebuild.append(element);
                        continue;
                    }
                    rebuild.append(element.substring(0, 8));
                }
                checksum = rebuild.toString();
            }
            sb.append("  ").append(checksum).append(" ");
            if (fileObject != null) {
                sb.append("(").append((Object)fileObject.getStatus()).append(") ");
            }
            sb.append(version.timestamp).append(" ");
            sb.append(file2).append("\n");
        }
        return sb.toString();
    }

    public Collection<String> getProtocols(Iterable<FileObject> selected) {
        LinkedHashSet<String> protocols = new LinkedHashSet<String>();
        for (FileObject file2 : selected) {
            UpdateSite site = this.getUpdateSite(file2.updateSite, false);
            if (site == null) continue;
            if (site.getHost() == null) {
                protocols.add("unknown(" + file2.filename + ")");
                continue;
            }
            protocols.add(site.getUploadProtocol());
        }
        return protocols;
    }

    private long timestamp() {
        if (this.imagejRoot == null) {
            return 0L;
        }
        return UpdaterUtil.getTimestamp(this.prefix("db.xml.gz"));
    }

    public static class DependencyMap
    extends HashMap<FileObject, FilesCollection> {
        public boolean add(FileObject dependency, FileObject dependencee) {
            if (this.containsKey(dependency)) {
                ((FilesCollection)this.get(dependency)).add(dependencee);
                return false;
            }
            FilesCollection list = new FilesCollection(null);
            list.add(dependencee);
            this.put(dependency, list);
            return true;
        }
    }

    public static class FilteredIterator
    implements Iterator<FileObject> {
        Filter filter;
        boolean opposite;
        Iterator<FileObject> iterator;
        FileObject next;

        FilteredIterator(Filter filter, Iterable<FileObject> files) {
            this.filter = filter;
            this.iterator = files.iterator();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FileObject next() {
            FileObject file2 = this.next;
            this.findNext();
            return file2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void findNext() {
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (!this.filter.matches(this.next)) continue;
                return;
            }
            this.next = null;
        }
    }

    public static interface Filter {
        public boolean matches(FileObject var1);
    }
}

