/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.imagej.updater.AbstractUploader;
import net.imagej.updater.Uploadable;
import net.imagej.updater.Uploader;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.plugin.Plugin;

@Plugin(type=Uploader.class)
public class FileUploader
extends AbstractUploader {
    @Override
    public synchronized void upload(List<Uploadable> sources, List<String> locks) throws IOException {
        File file2;
        this.timestamp = Long.parseLong(UpdaterUtil.timestamp(System.currentTimeMillis()));
        this.setTitle("Uploading");
        this.calculateTotalSize(sources);
        int count = 0;
        byte[] buffer = new byte[65536];
        for (Uploadable source : sources) {
            int read;
            file2 = new File(this.uploadDir, source.getFilename());
            File dir = file2.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file2);
            InputStream in = source.getInputStream();
            this.addItem(source);
            int currentCount = 0;
            int currentTotal = (int)source.getFilesize();
            while ((read = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, read);
                this.setItemCount(currentCount += read, currentTotal);
                this.setCount(count + currentCount, this.total);
            }
            in.close();
            ((OutputStream)out).close();
            count += currentCount;
            this.itemDone(source);
        }
        for (String lock : locks) {
            file2 = new File(this.uploadDir, lock);
            File lockFile = new File(this.uploadDir, lock + ".lock");
            File backup = new File(this.uploadDir, lock + ".old");
            if (backup.exists()) {
                backup.delete();
            }
            if (file2.exists() && !file2.renameTo(backup)) {
                throw new IOException("Could not rename " + file2 + " to " + backup);
            }
            if (lockFile.renameTo(file2)) continue;
            throw new IOException("Could not rename " + lockFile + " to " + file2);
        }
        this.done();
    }

    @Override
    public String getProtocol() {
        return "file";
    }
}

