/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.imagej.updater.Checksummer;
import net.imagej.updater.Dependency;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.util.UpdaterUtil;

public class Conflicts {
    private final FilesCollection files;
    protected List<Conflict> conflicts;

    public Conflicts(FilesCollection files) {
        this.files = files;
    }

    public Iterable<Conflict> getConflicts(boolean forUpload) {
        this.conflicts = new ArrayList<Conflict>();
        if (!forUpload) {
            this.listUpdateIssues();
        } else {
            this.listUploadIssues();
        }
        return this.conflicts;
    }

    protected void listUpdateIssues() {
        FilesCollection.DependencyMap toInstall = this.files.getDependencies(false);
        FilesCollection.DependencyMap obsoleted = this.files.getDependencies(true);
        LinkedHashSet<FileObject> automatic = new LinkedHashSet<FileObject>();
        for (FileObject file2 : toInstall.keySet()) {
            if (obsoleted.get(file2) != null) {
                this.conflicts.add(this.bothInstallAndUninstall(file2, (FilesCollection)toInstall.get(file2), (FilesCollection)obsoleted.get(file2)));
                continue;
            }
            if (file2.willBeUpToDate()) continue;
            if (file2.isLocallyModified()) {
                if (this.files.ignoredConflicts.contains(file2)) continue;
                this.conflicts.add(this.locallyModified(file2, (FilesCollection)toInstall.get(file2)));
                continue;
            }
            automatic.add(file2);
        }
        for (FileObject file2 : obsoleted.keySet()) {
            if (toInstall.get(file2) == null && file2.willNotBeInstalled()) continue;
            this.conflicts.add(this.needUninstall(file2, (FilesCollection)obsoleted.get(file2)));
        }
        if (automatic.size() > 0) {
            for (FileObject file2 : automatic) {
                file2.setFirstValidAction(this.files, FileObject.Action.UPDATE, FileObject.Action.INSTALL);
            }
            this.conflicts.add(new Notice("There are files which need to be updated/installed since other files depend on them:\n" + UpdaterUtil.join(", ", automatic)));
        }
    }

    protected Conflict bothInstallAndUninstall(FileObject file2, FilesCollection installReasons, FilesCollection obsoleteReasons) {
        return new Conflict(Conflict.Severity.ERROR, file2, "Required by \n\n" + installReasons + "\nbut made obsolete by\n\n" + obsoleteReasons, this.ignoreResolution("Ignore this issue", file2), this.actionResolution("Do not update " + installReasons, installReasons, new FileObject.Action[0]));
    }

    protected Conflict needUninstall(FileObject file2, FilesCollection obsoleteReasons) {
        return new Conflict(Conflict.Severity.ERROR, file2, "Locally modified but made obsolete by\n\n" + obsoleteReasons, this.actionResolution("Uninstall " + file2, file2, FileObject.Action.UNINSTALL), this.actionResolution("Do not update " + obsoleteReasons, obsoleteReasons, new FileObject.Action[0]));
    }

    protected Conflict locallyModified(FileObject file2, FilesCollection installReasons) {
        boolean toInstall = file2.getStatus().isValid(FileObject.Action.INSTALL);
        return new Conflict(Conflict.Severity.WARNING, file2, "Locally modified and the Updater cannot determine its status. A newer version might be required by\n\n" + installReasons, this.ignoreResolution("Keep the local version", file2), this.actionResolution((toInstall ? "Install" : "Update") + " " + file2, file2, toInstall ? FileObject.Action.INSTALL : FileObject.Action.UPDATE));
    }

    protected void listUploadIssues() {
        FilesCollection.DependencyMap needsUpload = new FilesCollection.DependencyMap();
        for (FileObject file2 : this.files.toUpload()) {
            if (file2.getTimestamp() != UpdaterUtil.getTimestamp(this.files.prefix(file2))) {
                this.conflicts.add(this.timestampChanged(file2));
            }
            for (Dependency dependency : file2.getDependencies()) {
                FileObject dep = this.files.get(dependency.filename);
                if (dep == null || this.files.ignoredConflicts.contains(dep) || dep.getAction() == FileObject.Action.UPLOAD || !dep.isInstallable() && !dep.isLocalOnly() && !dep.isObsolete() && !dep.getStatus().isValid(FileObject.Action.UPLOAD)) continue;
                needsUpload.add(dep, file2);
            }
            if (this.files.ignoredConflicts.contains(file2) || !file2.filename.endsWith(".jar")) continue;
            String baseName = file2.getBaseName();
            int slash = baseName.lastIndexOf(47);
            String prefix = baseName.substring(0, slash + 1);
            baseName = baseName.substring(slash + 1);
            for (String name : this.files.prefix(file2).getParentFile().list()) {
                String prefixed = prefix + name;
                if (!name.startsWith(baseName) || file2.filename.equals(prefixed) || !file2.getFilename(true).equals(FileObject.getFilename(prefixed, true))) continue;
                this.conflicts.add(this.conflictingVersions(file2, this.files.prefix(prefixed), prefixed));
            }
        }
        for (FileObject file2 : needsUpload.keySet()) {
            this.conflicts.add(this.needUpload(file2, (FilesCollection)needsUpload.get(file2)));
        }
        HashSet<String> sites = new HashSet<String>(this.files.getSiteNamesToUpload());
        for (FileObject file3 : this.files.managedFiles()) {
            if (file3.getAction() == FileObject.Action.REMOVE || file3.isObsolete() || sites.size() > 0 && !sites.contains(file3.updateSite)) continue;
            for (Dependency dependency : file3.getDependencies()) {
                FileObject dependencyObject = this.files.get(dependency.filename);
                if (dependency.overrides) {
                    if (dependencyObject == null || dependencyObject.isObsolete() || dependencyObject.willNotBeInstalled()) continue;
                    this.conflicts.add(this.dependencyObsoleted(file3, dependencyObject));
                    continue;
                }
                if (dependencyObject != null && dependencyObject.getAction() == FileObject.Action.UPLOAD) continue;
                if (dependencyObject == null || dependencyObject.getStatus() == FileObject.Status.LOCAL_ONLY) {
                    this.conflicts.add(this.dependencyNotUploaded(file3, dependency.filename));
                    continue;
                }
                if (!dependencyObject.isObsolete() && (dependencyObject.getAction() != FileObject.Action.REMOVE || dependencyObject.overridesOtherUpdateSite())) continue;
                this.conflicts.add(this.dependencyRemoved(file3, dependency.filename));
            }
        }
    }

    protected Conflict timestampChanged(final FileObject file2) {
        return new Conflict(Conflict.Severity.ERROR, file2, "The timestamp of " + file2 + " changed in the meantime", new Resolution("Recalculate checksum and dependencies of " + file2){

            @Override
            public void resolve() {
                Checksummer checksummer = new Checksummer(Conflicts.this.files, null);
                checksummer.updateFromLocal(Collections.singletonList(file2.getFilename()));
                Conflicts.this.files.updateDependencies(file2);
            }
        });
    }

    protected Conflict needUpload(final FileObject file2, final FilesCollection uploadReasons) {
        boolean localOnly = file2.isLocalOnly();
        boolean notInstalled = file2.isInstallable();
        boolean obsolete = file2.isObsolete();
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        if (!localOnly && !obsolete) {
            resolutions.add(this.ignoreResolution("Do not upload " + file2, file2));
        }
        if (!notInstalled) {
            resolutions.add(this.actionResolution("Upload " + file2 + (obsolete ? " again" : ""), file2, FileObject.Action.UPLOAD));
        }
        resolutions.add(new Resolution("Break the dependency"){

            @Override
            public void resolve() {
                for (FileObject other : uploadReasons) {
                    other.removeDependency(file2.getFilename());
                }
            }
        });
        return new Conflict(localOnly || obsolete ? Conflict.Severity.CRITICAL_ERROR : Conflict.Severity.ERROR, file2, (localOnly ? "Not uploaded yet" : "Is " + (notInstalled ? "not installed" : (obsolete ? "marked obsolete" : "locally modified"))) + " but a dependency of\n\n" + uploadReasons, resolutions.toArray(new Resolution[resolutions.size()]));
    }

    private Conflict dependencyObsoleted(final FileObject obsoleting, final FileObject obsoleted) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        resolutions.add(new Resolution("Do not obsolete " + obsoleted.getFilename()){

            @Override
            public void resolve() {
                obsoleting.removeDependency(obsoleted.getFilename());
            }
        });
        if (obsoleting.updateSite.equals(obsoleted.updateSite)) {
            resolutions.add(new Resolution("Remove " + obsoleted.getFilename() + " from the Update Site"){

                @Override
                public void resolve() {
                    obsoleted.setAction(Conflicts.this.files, FileObject.Action.REMOVE);
                    Conflicts.this.files.prefix(obsoleted).delete();
                }
            });
        }
        return new Conflict(Conflict.Severity.ERROR, obsoleted, "The file " + obsoleting.getFilename() + " overrides the file " + obsoleted.getFilename() + ", but " + obsoleted.getFilename() + " was not removed", resolutions.toArray(new Resolution[resolutions.size()]));
    }

    protected Conflict dependencyNotUploaded(FileObject file2, String dependency) {
        return new Conflict(Conflict.Severity.ERROR, file2, "Depends on " + dependency + " which was not uploaded.", this.dependencyResolution("Break the dependency", file2, dependency, null));
    }

    protected Conflict dependencyRemoved(FileObject file2, String dependency) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        resolutions.add(this.dependencyResolution("Break the dependency", file2, dependency, null));
        for (FileObject toUpload : this.files.toUpload()) {
            if (file2.hasDependency(toUpload.getFilename())) continue;
            resolutions.add(this.dependencyResolution("Replace with dependency to " + toUpload, file2, dependency, toUpload.getFilename()));
            resolutions.add(this.dependencyResolution("Replace all dependencies on " + dependency + " with " + toUpload, null, dependency, toUpload.getFilename()));
        }
        return new Conflict(Conflict.Severity.ERROR, file2, "Depends on " + dependency + " which is about to be removed.", resolutions.toArray(new Resolution[resolutions.size()]));
    }

    protected Conflict conflictingVersions(FileObject file2, File otherFile, String otherFileName) {
        return new Conflict(Conflict.Severity.ERROR, file2, "Conflicting version found: " + otherFileName, this.deleteFile("Delete " + otherFileName + " (dangerous!)", otherFile), this.ignoreResolution("Ignore the problem (also dangerous!)", file2));
    }

    protected Resolution ignoreResolution(String description, final FileObject file2) {
        return new Resolution(description){

            @Override
            public void resolve() {
                ((Conflicts)Conflicts.this).files.ignoredConflicts.add(file2);
            }
        };
    }

    protected Resolution deleteFile(String description, final File file2) {
        return new Resolution(description){

            @Override
            public void resolve() {
                file2.delete();
            }
        };
    }

    protected Resolution actionResolution(String description, FileObject file2, FileObject.Action ... actionsToTry) {
        return this.actionResolution(description, Collections.singleton(file2), actionsToTry);
    }

    protected Resolution actionResolution(String description, final Iterable<FileObject> files, final FileObject.Action ... actionsToTry) {
        return new Resolution(description){

            @Override
            public void resolve() {
                for (FileObject file2 : files) {
                    file2.setFirstValidAction(Conflicts.this.files, actionsToTry);
                }
            }
        };
    }

    protected Resolution dependencyResolution(String description, final FileObject file2, final String removeDependency, final String addDependency) {
        return new Resolution(description){

            @Override
            public void resolve() {
                if (file2 != null) {
                    Conflicts.this.replaceDependency(file2, removeDependency, addDependency);
                } else {
                    for (FileObject file22 : Conflicts.this.files) {
                        if (!file22.hasDependency(removeDependency)) continue;
                        Conflicts.this.replaceDependency(file22, removeDependency, addDependency);
                    }
                }
            }
        };
    }

    protected void replaceDependency(FileObject file2, String removeDependency, String addDependency) {
        file2.removeDependency(removeDependency);
        if (addDependency != null) {
            file2.addDependency(addDependency, this.files.prefix(addDependency));
        }
    }

    public boolean hasDownloadConflicts() {
        this.conflicts = new ArrayList<Conflict>();
        this.listUpdateIssues();
        return this.conflicts.size() > 0;
    }

    public boolean hasUploadConflicts() {
        this.conflicts = new ArrayList<Conflict>();
        this.listUploadIssues();
        return this.conflicts.size() > 0;
    }

    public static boolean needsFeedback(Iterable<Conflict> conflicts) {
        if (conflicts == null) {
            return false;
        }
        for (Conflict conflict : conflicts) {
            if (conflict instanceof Notice) continue;
            return true;
        }
        return false;
    }

    public static abstract class Resolution {
        private final String description;

        public Resolution(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public abstract void resolve();
    }

    public static class Notice
    extends Conflict {
        public Notice(String message) {
            super(Conflict.Severity.NOTICE, (String)null, message, new Resolution[0]);
        }
    }

    public static class Conflict {
        private final Severity severity;
        protected final String filename;
        private final String conflict;
        protected final Resolution[] resolutions;

        @Deprecated
        public Conflict(FileObject file2, String conflict, Resolution ... resolutions) {
            this(Severity.ERROR, file2, conflict, resolutions);
        }

        @Deprecated
        public Conflict(boolean isError, FileObject file2, String conflict, Resolution ... resolutions) {
            this(isError ? Severity.ERROR : Severity.WARNING, file2, conflict, resolutions);
        }

        @Deprecated
        public Conflict(boolean isError, boolean isCritical, FileObject file2, String conflict, Resolution ... resolutions) {
            this(isCritical ? Severity.CRITICAL_ERROR : (isError ? Severity.ERROR : Severity.WARNING), file2 == null ? null : file2.getFilename(), conflict, resolutions);
        }

        @Deprecated
        public Conflict(boolean isError, boolean isCritical, String filename, String conflict, Resolution ... resolutions) {
            this(isCritical ? Severity.CRITICAL_ERROR : (isError ? Severity.ERROR : Severity.WARNING), filename, conflict, resolutions);
        }

        public Conflict(Severity severity, FileObject file2, String conflict, Resolution ... resolutions) {
            this(severity, file2 == null ? null : file2.getFilename(), conflict, resolutions);
        }

        public Conflict(Severity severity, String filename, String conflict, Resolution ... resolutions) {
            this.severity = severity;
            this.filename = filename;
            this.conflict = conflict;
            this.resolutions = resolutions;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public boolean isError() {
            return this.severity.compareTo(Severity.ERROR) <= 0;
        }

        public boolean isCritical() {
            return this.severity.compareTo(Severity.CRITICAL_ERROR) <= 0;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getConflict() {
            return this.conflict;
        }

        public Resolution[] getResolutions() {
            return this.resolutions;
        }

        public String toString() {
            return this.getFilename() + ": " + this.getConflict();
        }

        public static enum Severity {
            CRITICAL_ERROR,
            ERROR,
            WARNING,
            NOTICE;


            public String toString() {
                return UpdaterUtil.toCamelCase(this.name());
            }
        }
    }
}

