/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.awt.Frame;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.imagej.updater.Conflicts;
import net.imagej.updater.Dependency;
import net.imagej.updater.Diff;
import net.imagej.updater.DllFile;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.FilesUploader;
import net.imagej.updater.Installer;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.Downloadable;
import net.imagej.updater.util.Downloader;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.StderrProgress;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.log.LogService;
import org.scijava.util.AppUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.IteratorPlus;
import org.scijava.util.POM;

public class CommandLine {
    protected static LogService log = UpdaterUtil.getLogService();
    protected FilesCollection files;
    protected Progress progress;
    private FilesCollection.DependencyMap dependencyMap;
    private boolean checksummed = false;
    private boolean standalone;

    @Deprecated
    public CommandLine() {
        this(AppUtils.getBaseDirectory("ij.dir", CommandLine.class, "updater"), 80);
    }

    public CommandLine(File ijDir, int columnCount) {
        this(ijDir, columnCount, null);
    }

    public CommandLine(File ijDir, int columnCount, Progress progress) {
        this.progress = progress == null ? new StderrProgress(columnCount) : progress;
        this.files = new FilesCollection(log, ijDir);
    }

    private void ensureChecksummed() {
        String warnings;
        if (this.checksummed) {
            return;
        }
        try {
            warnings = this.files.downloadIndexAndChecksum(this.progress);
        }
        catch (Exception e) {
            log.debug(e);
            throw this.die("Received exception: " + e.getMessage());
        }
        if (!warnings.equals("")) {
            log.warn(warnings);
        }
        this.checksummed = true;
    }

    public void diff(List<String> list) {
        this.ensureChecksummed();
        Diff diff = new Diff(System.out, this.files.util);
        Diff.Mode mode = Diff.Mode.CLASS_FILE_DIFF;
        while (list.size() > 0 && list.get(0).startsWith("--")) {
            String option = list.remove(0);
            mode = Diff.Mode.valueOf(option.substring(2).replace('-', '_').toUpperCase());
        }
        for (FileObject file2 : this.files.filter(new FileFilter(list))) {
            try {
                String filename = file2.getLocalFilename(false);
                URL remote = new URL(this.files.getURL(file2));
                URL local = this.files.prefix(filename).toURI().toURL();
                diff.showDiff(filename, remote, local, mode);
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    public void listCurrent(List<String> list) {
        this.ensureChecksummed();
        for (FileObject file2 : this.files.filter(new FileFilter(list))) {
            System.out.println(file2.filename + "-" + file2.getTimestamp());
        }
    }

    public void list(List<String> list, FilesCollection.Filter filter) {
        this.ensureChecksummed();
        filter = filter == null ? new FileFilter(list) : this.files.and(new FileFilter(list), filter);
        this.files.sort();
        for (FileObject file2 : this.files.filter(filter)) {
            System.out.println(file2.filename + "\t(" + (Object)((Object)file2.getStatus()) + ")\t" + file2.getTimestamp());
        }
    }

    public void list(List<String> list) {
        this.list(list, null);
    }

    public void listUptodate(List<String> list) {
        this.list(list, this.files.is(FileObject.Status.INSTALLED));
    }

    public void listNotUptodate(List<String> list) {
        this.list(list, this.files.not(this.files.oneOf(FileObject.Status.OBSOLETE, FileObject.Status.INSTALLED, FileObject.Status.LOCAL_ONLY)));
    }

    public void listUpdateable(List<String> list) {
        this.list(list, this.files.is(FileObject.Status.UPDATEABLE));
    }

    public void listModified(List<String> list) {
        this.list(list, this.files.is(FileObject.Status.MODIFIED));
    }

    public void listLocalOnly(List<String> list) {
        this.list(list, this.files.is(FileObject.Status.LOCAL_ONLY));
    }

    public void listFromSite(List<String> sites) {
        if (sites.size() != 1) {
            throw this.die("Usage: list-from-site <name>");
        }
        this.list(null, this.files.isUpdateSite(sites.get(0)));
    }

    public void listShadowed(List<String> list) {
        this.ensureChecksummed();
        FileFilter filter = new FileFilter(list);
        this.files.sort();
        ArrayList<String> overridden = new ArrayList<String>();
        for (FileObject file2 : this.files.filter(filter)) {
            if (!file2.overridesOtherUpdateSite()) continue;
            for (Map.Entry<String, FileObject> entry : file2.overriddenUpdateSites.entrySet()) {
                FileObject other = entry.getValue();
                if (other == null || other.current == null) continue;
                overridden.add(entry.getKey());
            }
            if (overridden.isEmpty()) continue;
            System.out.println(file2.filename + "\t(" + (Object)((Object)file2.getStatus()) + ")\t" + file2.updateSite + " overrides " + overridden);
            overridden.clear();
        }
    }

    public void show(List<String> list) {
        for (String filename : list) {
            this.show(filename);
        }
    }

    public void show(String filename) {
        this.ensureChecksummed();
        FileObject file2 = this.files.get(filename);
        if (file2 == null) {
            log.error("File not found: " + filename);
        } else {
            this.show(file2);
        }
    }

    public void show(FileObject file2) {
        File file3;
        FilesCollection dependencees;
        String description;
        this.ensureChecksummed();
        if (this.dependencyMap == null) {
            this.dependencyMap = this.files.getDependencies(this.files, false);
        }
        System.out.println();
        System.out.println("File: " + file2.getFilename(true));
        if (!file2.getFilename(true).equals(file2.localFilename)) {
            System.out.println("(Local filename: " + file2.localFilename + ")");
        }
        if ((description = file2.description) != null && description.length() > 0) {
            description = "\t" + description.replaceAll("\n", "\n\t");
            System.out.println("Description:\n" + description);
        }
        System.out.println("Update site: " + file2.updateSite);
        if (file2.current == null) {
            System.out.println("Removed from update site");
        } else {
            System.out.println("URL: " + this.files.getURL(file2));
            System.out.println("checksum: " + file2.current.checksum + ", timestamp: " + file2.current.timestamp);
        }
        if (!(file2.localChecksum == null || file2.current != null && file2.localChecksum.equals(file2.current.checksum))) {
            System.out.println("Local checksum: " + file2.localChecksum + " (" + (file2.hasPreviousVersion(file2.localChecksum) ? "" : "NOT a ") + "previous version)");
        }
        StringBuilder builder = new StringBuilder();
        for (FileObject fileObject : file2.getFileDependencies(this.files, false)) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(fileObject.getFilename(true));
        }
        if (builder.length() > 0) {
            System.out.println("Dependencies: " + builder.toString());
        }
        if ((dependencees = this.getDependencees(file2)) != null && !dependencees.isEmpty()) {
            builder.setLength(0);
            for (FileObject dependencee : dependencees) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(dependencee.getFilename(true));
            }
            if (builder.length() > 0) {
                System.out.println("Have '" + file2.getFilename(true) + "' as dependency: " + builder.toString());
            }
        }
        if ((file3 = this.files.prefix(file2.localFilename != null ? file2.localFilename : file2.filename)).exists()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            try {
                String commit;
                JarFile jar = new JarFile(file3);
                Manifest manifest = jar.getManifest();
                Attributes attrs = manifest == null ? null : manifest.getMainAttributes();
                String string = commit = attrs == null ? null : attrs.getValue("Implementation-Build");
                if (commit != null) {
                    map.put("Commit", commit);
                }
                JarEntry pomEntry = null;
                for (JarEntry entry : new IteratorPlus<JarEntry>(jar.entries())) {
                    if (!entry.getName().endsWith("/pom.xml")) continue;
                    if (pomEntry == null) {
                        pomEntry = entry;
                        continue;
                    }
                    System.out.println("Warning: Ignoring extra pom.xml: " + entry.getName() + " in " + file3);
                }
                if (pomEntry != null) {
                    try {
                        String ci;
                        String issues;
                        String scm;
                        POM pom = new POM(jar.getInputStream(pomEntry));
                        String url = pom.getProjectURL();
                        if (url != null) {
                            map.put("Project URL", url);
                        }
                        if ((scm = pom.cdata("//project/scm/url")) != null) {
                            if (commit != null && scm.matches("https?://github.com/[^/]*/[^/]*/?")) {
                                map.put("Commit URL", scm + "/commit/" + commit);
                                map.put("Compare URL", scm + "/compare/" + commit + "...master");
                            }
                            map.put("Project SCM URL", scm);
                        }
                        if ((issues = pom.cdata("//project/issueManagement/url")) != null) {
                            map.put("Project Issue Tracker", issues);
                        }
                        if ((ci = pom.cdata("//project/ciManagement/url")) != null) {
                            map.put("Jenkins Job URL", ci);
                        }
                    }
                    catch (Exception e) {
                        log.debug(e);
                        System.out.println("Error parsing POM: " + e.getMessage());
                    }
                }
                jar.close();
            }
            catch (IOException e) {
                System.out.println("Could not get manifest: " + e.getMessage());
            }
            if (map.isEmpty()) {
                System.out.println("No manifest/POM information contained in " + file3.getName());
            } else {
                System.out.println("Manifest/POM information for " + file2.getBaseName() + ":");
                for (Map.Entry entry : map.entrySet()) {
                    System.out.println("\t" + (String)entry.getKey() + ": " + (String)entry.getValue());
                }
            }
        }
    }

    public void history(List<String> list) {
        this.ensureChecksummed();
        class History
        extends TreeMap<Long, Set<FileObject>>
        implements Comparator<FileObject> {
            History() {
            }

            public void add(FileObject file2) {
                if (file2.current != null) {
                    this.add(file2.current.timestamp, file2);
                }
                for (FileObject.Version version : file2.previous) {
                    this.add(version.timestamp, file2);
                }
            }

            public void add(long timestamp, FileObject file2) {
                TreeSet<FileObject> set = (TreeSet<FileObject>)this.get(timestamp);
                if (set == null) {
                    set = new TreeSet<FileObject>(this);
                    this.put(timestamp, set);
                }
                set.add(file2);
            }

            @Override
            public int compare(FileObject a, FileObject b) {
                return a.getFilename(true).compareTo(b.getFilename(true));
            }
        }
        History history = new History();
        for (FileObject fileObject : this.files.filter(new FileFilter(list))) {
            if (fileObject.getStatus() == FileObject.Status.LOCAL_ONLY) continue;
            history.add(fileObject);
        }
        for (Map.Entry entry : history.descendingMap().entrySet()) {
            long timestamp = (Long)entry.getKey();
            Set files = (Set)entry.getValue();
            System.out.println("" + UpdaterUtil.prettyPrintTimestamp(timestamp));
            for (FileObject file3 : files) {
                System.out.println("\t" + file3.getFilename(timestamp));
            }
        }
    }

    private FilesCollection getDependencees(FileObject file2) {
        if (this.dependencyMap == null) {
            this.dependencyMap = this.files.getDependencies(this.files, false);
        }
        return (FilesCollection)this.dependencyMap.get(file2);
    }

    public void download(FileObject file2) {
        this.ensureChecksummed();
        try {
            new Downloader(this.progress, this.files.util).start(new OneFile(file2));
            if (file2.executable && !this.files.util.platform.startsWith("win")) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "0755", this.files.prefix(file2.filename).getPath()});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw this.die("Could not mark " + file2.filename + " as executable");
                }
            }
            log.info("Installed " + file2.filename);
        }
        catch (IOException e) {
            log.error("IO error downloading " + file2.filename, e);
        }
    }

    public void delete(FileObject file2) {
        if (new File(file2.filename).delete()) {
            log.info("Deleted " + file2.filename);
        } else {
            log.error("Failed to delete " + file2.filename);
        }
    }

    public void update(List<String> list) {
        this.update(list, false);
    }

    public void update(List<String> list, boolean force) {
        this.update(list, force, false);
    }

    public void update(List<String> list, boolean force, boolean pristine) {
        this.ensureChecksummed();
        if (list.size() > 0) {
            for (FileObject file2 : this.files) {
                if (file2.getStatus() != FileObject.Status.NEW || file2.getAction() != FileObject.Action.INSTALL) continue;
                file2.setAction(this.files, FileObject.Action.NEW);
            }
        }
        try {
            for (FileObject file2 : this.files.filter(new FileFilter(list))) {
                File correctVersion;
                File[] versions;
                if (file2.getStatus() == FileObject.Status.LOCAL_ONLY) {
                    if (pristine) {
                        file2.setAction(this.files, FileObject.Action.UNINSTALL);
                    }
                } else if (file2.isObsolete()) {
                    if (file2.getStatus() == FileObject.Status.OBSOLETE) {
                        log.info("Removing " + file2.filename);
                        file2.stageForUninstall(this.files);
                    } else if (file2.getStatus() == FileObject.Status.OBSOLETE_MODIFIED) {
                        if (force || pristine) {
                            file2.stageForUninstall(this.files);
                            log.info("Removing " + file2.filename);
                        } else {
                            log.warn("Skipping obsolete, but modified " + file2.filename);
                        }
                    }
                } else if (file2.getStatus() != FileObject.Status.INSTALLED && !file2.stageForUpdate(this.files, force)) {
                    log.warn("Skipping " + file2.filename);
                }
                if (!pristine || (versions = FileUtils.getAllVersions((correctVersion = this.files.prefix(file2)).getParentFile(), correctVersion.getName())) == null) continue;
                for (File version : versions) {
                    if (version.equals(correctVersion)) continue;
                    log.info("Deleting obsolete version " + version);
                    if (version.delete()) continue;
                    log.error("Could not delete " + version + "!");
                }
            }
            this.resolveConflicts(false);
            Installer installer = new Installer(this.files, this.progress);
            installer.start();
            installer.moveUpdatedIntoPlace();
            this.files.write();
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("conflicts") >= 0) {
                log.error("Could not update due to conflicts:");
                for (Conflicts.Conflict conflict : new Conflicts(this.files).getConflicts(false)) {
                    log.error(conflict.getFilename() + ": " + conflict.getConflict());
                }
            }
            log.error("Error updating", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertUnrealChanges(List<String> list) {
        this.ensureChecksummed();
        boolean simulate = false;
        if (list != null && list.size() > 0 && "--simulate".equals(list.get(0))) {
            simulate = true;
            list.remove(0);
        }
        int count = 0;
        block11: for (FileObject file2 : this.files.filter(new FileFilter(list))) {
            block20: {
                switch (file2.getStatus()) {
                    case MODIFIED: 
                    case UPDATEABLE: {
                        break;
                    }
                    case INSTALLED: 
                    case LOCAL_ONLY: 
                    case NEW: 
                    case NOT_INSTALLED: 
                    case OBSOLETE: 
                    case OBSOLETE_MODIFIED: 
                    case OBSOLETE_UNINSTALLED: {
                        continue block11;
                    }
                }
                if (!file2.filename.endsWith(".dll")) continue;
                try (DllFile dll = new DllFile(this.files.prefix(file2));){
                    URL url = new URL(this.files.getURL(file2));
                    if (!dll.equals(url.openConnection())) {
                        continue;
                    }
                    break block20;
                }
                catch (Throwable t) {
                    log.warn(t);
                }
                continue;
            }
            if (simulate) {
                System.out.println("Would overwrite " + file2.filename);
            } else {
                file2.setAction(this.files, FileObject.Action.UPDATE);
            }
            ++count;
        }
        if (count == 0) {
            System.err.println("Nothing to do!");
        } else if (simulate) {
            System.out.println("Would overwrite " + count + " file(s)");
        } else {
            try {
                Installer installer = new Installer(this.files, this.progress);
                installer.start();
                installer.moveUpdatedIntoPlace();
                this.files.write();
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public void downgrade(List<String> list) {
        if (this.standalone) {
            Console console = System.console();
            if (console == null) {
                throw this.die("Downgrading is only allowed interactively");
            }
            List<String> answers = Arrays.asList("Yours, and yours alone", "Obama's", "San Andreas'");
            String correct = answers.get(0);
            Collections.shuffle(answers);
            String answer = console.readLine("Downgrading is not accurate, due to lack of accurate metadata\nIn particular, when files have been shadowed/unshadowed or marked obsolete,\nthe result of a downgrade is guaranteed to be inaccurate.\n\nIf you do not want an inaccurate time, now is the time to quit.\n\nOtherwise, please answer the following question accurately:\nWhose fault is it if anything goes wrong with this downgrade?\n\n\t1) %s\n\t2) %s\n\t3) %s\n", answers.toArray()).trim();
            if (answer.matches("[0-9]+")) {
                try {
                    answer = answers.get(Integer.parseInt(answer) - 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!correct.equals(answer)) {
                throw this.die("Absolutely not.");
            }
        }
        boolean simulate = false;
        if (list.size() > 0 && "--simulate".equals(list.get(0))) {
            simulate = true;
            list.remove(0);
        }
        if (list.size() < 1) {
            throw this.die("What date?");
        }
        String timestampString = list.remove(0);
        long timestamp = Long.parseLong(timestampString);
        this.ensureChecksummed();
        int count = 0;
        for (FileObject file2 : this.files.filter(new FileFilter(list))) {
            if (file2.getStatus() == FileObject.Status.LOCAL_ONLY) continue;
            if (file2.current != null && file2.current.timestamp <= timestamp) {
                if (file2.current.checksum.equals(file2.localChecksum)) continue;
                if (simulate) {
                    System.out.println("Would update/install " + file2.current.filename);
                } else {
                    file2.setStatus(FileObject.Status.UPDATEABLE);
                    file2.setFirstValidAction(this.files, FileObject.Action.UPDATE, FileObject.Action.INSTALL);
                }
                ++count;
                continue;
            }
            String result = null;
            String checksum = null;
            long matchedTimestamp = 0L;
            for (FileObject.Version version : file2.previous) {
                if (timestamp < version.timestamp || version.timestamp <= matchedTimestamp) continue;
                result = version.filename;
                checksum = version.checksum;
                matchedTimestamp = version.timestamp;
            }
            if (checksum == null) {
                if (file2.localChecksum == null) continue;
                if (simulate) {
                    System.out.println("Would uninstall " + file2.getLocalFilename(false));
                } else {
                    file2.setAction(this.files, FileObject.Action.UNINSTALL);
                }
                ++count;
                continue;
            }
            if (result.equals(file2.filename) && checksum.equals(file2.localChecksum)) continue;
            if (simulate) {
                System.out.println("Would update/install " + result);
            } else {
                if (file2.current == null) {
                    file2.current = new FileObject.Version(checksum, matchedTimestamp);
                } else {
                    file2.current.checksum = checksum;
                    file2.current.timestamp = matchedTimestamp;
                }
                file2.filename = file2.current.filename = result;
                file2.filesize = -1L;
                file2.setStatus(FileObject.Status.UPDATEABLE);
                file2.setFirstValidAction(this.files, FileObject.Action.UPDATE, FileObject.Action.INSTALL);
            }
            ++count;
        }
        if (count == 0) {
            System.err.println("Nothing to do!");
        } else if (!simulate) {
            try {
                this.resolveConflicts(false);
                Installer installer = new Installer(this.files, this.progress);
                installer.start();
                installer.moveUpdatedIntoPlace();
                this.files.write();
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("conflicts") >= 0) {
                    log.error("Could not update due to conflicts:");
                    for (Conflicts.Conflict conflict : new Conflicts(this.files).getConflicts(false)) {
                        log.error(conflict.getFilename() + ": " + conflict.getConflict());
                    }
                }
                log.error("Error updating", e);
            }
        }
    }

    public void upload(List<String> list) {
        if (list == null) {
            throw this.die("Which files do you mean to upload?");
        }
        boolean forceUpdateSite = false;
        boolean forceShadow = false;
        boolean simulate = false;
        boolean forgetMissingDeps = false;
        String updateSite = null;
        while (list.size() > 0 && list.get(0).startsWith("-")) {
            String option = list.remove(0);
            if ("--update-site".equals(option) || "--site".equals(option)) {
                if (list.size() < 1) {
                    throw this.die("Missing name for --update-site");
                }
                updateSite = list.remove(0);
                forceUpdateSite = true;
                continue;
            }
            if ("--simulate".equals(option)) {
                simulate = true;
                continue;
            }
            if ("--force-shadow".equals(option)) {
                forceShadow = true;
                continue;
            }
            if ("--forget-missing-dependencies".equals(option)) {
                forgetMissingDeps = true;
                continue;
            }
            throw this.die("Unknown option: " + option);
        }
        if (list.size() == 0) {
            throw this.die("Which files do you mean to upload?");
        }
        if (forceShadow && updateSite == null) {
            throw this.die("Need an explicit update site with --force-shadow");
        }
        this.ensureChecksummed();
        int count = 0;
        for (String name : list) {
            FileObject file2 = this.files.get(name);
            if (file2 == null) {
                throw this.die("No file '" + name + "' found!");
            }
            if (file2.getStatus() == FileObject.Status.INSTALLED && (file2.localFilename == null || file2.localFilename.equals(file2.filename))) {
                if (forceShadow && !updateSite.equals(file2.updateSite)) {
                    file2.updateSite = updateSite;
                    file2.setStatus(FileObject.Status.MODIFIED);
                    log.info("Uploading (force-shadow) '" + name + "' to site '" + updateSite + "'");
                } else {
                    log.info("Skipping up-to-date " + name);
                    continue;
                }
            }
            this.handleLauncherForUpload(file2);
            if (updateSite == null) {
                updateSite = file2.updateSite;
                if (updateSite == null) {
                    updateSite = file2.updateSite = this.chooseUploadSite(name);
                }
                if (updateSite == null) {
                    throw this.die("Canceled");
                }
            } else if (file2.updateSite == null) {
                log.info("Uploading new file '" + name + "' to  site '" + updateSite + "'");
                file2.updateSite = updateSite;
            } else if (!file2.updateSite.equals(updateSite)) {
                if (forceUpdateSite) {
                    file2.updateSite = updateSite;
                } else {
                    throw this.die("Cannot upload to multiple update sites (" + list.get(0) + " to " + updateSite + " and " + name + " to " + file2.updateSite + ")");
                }
            }
            if (file2.getStatus() == FileObject.Status.NOT_INSTALLED || file2.getStatus() == FileObject.Status.NEW) {
                log.info("Removing file '" + name + "'");
                file2.setAction(this.files, FileObject.Action.REMOVE);
            } else {
                if (simulate) {
                    log.info("Would upload '" + name + "'");
                }
                if (file2.localFilename != null && !file2.localFilename.equals(file2.filename)) {
                    file2.addPreviousVersion(file2.current.checksum, file2.current.timestamp, file2.filename);
                }
                file2.setAction(this.files, FileObject.Action.UPLOAD);
            }
            ++count;
        }
        if (count == 0) {
            log.info("Nothing to upload");
            return;
        }
        if (updateSite != null && this.files.getUpdateSite(updateSite, false) == null) {
            throw this.die("Unknown update site: '" + updateSite + "'");
        }
        if (forgetMissingDeps) {
            block2: for (Conflicts.Conflict conflict : new Conflicts(this.files).getConflicts(true)) {
                String message = conflict.getConflict();
                if (!message.startsWith("Depends on ") || !message.endsWith(" which is about to be removed.")) continue;
                log.info("Breaking dependency: " + conflict);
                for (Conflicts.Resolution resolution : conflict.getResolutions()) {
                    if (!resolution.getDescription().startsWith("Break")) continue;
                    resolution.resolve();
                    continue block2;
                }
            }
        }
        if (simulate) {
            Iterable<Conflicts.Conflict> conflicts = new Conflicts(this.files).getConflicts(true);
            if (Conflicts.needsFeedback(conflicts)) {
                log.error("Unresolved upload conflicts!\n\n" + UpdaterUtil.join("\n", conflicts));
            } else {
                log.info("Would upload/remove " + count + " to/from " + this.getLongUpdateSiteName(updateSite));
            }
            String errors = this.files.checkConsistency();
            if (errors != null) {
                log.error(errors);
            }
            return;
        }
        String errors = this.files.checkConsistency();
        if (errors != null) {
            throw this.die(errors);
        }
        log.info("Uploading to " + this.getLongUpdateSiteName(updateSite));
        this.upload(updateSite);
    }

    public void uploadCompleteSite(List<String> list) {
        if (list == null) {
            throw this.die("Which files do you mean to upload?");
        }
        boolean ignoreWarnings = false;
        boolean forceShadow = false;
        boolean simulate = false;
        while (list.size() > 0 && list.get(0).startsWith("-")) {
            String option = list.remove(0);
            if ("--force".equals(option)) {
                ignoreWarnings = true;
                continue;
            }
            if ("--force-shadow".equals(option)) {
                forceShadow = true;
                continue;
            }
            if ("--simulate".equals(option)) {
                simulate = true;
                continue;
            }
            if ("--platforms".equals(option)) {
                if (list.size() == 0) {
                    throw this.die("Need a comma-separated list of platforms with --platform");
                }
                this.files.util.setUpdateablePlatforms(list.remove(0).split(","));
                continue;
            }
            throw this.die("Unknown option: " + option);
        }
        if (list.size() != 1) {
            throw this.die("Which files do you mean to upload?");
        }
        String updateSite = list.get(0);
        this.ensureChecksummed();
        if (this.files.getUpdateSite(updateSite, false) == null) {
            throw this.die("Unknown update site '" + updateSite + "'");
        }
        int removeCount = 0;
        int uploadCount = 0;
        int warningCount = 0;
        for (FileObject file2 : this.files) {
            if (!file2.isUpdateablePlatform(this.files)) continue;
            String name = file2.filename;
            this.handleLauncherForUpload(file2);
            switch (file2.getStatus()) {
                case OBSOLETE: 
                case OBSOLETE_MODIFIED: {
                    if (forceShadow) {
                        file2.updateSite = updateSite;
                        file2.setAction(this.files, FileObject.Action.UPLOAD);
                        if (simulate) {
                            log.info("Would upload " + file2.filename);
                        }
                        ++uploadCount;
                        break;
                    }
                    if (ignoreWarnings && updateSite.equals(file2.updateSite)) {
                        file2.setAction(this.files, FileObject.Action.UPLOAD);
                        if (simulate) {
                            log.info("Would re-upload " + file2.filename);
                        }
                        ++uploadCount;
                        break;
                    }
                    log.warn("Obsolete '" + (String)name + "' still installed!");
                    ++warningCount;
                    break;
                }
                case MODIFIED: 
                case UPDATEABLE: {
                    if (!forceShadow && !updateSite.equals(file2.updateSite)) {
                        log.warn("'" + (String)name + "' of update site '" + file2.updateSite + "' is not up-to-date!");
                        ++warningCount;
                        break;
                    }
                }
                case LOCAL_ONLY: {
                    file2.updateSite = updateSite;
                    file2.setAction(this.files, FileObject.Action.UPLOAD);
                    if (simulate) {
                        log.info("Would upload new " + (file2.getStatus() == FileObject.Status.LOCAL_ONLY ? "" : "version of ") + file2.getLocalFilename(true));
                    }
                    ++uploadCount;
                    break;
                }
                case NEW: 
                case NOT_INSTALLED: {
                    if ("ImageJ".equals(updateSite) && file2.getFilename(true).equals("jars/tools.jar") || !file2.isUpdateablePlatform(this.files)) break;
                    file2.setAction(this.files, FileObject.Action.REMOVE);
                    if (simulate) {
                        log.info("Would mark " + file2.filename + " obsolete");
                    }
                    ++removeCount;
                    break;
                }
            }
        }
        for (FileObject file2 : this.files.forUpdateSite(updateSite)) {
            if (!file2.willBeUpToDate()) continue;
            for (FileObject dependency : file2.getFileDependencies(this.files, false)) {
                if (!dependency.willNotBeInstalled() || !updateSite.equals(dependency.updateSite)) continue;
                file2.removeDependency(dependency.getFilename(false));
            }
            if (!ignoreWarnings) continue;
            ArrayList<String> obsoleteDependencies = new ArrayList<String>();
            for (Dependency dependency : file2.getDependencies()) {
                FileObject dep = this.files.get(dependency.filename);
                if (dep == null || !dep.isObsolete()) continue;
                obsoleteDependencies.add(dependency.filename);
            }
            for (String filename : obsoleteDependencies) {
                file2.removeDependency(filename);
            }
        }
        if (!ignoreWarnings && warningCount > 0) {
            throw this.die("Use --force to ignore warnings and upload anyway");
        }
        if (removeCount == 0 && uploadCount == 0) {
            log.info("Nothing to upload");
            return;
        }
        if (simulate) {
            Iterable<Conflicts.Conflict> conflicts = new Conflicts(this.files).getConflicts(true);
            if (Conflicts.needsFeedback(conflicts)) {
                log.error("Unresolved upload conflicts!\n\n" + UpdaterUtil.join("\n", conflicts));
            } else {
                log.info("Would upload " + uploadCount + " (removing " + removeCount + ") to " + this.getLongUpdateSiteName(updateSite));
            }
            String errors = this.files.checkConsistency();
            if (errors != null) {
                log.error(errors);
            }
            return;
        }
        log.info("Uploading " + uploadCount + " (removing " + removeCount + ") to " + this.getLongUpdateSiteName(updateSite));
        this.upload(updateSite);
    }

    private void handleLauncherForUpload(FileObject file2) {
        if (file2.getStatus() == FileObject.Status.LOCAL_ONLY && this.files.util.isLauncher(file2.filename)) {
            file2.executable = true;
            file2.addPlatform(UpdaterUtil.platformForLauncher(file2.filename));
            for (String fileName : new String[]{"jars/imagej-launcher.jar"}) {
                FileObject dependency = this.files.get(fileName);
                if (dependency == null) continue;
                file2.addDependency(this.files, dependency);
            }
        }
    }

    private void upload(String updateSite) {
        block6: {
            this.resolveConflicts(true);
            FilesUploader uploader = null;
            try {
                uploader = new FilesUploader(null, this.files, updateSite, this.progress);
                if (!uploader.login()) {
                    throw this.die("Login failed!");
                }
                uploader.upload(this.progress);
                this.files.write();
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (message != null && message.indexOf("conflicts") >= 0) {
                    log.error("Could not upload due to conflicts:");
                    for (Conflicts.Conflict conflict : new Conflicts(this.files).getConflicts(true)) {
                        log.error(conflict.getFilename() + ": " + conflict.getConflict());
                    }
                } else {
                    e.printStackTrace();
                    throw this.die("Error during upload: " + e);
                }
                if (uploader == null) break block6;
                uploader.logout();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void resolveConflicts(boolean forUpload) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String chooseUploadSite(String file2) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> options = new ArrayList<String>();
        for (String name : this.files.getUpdateSiteNames(false)) {
            UpdateSite updateSite = this.files.getUpdateSite(name, true);
            if (updateSite.getUploadDirectory() == null || updateSite.getUploadDirectory().equals("")) continue;
            names.add(name);
            options.add(this.getLongUpdateSiteName(name));
        }
        if (names.size() == 0) {
            log.error("No uploadable sites found");
            return null;
        }
        String message = "Choose upload site for file '" + file2 + "'";
        int index = UpdaterUserInterface.get().optionDialog(message, message, options.toArray(new String[options.size()]), 0);
        return index < 0 ? null : (String)names.get(index);
    }

    public String getLongUpdateSiteName(String name) {
        UpdateSite site = this.files.getUpdateSite(name, true);
        String host = site.getHost();
        if (host == null || host.equals("")) {
            host = "";
        } else {
            int colon;
            if (host.startsWith("webdav:") && (colon = host.indexOf(58, 8)) > 0) {
                host = host.substring(0, colon) + ":<password>";
            }
            host = host + ":";
        }
        return name + " (" + host + site.getUploadDirectory() + ")";
    }

    public void listUpdateSites(Collection<String> args) {
        this.ensureChecksummed();
        if (args == null || args.size() == 0) {
            args = this.files.getUpdateSiteNames(true);
        }
        for (String name : args) {
            UpdateSite site = this.files.getUpdateSite(name, true);
            System.out.print(name + (site.isActive() ? "" : " (DISABLED)") + ": " + site.getURL());
            if (site.getUploadDirectory() == null) {
                System.out.println();
                continue;
            }
            System.out.println(" (upload host: " + site.getHost() + ", upload directory: " + site.getUploadDirectory() + ")");
        }
    }

    public void addOrEditUploadSite(List<String> args, boolean add) {
        if (args.size() != 2 && args.size() != 4) {
            throw this.die("Usage: " + (add ? "add" : "edit") + "-update-site <name> <url> [<host> <upload-directory>]");
        }
        this.addOrEditUploadSite(args.get(0), args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, add);
    }

    public void addOrEditUploadSite(String name, String url, String sshHost, String uploadDirectory, boolean add) {
        this.ensureChecksummed();
        UpdateSite site = this.files.getUpdateSite(name, true);
        if (site == null || add) {
            if (site != null) {
                throw this.die("Site '" + name + "' was already added!");
            }
            this.files.addUpdateSite(name, url, sshHost, uploadDirectory, 0L);
        } else {
            site.setURL(url);
            site.setHost(sshHost);
            site.setUploadDirectory(uploadDirectory);
            site.setActive(true);
        }
        try {
            this.files.write();
        }
        catch (Exception e) {
            UpdaterUserInterface.get().handleException(e);
            throw this.die("Could not write local file database");
        }
    }

    public void removeUploadSite(List<String> names) {
        if (names == null || names.size() < 1) {
            throw this.die("Which update-site do you want to remove, exactly?");
        }
        this.removeUploadSite(names.toArray(new String[names.size()]));
    }

    public void removeUploadSite(String ... names) {
        this.ensureChecksummed();
        for (String name : names) {
            this.files.removeUpdateSite(name);
        }
        try {
            this.files.write();
        }
        catch (Exception e) {
            UpdaterUserInterface.get().handleException(e);
            throw this.die("Could not write local file database");
        }
    }

    @Deprecated
    public static CommandLine getInstance() {
        try {
            return new CommandLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Could not parse db.xml.gz: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static List<String> makeList(String[] list, int start) {
        ArrayList<String> result = new ArrayList<String>();
        while (start < list.length) {
            result.add(list[start++]);
        }
        return result;
    }

    private RuntimeException die(String message) {
        if (this.standalone) {
            log.error(message);
            System.exit(1);
        }
        return new RuntimeException(message);
    }

    public void usage() {
        StringBuilder diffOptions = new StringBuilder();
        diffOptions.append("[ ");
        for (Diff.Mode mode : Diff.Mode.values()) {
            if (diffOptions.length() > 2) {
                diffOptions.append(" | ");
            }
            diffOptions.append("--" + mode.toString().toLowerCase().replace(' ', '-'));
        }
        diffOptions.append(" ]");
        throw this.die("Usage: ImageJ --update <command>\n\nCommands:\n\tdiff " + diffOptions + " [<files>]\n\tlist [<files>]\n\tlist-uptodate [<files>]\n\tlist-not-uptodate [<files>]\n\tlist-updateable [<files>]\n\tlist-modified [<files>]\n\tlist-current [<files>]\n\tlist-local-only [<files>]\n\tlist-shadowed [<files>]\n\tlist-from-site <name>\n\tshow [<files>]\n\tupdate [<files>]\n\tupdate-force [<files>]\n\tupdate-force-pristine [<files>]\n\trevert-unreal-changes [<files>]\n\tupload [--simulate] [--[update-]site <name>] [--force-shadow] [--forget-missing-dependencies] [<files>]\n\tupload-complete-site [--simulate] [--force] [--force-shadow] [--platforms <platform>[,<platform>...]] <name>\n\tlist-update-sites [<nick>...]\n\tadd-update-site <nick> <url> [<host> <upload-directory>]\n\tedit-update-site <nick> <url> [<host> <upload-directory>]");
    }

    public static void main(String ... args) {
        if (System.getProperty("imagej.dir") == null) {
            String ijDir = System.getProperty("ij.dir");
            if (ijDir != null) {
                System.setProperty("imagej.dir", ijDir);
            } else {
                String fijiDir = System.getProperty("fiji.dir");
                if (fijiDir != null) {
                    System.setProperty("imagej.dir", fijiDir);
                }
            }
        }
        try {
            CommandLine.main(AppUtils.getBaseDirectory("imagej.dir", CommandLine.class, "updater"), 79, null, true, args);
        }
        catch (RuntimeException e) {
            log.error(e);
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Could not parse db.xml.gz", e);
            System.exit(1);
        }
    }

    public static void main(File ijDir, int columnCount, String ... args) {
        CommandLine.main(ijDir, columnCount, null, args);
    }

    public static void main(File ijDir, int columnCount, Progress progress, String ... args) {
        CommandLine.main(ijDir, columnCount, progress, false, args);
    }

    private static void main(File ijDir, int columnCount, Progress progress, boolean standalone, String[] args) {
        String command;
        String http_proxy = System.getenv("http_proxy");
        if (http_proxy != null && http_proxy.startsWith("http://")) {
            int colon = http_proxy.indexOf(58, 7);
            int slash = http_proxy.indexOf(47, 7);
            int port = 80;
            if (colon < 0) {
                http_proxy = slash < 0 ? http_proxy.substring(7) : http_proxy.substring(7, slash);
            } else {
                port = Integer.parseInt(slash < 0 ? http_proxy.substring(colon + 1) : http_proxy.substring(colon + 1, slash));
                http_proxy = http_proxy.substring(7, colon);
            }
            System.setProperty("http.proxyHost", http_proxy);
            System.setProperty("http.proxyPort", "" + port);
        } else {
            UpdaterUtil.useSystemProxies();
        }
        Authenticator.setDefault(new ConsoleAuthenticator());
        CommandLine.setUserInterface();
        CommandLine instance = new CommandLine(ijDir, columnCount, progress);
        instance.standalone = standalone;
        if (args.length == 0) {
            instance.usage();
        }
        if ((command = args[0]).equals("diff")) {
            instance.diff(CommandLine.makeList(args, 1));
        } else if (command.equals("list")) {
            instance.list(CommandLine.makeList(args, 1));
        } else if (command.equals("list-current")) {
            instance.listCurrent(CommandLine.makeList(args, 1));
        } else if (command.equals("list-uptodate")) {
            instance.listUptodate(CommandLine.makeList(args, 1));
        } else if (command.equals("list-not-uptodate")) {
            instance.listNotUptodate(CommandLine.makeList(args, 1));
        } else if (command.equals("list-updateable")) {
            instance.listUpdateable(CommandLine.makeList(args, 1));
        } else if (command.equals("list-modified")) {
            instance.listModified(CommandLine.makeList(args, 1));
        } else if (command.equals("list-local-only")) {
            instance.listLocalOnly(CommandLine.makeList(args, 1));
        } else if (command.equals("list-from-site")) {
            instance.listFromSite(CommandLine.makeList(args, 1));
        } else if (command.equals("list-shadowed")) {
            instance.listShadowed(CommandLine.makeList(args, 1));
        } else if (command.equals("show")) {
            instance.show(CommandLine.makeList(args, 1));
        } else if (command.equals("update")) {
            instance.update(CommandLine.makeList(args, 1));
        } else if (command.equals("update-force")) {
            instance.update(CommandLine.makeList(args, 1), true);
        } else if (command.equals("update-force-pristine")) {
            instance.update(CommandLine.makeList(args, 1), true, true);
        } else if (command.equals("revert-unreal-changes")) {
            instance.revertUnrealChanges(CommandLine.makeList(args, 1));
        } else if (command.equals("upload")) {
            instance.upload(CommandLine.makeList(args, 1));
        } else if (command.equals("upload-complete-site")) {
            instance.uploadCompleteSite(CommandLine.makeList(args, 1));
        } else if (command.equals("list-update-sites")) {
            instance.listUpdateSites(CommandLine.makeList(args, 1));
        } else if (command.equals("add-update-site")) {
            instance.addOrEditUploadSite(CommandLine.makeList(args, 1), true);
        } else if (command.equals("edit-update-site")) {
            instance.addOrEditUploadSite(CommandLine.makeList(args, 1), false);
        } else if (command.equals("remove-update-site")) {
            instance.removeUploadSite(CommandLine.makeList(args, 1));
        } else if (command.equals("history")) {
            instance.history(CommandLine.makeList(args, 1));
        } else if (command.equals("downgrade")) {
            instance.downgrade(CommandLine.makeList(args, 1));
        } else {
            instance.usage();
        }
    }

    protected static void setUserInterface() {
        UpdaterUserInterface.set(new ConsoleUserInterface());
    }

    protected static class ConsoleUserInterface
    extends UpdaterUserInterface {
        protected Console console = System.console();
        protected int count;

        protected ConsoleUserInterface() {
        }

        @Override
        public String getPassword(String message) {
            if (this.console == null) {
                throw new RuntimeException("Password prompt requires interactive operation!");
            }
            System.out.print(message + ": ");
            return new String(this.console.readPassword());
        }

        @Override
        public boolean promptYesNo(String title, String message) {
            if (this.console == null) {
                throw new RuntimeException("Prompt requires interactive operation!");
            }
            System.err.print(title + ": " + message);
            String line = this.console.readLine();
            return line.startsWith("y") || line.startsWith("Y");
        }

        public void showPrompt(String prompt) {
            if (!prompt.endsWith(": ")) {
                prompt = prompt + ": ";
            }
            System.err.print(prompt);
        }

        public String getUsername(String prompt) {
            if (this.console == null) {
                throw new RuntimeException("Username prompt requires interactive operation!");
            }
            this.showPrompt(prompt);
            return this.console.readLine();
        }

        public int askChoice(String[] options) {
            if (this.console == null) {
                throw new RuntimeException("Prompt requires interactive operation!");
            }
            for (int i = 0; i < options.length; ++i) {
                System.err.println("" + (i + 1) + ": " + options[i]);
            }
            while (true) {
                System.err.print("Choice? ");
                String answer = this.console.readLine();
                if (answer.equals("")) {
                    return -1;
                }
                try {
                    return Integer.parseInt(answer) - 1;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        @Override
        public void error(String message) {
            log.error(message);
        }

        @Override
        public void info(String message, String title) {
            log.info(title + ": " + message);
        }

        @Override
        public void log(String message) {
            log.info(message);
        }

        @Override
        public void debug(String message) {
            log.debug(message);
        }

        @Override
        public OutputStream getOutputStream() {
            return System.out;
        }

        @Override
        public void showStatus(String message) {
            this.log(message);
        }

        @Override
        public void handleException(Throwable exception) {
            exception.printStackTrace();
        }

        @Override
        public boolean isBatchMode() {
            return false;
        }

        @Override
        public int optionDialog(String message, String title, Object[] options, int def) {
            if (this.console == null) {
                throw new RuntimeException("Prompt requires interactive operation!");
            }
            for (int i = 0; i < options.length; ++i) {
                System.err.println("" + (i + 1) + ") " + options[i]);
            }
            while (true) {
                System.out.print("Your choice (default: " + def + ": " + options[def] + ")? ");
                String line = this.console.readLine();
                if (line.equals("")) {
                    return def;
                }
                try {
                    int option = Integer.parseInt(line);
                    if (option <= 0 || option > options.length) continue;
                    return option - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public String getPref(String key) {
            return null;
        }

        @Override
        public void setPref(String key, String value) {
            this.log("Ignoring setting '" + key + "'");
        }

        @Override
        public void savePreferences() {
        }

        @Override
        public void openURL(String url) throws IOException {
            this.log("Please open " + url + " in your browser");
        }

        @Override
        public String getString(String title) {
            if (this.console == null) {
                throw new RuntimeException("Prompt requires interactive operation!");
            }
            System.out.print(title + ": ");
            return this.console.readLine();
        }

        @Override
        public void addWindow(Frame window) {
        }

        @Override
        public void removeWindow(Frame window) {
        }
    }

    protected static class ConsoleAuthenticator
    extends Authenticator {
        protected Console console = System.console();

        protected ConsoleAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.console == null) {
                throw new RuntimeException("Need a console for user interaction!");
            }
            String user = this.console.readLine("                                  \r" + this.getRequestingPrompt() + "\nUser: ", new Object[0]);
            char[] password = this.console.readPassword("Password: ", new Object[0]);
            return new PasswordAuthentication(user, password);
        }
    }

    class OneFile
    implements Downloadable {
        FileObject file;

        OneFile(FileObject file2) {
            this.file = file2;
        }

        @Override
        public File getDestination() {
            return CommandLine.this.files.prefix(this.file.filename);
        }

        @Override
        public String getURL() {
            return CommandLine.this.files.getURL(this.file);
        }

        @Override
        public long getFilesize() {
            return this.file.filesize;
        }

        public String toString() {
            return this.file.filename;
        }
    }

    protected class FileFilter
    implements FilesCollection.Filter {
        protected Set<String> fileNames;

        public FileFilter(List<String> files) {
            if (files != null && files.size() > 0) {
                this.fileNames = new HashSet<String>();
                for (String file2 : files) {
                    this.fileNames.add(FileObject.getFilename(file2, true));
                }
            }
        }

        @Override
        public boolean matches(FileObject file2) {
            if (!file2.isUpdateablePlatform(CommandLine.this.files)) {
                return false;
            }
            if (this.fileNames != null && !this.fileNames.contains(file2.getFilename(true))) {
                return false;
            }
            return file2.getStatus() != FileObject.Status.OBSOLETE_UNINSTALLED;
        }
    }
}

