/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.dnd;

import java.io.File;
import java.io.IOException;
import net.imagej.display.ImageDisplay;
import net.imagej.lut.LUTService;
import net.imglib2.display.ColorTable;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.dnd.AbstractDragAndDropHandler;
import org.scijava.ui.dnd.DragAndDropHandler;

@Plugin(type=DragAndDropHandler.class)
public class LUTFileDragAndDropHandler
extends AbstractDragAndDropHandler<File> {
    @Parameter(required=false)
    private LUTService lutService;
    @Parameter(required=false)
    private DisplayService displayService;
    @Parameter(required=false)
    private LogService log;

    @Override
    public boolean supports(File file2) {
        if (!super.supports(file2)) {
            return false;
        }
        if (this.lutService == null) {
            return false;
        }
        return this.lutService.isLUT(file2);
    }

    @Override
    public boolean supportsDisplay(Display<?> display) {
        return display == null || display instanceof ImageDisplay;
    }

    @Override
    public boolean drop(File file2, Display<?> display) {
        if (this.lutService == null || this.displayService == null) {
            return false;
        }
        this.check(file2, display);
        if (file2 == null) {
            return true;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        ColorTable colorTable = this.loadLUT(file2);
        if (colorTable == null) {
            return false;
        }
        if (display == null) {
            this.displayService.createDisplay(this.getBaseName(file2), colorTable);
        } else {
            this.lutService.applyLUT(colorTable, imageDisplay);
        }
        return true;
    }

    @Override
    public Class<File> getType() {
        return File.class;
    }

    private ColorTable loadLUT(File file2) {
        ColorTable colorTable;
        try {
            colorTable = this.lutService.loadLUT(file2);
        }
        catch (IOException exc) {
            if (this.log != null) {
                this.log.error("Error opening LUT: " + file2, exc);
            }
            return null;
        }
        return colorTable;
    }

    private String getBaseName(File file2) {
        String name = file2.getName();
        return name.toLowerCase().endsWith(".lut") ? name.substring(0, name.length() - 4) : name;
    }
}

