/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.imglib2.type.numeric.IntegerType;

public class UnboundedIntegerType
implements IntegerType<UnboundedIntegerType> {
    private BigInteger v;

    public UnboundedIntegerType() {
        this.set(BigInteger.ZERO);
    }

    public UnboundedIntegerType(UnboundedIntegerType other) {
        this.set(other);
    }

    public UnboundedIntegerType(long val) {
        this.set(val);
    }

    public UnboundedIntegerType(BigInteger val) {
        this.set(val);
    }

    public BigInteger get() {
        return this.v;
    }

    @Override
    public void set(long val) {
        this.v = BigInteger.valueOf(val);
    }

    @Override
    public void set(BigInteger val) {
        this.v = val;
    }

    @Override
    public UnboundedIntegerType createVariable() {
        return new UnboundedIntegerType();
    }

    @Override
    public UnboundedIntegerType copy() {
        return new UnboundedIntegerType(this);
    }

    @Override
    public void set(UnboundedIntegerType val) {
        this.v = val.v;
    }

    @Override
    public void add(UnboundedIntegerType val) {
        this.v = this.v.add(val.v);
    }

    @Override
    public void sub(UnboundedIntegerType val) {
        this.v = this.v.subtract(val.v);
    }

    @Override
    public void mul(UnboundedIntegerType val) {
        this.v = this.v.multiply(val.v);
    }

    @Override
    public void div(UnboundedIntegerType val) {
        this.v = this.v.divide(val.v);
    }

    @Override
    public void setZero() {
        this.v = BigInteger.ZERO;
    }

    @Override
    public void setOne() {
        this.v = BigInteger.ONE;
    }

    @Override
    public void mul(float val) {
        this.doMul(BigDecimal.valueOf(val));
    }

    @Override
    public void mul(double val) {
        this.doMul(BigDecimal.valueOf(val));
    }

    @Override
    public void mul(BigInteger val) {
        this.v = this.v.multiply(val);
    }

    @Override
    public void mul(BigDecimal val) {
        this.doMul(val);
    }

    private void doMul(BigDecimal factor) {
        BigDecimal val = new BigDecimal(this.v);
        BigDecimal result = val.multiply(factor);
        this.v = result.toBigInteger();
    }

    @Override
    public void inc() {
        this.v = this.v.add(BigInteger.ONE);
    }

    @Override
    public void dec() {
        this.v = this.v.subtract(BigInteger.ONE);
    }

    @Override
    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getMinValue() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getMinIncrement() {
        return Double.MIN_VALUE;
    }

    @Override
    public int getBitsPerPixel() {
        return 1024;
    }

    @Override
    public double getRealDouble() {
        return this.v.doubleValue();
    }

    @Override
    public float getRealFloat() {
        return this.v.floatValue();
    }

    @Override
    public double getImaginaryDouble() {
        return 0.0;
    }

    @Override
    public float getImaginaryFloat() {
        return 0.0f;
    }

    @Override
    public void setReal(float f) {
        this.set((long)f);
    }

    @Override
    public void setReal(double f) {
        this.set((long)f);
    }

    @Override
    public void setImaginary(float f) {
    }

    @Override
    public void setImaginary(double f) {
    }

    @Override
    public void setComplexNumber(float r, float i) {
        this.setReal(r);
    }

    @Override
    public void setComplexNumber(double r, double i) {
        this.setReal(r);
    }

    @Override
    public float getPowerFloat() {
        return this.v.floatValue();
    }

    @Override
    public double getPowerDouble() {
        return this.v.doubleValue();
    }

    @Override
    public float getPhaseFloat() {
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        return 0.0;
    }

    @Override
    public void complexConjugate() {
    }

    @Override
    public int compareTo(UnboundedIntegerType o) {
        return this.v.compareTo(o.v);
    }

    @Override
    public int getInteger() {
        return this.v.intValue();
    }

    @Override
    public long getIntegerLong() {
        return this.v.longValue();
    }

    public BigInteger getBigInteger() {
        return this.v;
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    public void setBigInteger(BigInteger v) {
        this.v = v;
    }

    public boolean valueEquals(UnboundedIntegerType t) {
        return Objects.equals(this.get(), t.get());
    }

    public String toString() {
        return this.get().toString();
    }
}

