/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.PreciseFixedFloatType;
import net.imglib2.type.numeric.ComplexType;

public class PreciseFixedComplexFloatType
implements ComplexType<PreciseFixedComplexFloatType> {
    private PreciseFixedFloatType real;
    private PreciseFixedFloatType imag;

    public PreciseFixedComplexFloatType() {
        this.real = new PreciseFixedFloatType();
        this.imag = new PreciseFixedFloatType();
    }

    public PreciseFixedComplexFloatType(double r, double i) {
        this.real = new PreciseFixedFloatType(r);
        this.imag = new PreciseFixedFloatType(i);
    }

    public PreciseFixedComplexFloatType(BigDecimal r, BigDecimal i) {
        this.real = new PreciseFixedFloatType(r);
        this.imag = new PreciseFixedFloatType(i);
    }

    public PreciseFixedComplexFloatType(String r, String i) {
        this.real = new PreciseFixedFloatType(r);
        this.imag = new PreciseFixedFloatType(i);
    }

    public PreciseFixedComplexFloatType(PreciseFixedComplexFloatType other) {
        this();
        this.set(other);
    }

    public PreciseFixedFloatType getReal() {
        return this.real;
    }

    public PreciseFixedFloatType getImag() {
        return this.imag;
    }

    @Override
    public void setReal(double r) {
        this.real.set(r);
    }

    public void setImag(double i) {
        this.imag.set(i);
    }

    public void setReal(BigDecimal r) {
        this.real.set(r);
    }

    public void setImag(BigDecimal i) {
        this.imag.set(i);
    }

    public void setReal(PreciseFixedFloatType r) {
        this.real.set(r);
    }

    public void setImag(PreciseFixedFloatType i) {
        this.imag.set(i);
    }

    @Override
    public void set(PreciseFixedComplexFloatType other) {
        this.setReal(other.getReal());
        this.setImag(other.getImag());
    }

    public void add(PreciseFixedComplexFloatType a, PreciseFixedComplexFloatType b) {
        this.real.add(a.getReal(), b.getReal());
        this.imag.add(a.getImag(), b.getImag());
    }

    @Override
    public void add(PreciseFixedComplexFloatType c) {
        this.add(this, c);
    }

    public void sub(PreciseFixedComplexFloatType a, PreciseFixedComplexFloatType b) {
        this.real.sub(a.getReal(), b.getReal());
        this.imag.sub(a.getImag(), b.getImag());
    }

    @Override
    public void sub(PreciseFixedComplexFloatType c) {
        this.sub(this, c);
    }

    public void mul(PreciseFixedComplexFloatType a, PreciseFixedComplexFloatType b) {
        PreciseFixedFloatType t1 = new PreciseFixedFloatType();
        PreciseFixedFloatType t2 = new PreciseFixedFloatType();
        PreciseFixedFloatType sum1 = new PreciseFixedFloatType();
        PreciseFixedFloatType sum2 = new PreciseFixedFloatType();
        t1.mul(a.getReal(), b.getReal());
        t2.mul(a.getImag(), b.getImag());
        sum1.sub(t1, t2);
        t1.mul(a.getImag(), b.getReal());
        t2.mul(a.getReal(), b.getImag());
        sum2.add(t1, t2);
        this.setReal(sum1);
        this.setImag(sum2);
    }

    @Override
    public void mul(PreciseFixedComplexFloatType c) {
        this.mul(this, c);
    }

    public void div(PreciseFixedComplexFloatType a, PreciseFixedComplexFloatType b) {
        PreciseFixedFloatType denom = new PreciseFixedFloatType();
        PreciseFixedFloatType sum1 = new PreciseFixedFloatType();
        PreciseFixedFloatType sum2 = new PreciseFixedFloatType();
        sum1.mul(b.getReal(), b.getReal());
        sum2.mul(b.getImag(), b.getImag());
        denom.add(sum1, sum2);
        sum1.mul(a.getReal(), b.getReal());
        sum2.mul(a.getImag(), b.getImag());
        this.real.add(sum1, sum2);
        this.real.div(denom);
        sum1.mul(a.getImag(), b.getReal());
        sum2.mul(a.getReal(), b.getImag());
        this.imag.sub(sum1, sum2);
        this.imag.div(denom);
    }

    @Override
    public void div(PreciseFixedComplexFloatType c) {
        this.div(this, c);
    }

    @Override
    public void setZero() {
        this.real.setZero();
        this.imag.setZero();
    }

    @Override
    public void setOne() {
        this.real.setOne();
        this.imag.setZero();
    }

    @Override
    public void mul(float c) {
        this.mul((double)c);
    }

    @Override
    public void mul(double c) {
        this.real.mul(c);
        this.imag.mul(c);
    }

    @Override
    public PreciseFixedComplexFloatType createVariable() {
        return new PreciseFixedComplexFloatType();
    }

    @Override
    public PreciseFixedComplexFloatType copy() {
        return new PreciseFixedComplexFloatType(this);
    }

    @Override
    public double getRealDouble() {
        return this.real.getRealDouble();
    }

    @Override
    public float getRealFloat() {
        return this.real.getRealFloat();
    }

    @Override
    public double getImaginaryDouble() {
        return this.imag.getRealDouble();
    }

    @Override
    public float getImaginaryFloat() {
        return this.imag.getRealFloat();
    }

    @Override
    public void setReal(float f) {
        this.setReal((double)f);
    }

    @Override
    public void setImaginary(float f) {
        this.setImag(f);
    }

    @Override
    public void setImaginary(double f) {
        this.setImag(f);
    }

    @Override
    public void setComplexNumber(float r, float i) {
        this.setReal(r);
        this.setImag(i);
    }

    @Override
    public void setComplexNumber(double r, double i) {
        this.setReal(r);
        this.setImag(i);
    }

    @Override
    public float getPowerFloat() {
        return (float)this.getPowerDouble();
    }

    @Override
    public double getPowerDouble() {
        return this.getPower().getRealDouble();
    }

    public PreciseFixedFloatType getPower() {
        PreciseFixedFloatType a = new PreciseFixedFloatType();
        PreciseFixedFloatType b = new PreciseFixedFloatType();
        PreciseFixedFloatType sum = new PreciseFixedFloatType();
        a.mul(this.real, this.real);
        b.mul(this.imag, this.imag);
        sum.add(a, b);
        return PreciseFixedFloatType.sqrt(sum);
    }

    @Override
    public float getPhaseFloat() {
        return (float)this.getPhaseDouble();
    }

    @Override
    public double getPhaseDouble() {
        return this.getPhase().getRealDouble();
    }

    public PreciseFixedFloatType getPhase() {
        return PreciseFixedFloatType.atan2(this.imag, this.real);
    }

    @Override
    public void complexConjugate() {
        this.imag.negate();
    }

    public boolean valueEquals(PreciseFixedComplexFloatType t) {
        if (t == null) {
            return false;
        }
        return this.getReal().valueEquals(t.getReal()) && this.getImag().valueEquals(t.getImag());
    }
}

