/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import org.scijava.AbstractContextual;

public class DataType128BitSignedComplexFloat
extends AbstractContextual
implements DataType<ComplexDoubleType> {
    private ComplexDoubleType type = new ComplexDoubleType();

    @Override
    public ComplexDoubleType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "128-bit complex";
    }

    @Override
    public String longName() {
        return "128-bit complex float";
    }

    @Override
    public String description() {
        return "A complex floating data type with 64-bit double subcomponents";
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public void lowerBound(ComplexDoubleType dest) {
        throw new UnsupportedOperationException("complex numbers are unbounded");
    }

    @Override
    public void upperBound(ComplexDoubleType dest) {
        throw new UnsupportedOperationException("complex numbers are unbounded");
    }

    @Override
    public int bitCount() {
        return 128;
    }

    @Override
    public ComplexDoubleType createVariable() {
        return new ComplexDoubleType();
    }

    @Override
    public void cast(ComplexDoubleType val, BigComplex dest) {
        dest.setReal(val.getRealDouble());
        dest.setImag(val.getImaginaryDouble());
    }

    @Override
    public void cast(BigComplex val, ComplexDoubleType dest) {
        dest.setReal(val.getReal().doubleValue());
        dest.setImaginary(val.getImag().doubleValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return false;
    }

    @Override
    public boolean hasLongRepresentation() {
        return false;
    }

    @Override
    public double asDouble(ComplexDoubleType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong(ComplexDoubleType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(ComplexDoubleType val, double v) {
        val.setReal(v);
        val.setImaginary(0.0f);
    }

    @Override
    public void setLong(ComplexDoubleType val, long v) {
        val.setReal(v);
        val.setImaginary(0.0f);
    }
}

