/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import net.imglib2.type.numeric.ComplexType;

public class BigComplex
implements ComplexType<BigComplex> {
    private static final int DIGITS = 50;
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final BigDecimal SQRT_PRE = new BigDecimal(10).pow(50);
    private static final BigDecimal PI = new BigDecimal("3.14159265358979323846264338327950288419716939937510");
    private static final BigDecimal E = new BigDecimal("2.71828182845904523536028747135266249775724709369995");
    private static final BigDecimal[] ANGLES = BigComplex.angles();
    private static final BigDecimal[] POWERS_OF_TWO = BigComplex.powersOfTwo(ANGLES.length);
    private BigDecimal r;
    private BigDecimal i;

    public BigComplex() {
        this.setZero();
    }

    public BigComplex(long r, long i) {
        this.setReal(r);
        this.setImag(i);
    }

    public BigComplex(double r, double i) {
        this.setReal(r);
        this.setImag(i);
    }

    public BigComplex(BigInteger r, BigInteger i) {
        this.setReal(r);
        this.setImag(i);
    }

    public BigComplex(BigDecimal r, BigDecimal i) {
        this.setReal(r);
        this.setImag(i);
    }

    public BigComplex(String r, String i) {
        this.setReal(r);
        this.setImag(i);
    }

    public BigDecimal getReal() {
        return this.r;
    }

    public BigDecimal getImag() {
        return this.i;
    }

    @Override
    public void set(BigComplex other) {
        this.r = other.r;
        this.i = other.i;
    }

    public void set(long r, long i) {
        this.setReal(r);
        this.setImag(i);
    }

    public void set(double r, double i) {
        this.setReal(r);
        this.setImag(i);
    }

    public void set(BigInteger r, BigInteger i) {
        this.setReal(r);
        this.setImag(i);
    }

    public void set(BigDecimal r, BigDecimal i) {
        this.setReal(r);
        this.setImag(i);
    }

    public void set(String r, String i) {
        this.setReal(r);
        this.setImag(i);
    }

    public void setReal(long r) {
        this.r = BigDecimal.valueOf(r);
    }

    @Override
    public void setReal(float f) {
        this.r = BigDecimal.valueOf(f);
    }

    @Override
    public void setReal(double r) {
        this.r = BigDecimal.valueOf(r);
    }

    public void setReal(BigInteger r) {
        this.r = new BigDecimal(r);
    }

    public void setReal(BigDecimal r) {
        this.r = r;
    }

    public void setReal(String r) {
        this.r = new BigDecimal(r);
    }

    public void setImag(long i) {
        this.i = BigDecimal.valueOf(i);
    }

    public void setImag(double i) {
        this.i = BigDecimal.valueOf(i);
    }

    public void setImag(BigInteger i) {
        this.i = new BigDecimal(i);
    }

    public void setImag(BigDecimal i) {
        this.i = i;
    }

    public void setImag(String i) {
        this.i = new BigDecimal(i);
    }

    @Override
    public void setImaginary(float f) {
        this.i = BigDecimal.valueOf(f);
    }

    @Override
    public void setImaginary(double f) {
        this.i = BigDecimal.valueOf(f);
    }

    @Override
    public void setComplexNumber(float r, float i) {
        this.setReal(r);
        this.setImag(i);
    }

    @Override
    public void setComplexNumber(double r, double i) {
        this.setReal(r);
        this.setImag(i);
    }

    public void setComplexNumber(BigDecimal r, BigDecimal i) {
        this.setReal(r);
        this.setImag(i);
    }

    public void setComplexNumber(String r, String i) {
        this.setReal(r);
        this.setImag(i);
    }

    @Override
    public void setZero() {
        this.r = BigDecimal.ZERO;
        this.i = BigDecimal.ZERO;
    }

    @Override
    public void setOne() {
        this.r = BigDecimal.ONE;
        this.i = BigDecimal.ZERO;
    }

    @Override
    public BigComplex createVariable() {
        return new BigComplex();
    }

    @Override
    public BigComplex copy() {
        return new BigComplex(this.r, this.i);
    }

    public void add(BigComplex a, BigComplex b) {
        this.r = a.r.add(b.r);
        this.i = a.i.add(b.i);
    }

    @Override
    public void add(BigComplex other) {
        this.add(this, other);
    }

    public void sub(BigComplex a, BigComplex b) {
        this.r = a.r.subtract(b.r);
        this.i = a.i.subtract(b.i);
    }

    @Override
    public void sub(BigComplex other) {
        this.sub(this, other);
    }

    public void mul(BigComplex a, BigComplex b) {
        BigDecimal t1 = a.r.multiply(b.r);
        BigDecimal t2 = a.i.multiply(b.i);
        BigDecimal sum1 = t1.subtract(t2);
        t1 = a.i.multiply(b.r);
        t2 = a.r.multiply(b.i);
        BigDecimal sum2 = t1.add(t2);
        this.r = sum1;
        this.i = sum2;
    }

    @Override
    public void mul(BigComplex other) {
        this.mul(this, other);
    }

    public void div(BigComplex a, BigComplex b) {
        BigDecimal t1 = b.r.multiply(b.r);
        BigDecimal t2 = b.i.multiply(b.i);
        BigDecimal denom = t1.add(t2);
        t1 = a.r.multiply(b.r);
        t2 = a.i.multiply(b.i);
        BigDecimal sum1 = t1.add(t2);
        t1 = a.i.multiply(b.r);
        t2 = a.r.multiply(b.i);
        BigDecimal sum2 = t1.subtract(t2);
        this.r = sum1.divide(denom, 50, RoundingMode.HALF_UP);
        this.i = sum2.divide(denom, 50, RoundingMode.HALF_UP);
    }

    @Override
    public void div(BigComplex other) {
        this.div(this, other);
    }

    @Override
    public void mul(float c) {
        this.mul(new BigComplex(BigDecimal.valueOf(c), BigDecimal.ZERO));
    }

    @Override
    public void mul(double c) {
        this.mul(new BigComplex(BigDecimal.valueOf(c), BigDecimal.ZERO));
    }

    @Override
    public void complexConjugate() {
        this.i = this.i.negate();
    }

    @Override
    public double getRealDouble() {
        return this.r.doubleValue();
    }

    @Override
    public float getRealFloat() {
        return this.r.floatValue();
    }

    @Override
    public double getImaginaryDouble() {
        return this.i.doubleValue();
    }

    @Override
    public float getImaginaryFloat() {
        return this.i.floatValue();
    }

    @Override
    public float getPowerFloat() {
        return this.modulus().floatValue();
    }

    @Override
    public double getPowerDouble() {
        return this.modulus().doubleValue();
    }

    public BigDecimal getPower() {
        return this.modulus();
    }

    @Override
    public float getPhaseFloat() {
        return this.phase().floatValue();
    }

    @Override
    public double getPhaseDouble() {
        return this.phase().doubleValue();
    }

    public BigDecimal getPhase() {
        return this.phase();
    }

    public void PI() {
        this.setReal(PI);
        this.setImag(BigDecimal.ZERO);
    }

    public void E() {
        this.setReal(E);
        this.setImag(BigDecimal.ZERO);
    }

    public boolean valueEquals(BigComplex t) {
        return Objects.equals(this.getReal(), t.getReal()) && Objects.equals(this.getImag(), t.getImag());
    }

    private BigDecimal modulus() {
        BigDecimal a = this.r.multiply(this.r);
        BigDecimal b = this.i.multiply(this.i);
        BigDecimal sum = a.add(b);
        return BigComplex.bigSqrt(sum);
    }

    private BigDecimal phase() {
        return this.atan2(this.i, this.r);
    }

    private static BigDecimal bigSqrt(BigDecimal c) {
        BigDecimal precision = BigDecimal.ONE.divide(SQRT_PRE, 50, RoundingMode.HALF_UP);
        return BigComplex.sqrtNewtonRaphson(c, BigDecimal.ONE, precision);
    }

    private static BigDecimal sqrtNewtonRaphson(BigDecimal c, BigDecimal xn, BigDecimal precision) {
        BigDecimal fx = xn.pow(2).add(c.negate());
        BigDecimal fpx = xn.multiply(TWO);
        BigDecimal xn1 = fx.divide(fpx, 100, RoundingMode.HALF_DOWN);
        xn1 = xn.add(xn1.negate());
        BigDecimal currentSquare = xn1.pow(2);
        BigDecimal currentPrecision = currentSquare.subtract(c);
        if ((currentPrecision = currentPrecision.abs()).compareTo(precision) <= 0) {
            return xn1;
        }
        return BigComplex.sqrtNewtonRaphson(c, xn1, precision);
    }

    private BigDecimal atan2(BigDecimal y, BigDecimal x) {
        BigDecimal tx = x;
        BigDecimal ty = y;
        BigDecimal angle = BigDecimal.ZERO;
        if (tx.compareTo(BigDecimal.ZERO) < 0) {
            angle = PI;
            tx = tx.negate();
            ty = ty.negate();
        } else if (ty.compareTo(BigDecimal.ZERO) < 0) {
            angle = TWO.multiply(PI);
        }
        for (int j = 0; j < ANGLES.length; ++j) {
            BigDecimal yNew;
            BigDecimal xNew;
            BigDecimal twoPowJ = POWERS_OF_TWO[j];
            BigDecimal dx = tx.divide(twoPowJ, 50, RoundingMode.HALF_UP);
            BigDecimal dy = ty.divide(twoPowJ, 50, RoundingMode.HALF_UP);
            if (ty.compareTo(BigDecimal.ZERO) < 0) {
                xNew = tx.subtract(dy);
                yNew = ty.add(dx);
                angle = angle.subtract(ANGLES[j]);
            } else {
                xNew = tx.add(dy);
                yNew = ty.subtract(dx);
                angle = angle.add(ANGLES[j]);
            }
            tx = xNew;
            ty = yNew;
        }
        return angle;
    }

    private static BigDecimal[] angles() {
        return new BigDecimal[]{new BigDecimal("0.7853981633974483096156608458198757210492923498437764"), new BigDecimal("0.4636476090008061162142562314612144020285370542861202"), new BigDecimal("0.2449786631268641541720824812112758109141440983811840"), new BigDecimal("0.1243549945467614350313548491638710255731701917698040"), new BigDecimal("0.0624188099959573484739791129855051136062738877974991"), new BigDecimal("0.0312398334302682762537117448924909770324956637254000"), new BigDecimal("0.0156237286204768308028015212565703189111141398009054"), new BigDecimal("0.0078123410601011112964633918421992816212228117250147"), new BigDecimal("0.0039062301319669718276286653114243871403574901152028"), new BigDecimal("0.0019531225164788186851214826250767139316107467772335"), new BigDecimal("0.0009765621895593194304034301997172908516341970158100"), new BigDecimal("0.0004882812111948982754692396256448486661923611331350"), new BigDecimal("0.0002441406201493617640167229432596599862124177909706"), new BigDecimal("0.0001220703118936702042390586461179563009308294090157"), new BigDecimal("0.0000610351561742087750216625691738291537851435368333"), new BigDecimal("0.0000305175781155260968618259534385360197509496751194"), new BigDecimal("0.0000152587890613157621072319358126978851374292381445"), new BigDecimal("0.0000076293945311019702633884823401050905863507439184"), new BigDecimal("0.0000038146972656064962829230756163729937228052573039"), new BigDecimal("0.0000019073486328101870353653693059172441687143421654"), new BigDecimal("0.00000095367431640596087942067068992311239001963412449"), new BigDecimal("0.00000047683715820308885992758382144924707587049404378"), new BigDecimal("0.00000023841857910155798249094797721893269783096898769"), new BigDecimal("0.00000011920928955078068531136849713792211264596758766"), new BigDecimal("0.000000059604644775390554413921062141788874250030195782"), new BigDecimal("0.000000029802322387695303676740132767709503349043907067"), new BigDecimal("0.000000014901161193847655147092516595963247108248930025"), new BigDecimal("0.0000000074505805969238279871365645744953921132066925545"), new BigDecimal("0.0000000037252902984619140452670705718119235836719483287"), new BigDecimal("0.0000000018626451492309570290958838214764904345065282835"), new BigDecimal("0.0000000009313225746154785153557354776845613038929264961"), new BigDecimal("0.0000000004656612873077392577788419347105701629734786389"), new BigDecimal("0.0000000002328306436538696289020427418388212703712742932"), new BigDecimal("0.0000000001164153218269348144525990927298526587963964573"), new BigDecimal("0.00000000005820766091346740722649676159123158234954915625"), new BigDecimal("0.00000000002910383045673370361327303269890394779369363200"), new BigDecimal("0.00000000001455191522836685180663959783736299347421170360"), new BigDecimal("0.000000000007275957614183425903320184104670374184276462938"), new BigDecimal("0.000000000003637978807091712951660140200583796773034557866"), new BigDecimal("0.000000000001818989403545856475830076118822974596629319733"), new BigDecimal("0.0000000000009094947017729282379150388117278718245786649666"), new BigDecimal("0.0000000000004547473508864641189575194999034839780723331208"), new BigDecimal("0.0000000000002273736754432320594787597617066854972590416401"), new BigDecimal("0.0000000000001136868377216160297393798823227106871573802050"), new BigDecimal("0.00000000000005684341886080801486968994134502633589467252562"), new BigDecimal("0.00000000000002842170943040400743484497069547204198683406570"), new BigDecimal("0.00000000000001421085471520200371742248535060588024835425821"), new BigDecimal("0.000000000000007105427357601001858711242675661672531044282276"), new BigDecimal("0.000000000000003552713678800500929355621337875677816380535284"), new BigDecimal("0.000000000000001776356839400250464677810668943444102047566910"), new BigDecimal("0.0000000000000008881784197001252323389053344724227002559458638"), new BigDecimal("0.0000000000000004440892098500626161694526672362989312819932329"), new BigDecimal("0.0000000000000002220446049250313080847263336181604132852491541"), new BigDecimal("0.0000000000000001110223024625156540423631668090815750981561442"), new BigDecimal("0.00000000000000005551115123125782702118158340454095860601951803"), new BigDecimal("0.00000000000000002775557561562891351059079170227050068512743975"), new BigDecimal("0.00000000000000001387778780781445675529539585113525301532842996"), new BigDecimal("0.000000000000000006938893903907228377647697925567626841759803746")};
    }

    private static BigDecimal[] powersOfTwo(int length) {
        BigDecimal[] powers = new BigDecimal[length];
        BigDecimal power = BigDecimal.ONE;
        for (int i = 0; i < length; ++i) {
            powers[i] = power;
            power = power.multiply(TWO);
        }
        return powers;
    }
}

