/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.table;

import net.imagej.table.DefaultResultsTable;
import net.imagej.table.DoubleColumn;
import net.imagej.table.ResultsTable;
import net.imagej.table.Table;
import net.imagej.table.TableDisplay;
import org.scijava.display.AbstractDisplay;
import org.scijava.display.Display;
import org.scijava.plugin.Plugin;

@Plugin(type=Display.class)
public class DefaultTableDisplay
extends AbstractDisplay<Table<?, ?>>
implements TableDisplay {
    public DefaultTableDisplay() {
        super(Table.class);
    }

    @Override
    public boolean canDisplay(Class<?> c) {
        if (c == double[].class || c == double[][].class) {
            return true;
        }
        return super.canDisplay(c);
    }

    @Override
    public void display(Object o) {
        if (o instanceof double[]) {
            this.display(this.wrapArrayAsTable(new double[][]{(double[])o}));
            return;
        }
        if (o instanceof double[][]) {
            this.display(this.wrapArrayAsTable((double[][])o));
            return;
        }
        super.display(o);
    }

    @Override
    public boolean isDisplaying(Object o) {
        if (super.isDisplaying(o)) {
            return true;
        }
        if (o instanceof double[]) {
            this.arrayEqualsTable(new double[][]{(double[])o});
        }
        if (o instanceof double[][]) {
            this.arrayEqualsTable((double[][])o);
        }
        return false;
    }

    private ResultsTable wrapArrayAsTable(double[][] array) {
        DefaultResultsTable table = new DefaultResultsTable();
        int rowCount = 0;
        for (int d = 0; d < array.length; ++d) {
            DoubleColumn column = new DoubleColumn();
            column.setArray(array[d]);
            table.add(column);
            if (rowCount >= array[d].length) continue;
            rowCount = array[d].length;
        }
        table.setRowCount(rowCount);
        return table;
    }

    private boolean arrayEqualsTable(double[][] array) {
        for (Table table : this) {
            ResultsTable resultsTable;
            if (!(table instanceof ResultsTable) || array.length != (resultsTable = (ResultsTable)table).getColumnCount()) continue;
            boolean equal = true;
            for (int c = 0; c < array.length; ++c) {
                if (array[c] == ((DoubleColumn)resultsTable.get(c)).getArray()) continue;
                equal = false;
                break;
            }
            return equal;
        }
        return false;
    }
}

