/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imagej.axis.Axis;
import net.imagej.space.AnnotatedSpace;

public abstract class AbstractAnnotatedSpace<A extends Axis>
implements AnnotatedSpace<A> {
    private final List<A> axisList;

    public AbstractAnnotatedSpace(int numDims) {
        this.axisList = new ArrayList<A>(numDims);
        for (int d = 0; d < numDims; ++d) {
            this.axisList.add(null);
        }
    }

    public AbstractAnnotatedSpace(A ... axes) {
        this(Arrays.asList(axes));
    }

    public AbstractAnnotatedSpace(List<A> axes) {
        this.axisList = new ArrayList<A>(axes.size());
        this.axisList.addAll(axes);
    }

    @Override
    public A axis(int d) {
        return (A)((Axis)this.axisList.get(d));
    }

    @Override
    public void axes(A[] axes) {
        for (int d = 0; d < axes.length; ++d) {
            axes[d] = this.axis(d);
        }
    }

    @Override
    public void setAxis(A axis, int d) {
        while (this.axisList.size() <= d) {
            this.axisList.add(null);
        }
        this.axisList.set(d, axis);
    }

    @Override
    public int numDimensions() {
        return this.axisList.size();
    }
}

