/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.sampler;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imagej.sampler.AxisSubrange;
import net.imagej.sampler.DensePositionIterator;
import net.imagej.sampler.SamplerService;
import net.imagej.sampler.SamplingDefinition;
import net.imagej.sampler.SparsePositionIterator;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.display.ColorTable;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import org.scijava.display.DisplayService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.RealRect;

@Plugin(type=Service.class)
public class DefaultSamplerService
extends AbstractService
implements SamplerService {
    @Parameter
    private DisplayService displayService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ImageDisplayService imgDispService;

    @Override
    public ImageDisplay createSampledImage(SamplingDefinition def) {
        if (def.getError() != null) {
            throw new IllegalArgumentException("SamplingDefinition error: " + def.getError());
        }
        ImageDisplay outputImage = this.createOutputImage(def);
        this.copyData(def, outputImage);
        return outputImage;
    }

    @Override
    public ImageDisplay duplicate(ImageDisplay display) {
        SamplingDefinition copyDef = SamplingDefinition.sampleAllPlanes(display);
        return this.createSampledImage(copyDef);
    }

    @Override
    public ImageDisplay duplicateSelectedPlane(ImageDisplay display) {
        SamplingDefinition copyDef = SamplingDefinition.sampleXYPlane(display);
        RealRect selection = this.overlayService.getSelectionBounds(display);
        long minX = (long)selection.x;
        long minY = (long)selection.y;
        long maxX = (long)(selection.x + selection.width);
        long maxY = (long)(selection.y + selection.height);
        AxisSubrange xSubrange = new AxisSubrange(minX, maxX);
        AxisSubrange ySubrange = new AxisSubrange(minY, maxY);
        copyDef.constrain(Axes.X, xSubrange);
        copyDef.constrain(Axes.Y, ySubrange);
        return this.createSampledImage(copyDef);
    }

    @Override
    public ImageDisplay duplicateSelectedCompositePlane(ImageDisplay display) {
        SamplingDefinition copyDef = SamplingDefinition.sampleCompositeXYPlane(display);
        RealRect selection = this.overlayService.getSelectionBounds(display);
        long minX = (long)selection.x;
        long minY = (long)selection.y;
        long maxX = (long)(selection.x + selection.width);
        long maxY = (long)(selection.y + selection.height);
        AxisSubrange xSubrange = new AxisSubrange(minX, maxX);
        AxisSubrange ySubrange = new AxisSubrange(minY, maxY);
        copyDef.constrain(Axes.X, xSubrange);
        copyDef.constrain(Axes.Y, ySubrange);
        return this.createSampledImage(copyDef);
    }

    @Override
    public ImageDisplay duplicateSelectedPlanes(ImageDisplay display) {
        SamplingDefinition copyDef = SamplingDefinition.sampleAllPlanes(display);
        RealRect selection = this.overlayService.getSelectionBounds(display);
        long minX = (long)selection.x;
        long minY = (long)selection.y;
        long maxX = (long)(selection.x + selection.width);
        long maxY = (long)(selection.y + selection.height);
        AxisSubrange xSubrange = new AxisSubrange(minX, maxX);
        AxisSubrange ySubrange = new AxisSubrange(minY, maxY);
        copyDef.constrain(Axes.X, xSubrange);
        copyDef.constrain(Axes.Y, ySubrange);
        return this.createSampledImage(copyDef);
    }

    private ImageDisplay createOutputImage(SamplingDefinition def) {
        int chanAxis;
        ImageDisplay origDisp = def.getDisplay();
        Dataset origDs = (Dataset)origDisp.getActiveView().getData();
        long[] dims = def.getOutputDims();
        String name = origDisp.getName();
        AxisType[] axes = def.getOutputAxes();
        CalibratedAxis[] calibAxes = def.getOutputCalibratedAxes();
        int bitsPerPixel = origDs.getType().getBitsPerPixel();
        boolean signed = origDs.isSigned();
        boolean floating = !origDs.isInteger();
        Dataset output = this.datasetService.create(dims, name, axes, bitsPerPixel, signed, floating);
        output.setAxes(calibAxes);
        long numPlanes = this.calcNumPlanes(dims, axes);
        if (numPlanes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("output image has more too many planes " + numPlanes + " (max = " + Integer.MAX_VALUE + ")");
        }
        output.getImgPlus().initializeColorTables((int)numPlanes);
        if (origDs.isRGBMerged() && (chanAxis = output.dimensionIndex(Axes.CHANNEL)) >= 0 && output.dimension(chanAxis) == 3L) {
            output.setRGBMerged(true);
        }
        return (ImageDisplay)this.displayService.createDisplay(name, output);
    }

    private void copyData(SamplingDefinition def, ImageDisplay outputImage) {
        SparsePositionIterator iter1 = new SparsePositionIterator(def);
        DensePositionIterator iter2 = new DensePositionIterator(def);
        Dataset input = (Dataset)def.getDisplay().getActiveView().getData();
        Dataset output = (Dataset)outputImage.getActiveView().getData();
        long[] inputDims = Intervals.dimensionsAsLongArray((Dimensions)input);
        long[] outputDims = Intervals.dimensionsAsLongArray((Dimensions)output);
        RandomAccess<RealType<?>> inputAccessor = input.getImgPlus().randomAccess();
        RandomAccess<RealType<?>> outputAccessor = output.getImgPlus().randomAccess();
        while (iter1.hasNext() && iter2.hasNext()) {
            long[] inputPos = iter1.next();
            long[] outputPos = iter2.next();
            inputAccessor.setPosition(inputPos);
            outputAccessor.setPosition(outputPos);
            double value = ((RealType)inputAccessor.get()).getRealDouble();
            ((RealType)outputAccessor.get()).setReal(value);
            int inputPlaneNumber = this.planeNum(inputDims, inputPos);
            ColorTable lut = input.getColorTable(inputPlaneNumber);
            int outputPlaneNumber = this.planeNum(outputDims, outputPos);
            output.setColorTable(lut, outputPlaneNumber);
        }
        this.setCompositeChannelCount(input, output);
        this.updateDisplayColorTables(def, outputImage);
        ImgPlus<RealType<?>> outputImgPlus = output.getImgPlus();
        for (int channel = 0; channel < outputImgPlus.getCompositeChannelCount(); ++channel) {
            outputImgPlus.setChannelMinimum(channel, Double.NaN);
            outputImgPlus.setChannelMaximum(channel, Double.NaN);
        }
        this.setDisplayRanges(def, outputImage);
    }

    private int planeNum(long[] dims, long[] pos) {
        int plane = 0;
        int inc = 1;
        for (int i = 2; i < dims.length; ++i) {
            plane = (int)((long)plane + pos[i] * (long)inc);
            inc = (int)((long)inc * dims[i]);
        }
        return plane;
    }

    private void setCompositeChannelCount(Dataset input, Dataset output) {
        if (input.getCompositeChannelCount() == 1) {
            return;
        }
        int index = output.dimensionIndex(Axes.CHANNEL);
        long numChannels = index < 0 ? 1L : output.dimension(index);
        output.setCompositeChannelCount((int)numChannels);
        output.rebuild();
    }

    private void updateDisplayColorTables(SamplingDefinition def, ImageDisplay output) {
        ImageDisplay input = def.getDisplay();
        DatasetView inView = this.imgDispService.getActiveDatasetView(input);
        DatasetView outView = this.imgDispService.getActiveDatasetView(output);
        List<ColorTable> inputColorTables = inView.getColorTables();
        int inputChanAxis = input.dimensionIndex(Axes.CHANNEL);
        List<List<Long>> inputRanges = def.getInputRanges();
        for (int i = 0; i < inputColorTables.size(); ++i) {
            int outIndex = this.outputColorTableNumber(inputRanges, i, inputChanAxis);
            if (outIndex < 0) continue;
            outView.setColorTable(inputColorTables.get(i), outIndex);
        }
    }

    private int outputColorTableNumber(List<List<Long>> inputRanges, int inputChannel, int inputChanAxis) {
        if (inputChanAxis < 0) {
            if (inputChannel == 0) {
                return 0;
            }
            return -1;
        }
        List<Long> channelRanges = inputRanges.get(inputChanAxis);
        for (int pos = 0; pos < channelRanges.size(); ++pos) {
            if (channelRanges.get(pos) != (long)inputChannel) continue;
            return pos;
        }
        return -1;
    }

    private void attachOverlays(ImageDisplay inputDisp, ImageDisplay outputDisp, List<Overlay> overlays) {
        RealRect bounds = this.overlayService.getSelectionBounds(inputDisp);
        double[] toOrigin = new double[]{-bounds.x, -bounds.y};
        ArrayList<Overlay> newOverlays = new ArrayList<Overlay>();
        for (Overlay overlay : overlays) {
            if (!this.overlayWithinBounds(overlay, bounds)) continue;
            if (toOrigin[0] == 0.0 && toOrigin[1] == 0.0) {
                newOverlays.add(overlay);
                continue;
            }
            Overlay newOverlay = overlay.duplicate();
            newOverlay.move(toOrigin);
            newOverlays.add(newOverlay);
        }
        this.overlayService.addOverlays(outputDisp, newOverlays);
    }

    private boolean overlayWithinBounds(Overlay overlay, RealRect bounds) {
        if (overlay.realMin(0) < bounds.x) {
            return false;
        }
        if (overlay.realMin(1) < bounds.y) {
            return false;
        }
        if (overlay.realMax(0) > bounds.x + bounds.width) {
            return false;
        }
        return !(overlay.realMax(1) > bounds.y + bounds.height);
    }

    private long calcNumPlanes(long[] dims, AxisType[] axes) {
        long num = 1L;
        for (int i = 0; i < dims.length; ++i) {
            AxisType type = axes[i];
            if (type == Axes.X || type == Axes.Y) continue;
            num *= dims[i];
        }
        return num;
    }

    private void setDisplayRanges(SamplingDefinition def, ImageDisplay output) {
        ImageDisplay input = def.getDisplay();
        DatasetView inView = this.imgDispService.getActiveDatasetView(input);
        DatasetView outView = this.imgDispService.getActiveDatasetView(output);
        int inputChanAxis = input.dimensionIndex(Axes.CHANNEL);
        List<List<Long>> inputRanges = def.getInputRanges();
        for (int i = 0; i < inView.getChannelCount(); ++i) {
            int outIndex = this.outputColorTableNumber(inputRanges, i, inputChanAxis);
            if (outIndex < 0) continue;
            double min = inView.getChannelMin(i);
            double max = inView.getChannelMax(i);
            outView.setChannelRange(outIndex, min, max);
        }
    }
}

