/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public abstract class LegacyHooks {
    private boolean enableIJ1PluginDirs = true;
    private final Collection<File> pluginClasspath = new LinkedHashSet<File>();
    private Map<String, String> menuStructure = new LinkedHashMap<String, String>();

    public boolean isLegacyMode() {
        return true;
    }

    public Object getContext() {
        return null;
    }

    public boolean quit() {
        return true;
    }

    public void installed() {
    }

    public void dispose() {
    }

    public Object interceptRunPlugIn(String className, String arg) {
        return null;
    }

    public void showProgress(double progress) {
    }

    public void showProgress(int currentIndex, int finalIndex) {
    }

    public void showStatus(String status) {
    }

    public void log(String message) {
    }

    public void registerImage(Object image) {
    }

    public void unregisterImage(Object image) {
    }

    public void debug(String string) {
        System.err.println(string);
    }

    public void error(Throwable t) {
    }

    public String getAppName() {
        return "ImageJ";
    }

    public String getAppVersion() {
        return null;
    }

    public URL getIconURL() {
        return null;
    }

    public boolean openInEditor(String path) {
        return false;
    }

    public boolean createInEditor(String fileName, String content) {
        return false;
    }

    protected void enableIJ1PluginDirs(boolean enable) {
        this.enableIJ1PluginDirs = enable;
    }

    protected void addPluginClasspath(File file2) {
        this.pluginClasspath.add(file2);
    }

    public List<File> handleExtraPluginJars() {
        File dir;
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(this.pluginClasspath);
        if (!this.enableIJ1PluginDirs) {
            return result;
        }
        String extraPluginDirs = System.getProperty("ij1.plugin.dirs");
        if (extraPluginDirs != null) {
            for (String dir2 : extraPluginDirs.split(File.pathSeparator)) {
                File directory = new File(dir2);
                if (!directory.isDirectory()) continue;
                result.add(directory);
                this.handleExtraPluginJars(directory, result);
            }
            return result;
        }
        String userHome = System.getProperty("user.home");
        if (userHome != null && (dir = new File(userHome, ".plugins")).isDirectory()) {
            result.add(dir);
            this.handleExtraPluginJars(dir, result);
        }
        return result;
    }

    private void handleExtraPluginJars(File directory, List<File> result) {
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        for (File file2 : list) {
            if (file2.isDirectory()) {
                this.handleExtraPluginJars(file2, result);
                continue;
            }
            if (!file2.isFile() || !file2.getName().endsWith(".jar")) continue;
            result.add(file2);
        }
    }

    public void runAfterRefreshMenus() {
    }

    public boolean handleNoSuchMethodError(NoSuchMethodError error) {
        String message = error.getMessage();
        int paren = message.indexOf("(");
        if (paren < 0) {
            return false;
        }
        int dot = message.lastIndexOf(".", paren);
        if (dot < 0) {
            return false;
        }
        String path = message.substring(0, dot).replace('.', '/') + ".class";
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> e = loader.getResources(path);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement().toString());
            }
            e = loader.getResources("/" + path);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement().toString());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        if (urls.size() == 0) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("There was a problem with the class ");
        buffer.append(message.substring(0, dot));
        buffer.append(" which can be found here:\n");
        for (String url : urls) {
            int bang;
            if (url.startsWith("jar:")) {
                url = url.substring(4);
            }
            if (url.startsWith("file:")) {
                url = url.substring(5);
            }
            if ((bang = url.indexOf("!")) < 0) {
                buffer.append(url);
            } else {
                buffer.append(url.substring(0, bang));
            }
            buffer.append("\n");
        }
        if (urls.size() > 1) {
            buffer.append("\nWARNING: multiple locations found!\n");
        }
        StringWriter writer = new StringWriter();
        error.printStackTrace(new PrintWriter(writer));
        buffer.append(writer.toString());
        System.out.println(buffer.toString());
        NoSuchMethodException throwable = new NoSuchMethodException("Could not find method " + message + "\n" + buffer);
        throwable.setStackTrace(error.getStackTrace());
        this.error(throwable);
        return true;
    }

    public void newPluginClassLoader(ClassLoader loader) {
    }

    public String[] addPluginDirectory(File directory, String[] names) {
        if (names != null) {
            Pattern pattern = Pattern.compile("(batik|jython|jython-standalone|jruby)(-[0-9].*)?\\.jar");
            Arrays.sort(names, new FatJarNameComparator(pattern));
        }
        return names;
    }

    public void initialized() {
    }

    public InputStream autoGenerateConfigFile(File directory) {
        if (new File(directory, "IJ_Props.txt").exists()) {
            return null;
        }
        return new ByteArrayInputStream(this.autoGenerateConfigFile(directory, directory, "Plugins", "", new StringBuilder()).toString().getBytes());
    }

    protected StringBuilder autoGenerateConfigFile(File topLevelDirectory, File directory, String menuPath, String packageName, StringBuilder builder) {
        Object[] list = directory.listFiles();
        if (list == null) {
            return builder;
        }
        Arrays.sort(list);
        for (Object file2 : list) {
            String name = ((File)file2).getName();
            if (name.startsWith("_")) continue;
            if (((File)file2).isDirectory()) {
                this.autoGenerateConfigFile(topLevelDirectory, (File)file2, menuPath + ">" + name.replace('_', ' '), packageName + name + ".", builder);
                continue;
            }
            if (!name.endsWith(".class") || !name.contains("_") || name.contains("$") || topLevelDirectory == directory && Character.isLowerCase(name.charAt(0))) continue;
            String className = packageName + name.substring(0, name.length() - 6);
            name = name.substring(0, name.length() - 6).replace('_', ' ');
            builder.append(menuPath + ", \"" + name + "\", " + className + "\n");
        }
        return builder;
    }

    public void addMenuItem(String menuPath, String command) {
        if (menuPath == null) {
            this.menuStructure.clear();
        } else if (menuPath.endsWith(">-")) {
            int i = 1;
            while (this.menuStructure.containsKey(menuPath + i)) {
                ++i;
            }
            this.menuStructure.put(menuPath + i, command);
        } else {
            this.menuStructure.put(menuPath, command);
        }
    }

    public Map<String, String> getMenuStructure() {
        return Collections.unmodifiableMap(this.menuStructure);
    }

    @Deprecated
    public Object interceptOpen(String path, int planeIndex, boolean display) {
        return null;
    }

    public Object interceptFileOpen(String path) {
        return null;
    }

    public Object interceptOpenImage(String path, int planeIndex) {
        return null;
    }

    public Object interceptOpenRecent(String path) {
        return null;
    }

    public Object interceptDragAndDropFile(File f) {
        return null;
    }

    public static Collection<File> getClasspathElements(ClassLoader fromClassLoader, StringBuilder errors, ClassLoader ... excludeClassLoaders) {
        HashSet<ClassLoader> exclude = new HashSet<ClassLoader>(Arrays.asList(excludeClassLoaders));
        ArrayList<File> result = new ArrayList<File>();
        for (ClassLoader loader = fromClassLoader; loader != null && !exclude.contains(loader); loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) {
                errors.append("Cannot add class path from ClassLoader of type ").append(fromClassLoader.getClass().getName()).append("\n");
                continue;
            }
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                if (!"file".equals(url.getProtocol())) {
                    errors.append("Not a file URL! ").append(url).append("\n");
                    continue;
                }
                result.add(new File(url.getPath()));
                String path = url.getPath();
                if (!path.matches(".*/target/surefire/surefirebooter[0-9]*\\.jar")) continue;
                try {
                    String classPath;
                    JarFile jar = new JarFile(path);
                    Manifest manifest = jar.getManifest();
                    if (manifest == null || (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String element : classPath.split(" +")) {
                        try {
                            URL url2 = new URL(element);
                            if (!"file".equals(url2.getProtocol())) {
                                errors.append("Not a file URL! ").append(url2).append("\n");
                                continue;
                            }
                            result.add(new File(url2.getPath()));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Warning: could not add plugin class path due to ");
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public boolean interceptKeyPressed(KeyEvent e) {
        return false;
    }

    public Iterable<Thread> getThreadAncestors() {
        return null;
    }

    public boolean interceptCloseAllWindows() {
        return true;
    }

    public void interceptImageWindowClose(Object window) {
    }

    public boolean disposing() {
        return true;
    }

    public static final class FatJarNameComparator
    implements Comparator<String> {
        private final Pattern pattern;

        private FatJarNameComparator(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public int compare(String a, String b) {
            return (this.pattern.matcher(a).matches() ? 1 : 0) - (this.pattern.matcher(b).matches() ? 1 : 0);
        }
    }
}

