/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import net.imagej.AbstractData;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.display.OverlayService;
import net.imagej.event.OverlayCreatedEvent;
import net.imagej.event.OverlayDeletedEvent;
import net.imagej.event.OverlayRestructuredEvent;
import net.imagej.event.OverlayUpdatedEvent;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.OverlaySettings;
import net.imglib2.RealInterval;
import net.imglib2.RealPositionable;
import net.imglib2.roi.RegionOfInterest;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.util.ColorRGB;

public abstract class AbstractOverlay
extends AbstractData
implements Overlay {
    private static final long serialVersionUID = 1L;
    @Parameter(required=false)
    private OverlayService overlayService;
    private int alpha;
    private ColorRGB fillColor;
    private ColorRGB lineColor;
    private double lineWidth;
    private Overlay.LineStyle lineStyle;
    private Overlay.ArrowStyle startArrowStyle;
    private Overlay.ArrowStyle endArrowStyle;

    public AbstractOverlay(RealInterval interval) {
        super(interval);
    }

    public AbstractOverlay(Context context, RealInterval interval) {
        super(context, interval);
        if (this.overlayService == null) {
            this.applySettings(new OverlaySettings());
        } else {
            this.applySettings(this.overlayService.getDefaultSettings());
        }
        this.setAxis(new DefaultLinearAxis(Axes.X, null, 1.0), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y, null, 1.0), 1);
    }

    @Override
    protected void register() {
        this.publish(new OverlayCreatedEvent(this));
    }

    @Override
    public void delete() {
        this.publish(new OverlayDeletedEvent(this));
    }

    @Override
    public RegionOfInterest getRegionOfInterest() {
        return null;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public ColorRGB getFillColor() {
        return this.fillColor;
    }

    @Override
    public void setFillColor(ColorRGB fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public ColorRGB getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(ColorRGB lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public Overlay.LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(Overlay.LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Override
    public Overlay.ArrowStyle getLineStartArrowStyle() {
        return this.startArrowStyle;
    }

    @Override
    public void setLineStartArrowStyle(Overlay.ArrowStyle style) {
        this.startArrowStyle = style;
    }

    @Override
    public Overlay.ArrowStyle getLineEndArrowStyle() {
        return this.endArrowStyle;
    }

    @Override
    public void setLineEndArrowStyle(Overlay.ArrowStyle style) {
        this.endArrowStyle = style;
    }

    @Override
    public Overlay duplicate() {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream objOutStream = new ObjectOutputStream(bytesOut);
            objOutStream.writeObject(this);
            objOutStream.flush();
            objOutStream.close();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
            ObjectInputStream objInStream = new ObjectInputStream(bytesIn);
            Overlay overlay = (Overlay)objInStream.readObject();
            objInStream.close();
            overlay.setContext(this.getContext());
            return overlay;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void update() {
        this.publish(new OverlayUpdatedEvent(this));
    }

    @Override
    public void rebuild() {
        this.publish(new OverlayRestructuredEvent(this));
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public double realMin(int d) {
        return this.getRegionOfInterest().realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        for (int i = 0; i < min.length; ++i) {
            min[i] = this.realMin(i);
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int i = 0; i < min.numDimensions(); ++i) {
            min.setPosition(this.realMin(i), i);
        }
    }

    @Override
    public double realMax(int d) {
        return this.getRegionOfInterest().realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        for (int i = 0; i < max.length; ++i) {
            max[i] = this.realMax(i);
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int i = 0; i < max.numDimensions(); ++i) {
            max.setPosition(this.realMax(i), i);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.alpha);
        out.writeObject(this.fillColor);
        out.writeObject(this.lineColor);
        out.writeDouble(this.lineWidth);
        out.writeObject(this.lineStyle.toString());
        out.writeObject(this.startArrowStyle.toString());
        out.writeObject(this.endArrowStyle.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.alpha = in.readInt();
        this.fillColor = (ColorRGB)in.readObject();
        this.lineColor = (ColorRGB)in.readObject();
        this.lineWidth = in.readDouble();
        this.lineStyle = Overlay.LineStyle.valueOf((String)in.readObject());
        this.startArrowStyle = Overlay.ArrowStyle.valueOf((String)in.readObject());
        this.endArrowStyle = Overlay.ArrowStyle.valueOf((String)in.readObject());
    }

    private void applySettings(OverlaySettings settings) {
        this.startArrowStyle = settings.getStartArrowStyle();
        this.endArrowStyle = settings.getEndArrowStyle();
        this.fillColor = settings.getFillColor();
        this.alpha = settings.getAlpha();
        this.lineColor = settings.getLineColor();
        this.lineWidth = settings.getLineWidth();
        this.lineStyle = settings.getLineStyle();
    }
}

