/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.options;

import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.OverlaySettings;
import org.scijava.options.OptionsPlugin;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;

@Plugin(type=OptionsPlugin.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Overlay", mnemonic=111), @Menu(label="Overlay Options...")}, label="Default Overlay Settings", attrs={@Attr(name="no-legacy")})
public class OptionsOverlay
extends OptionsPlugin {
    public static final String solidLineStyle = "Solid";
    public static final String dashLineStyle = "Dash";
    public static final String dotLineStyle = "Dot";
    public static final String dotDashLineStyle = "Dot-dash";
    public static final String noLineStyle = "None";
    public static final String arrowLineDecoration = "Arrow";
    public static final String noLineDecoration = "None";
    @Parameter(required=false)
    private OverlayService overlayService;
    @Parameter(label="Line color")
    private ColorRGB lineColor = Colors.YELLOW;
    @Parameter(label="Line width", min="0.1")
    private double lineWidth = 1.0;
    @Parameter(label="Line style", choices={"Solid", "Dash", "Dot", "Dot-dash", "None"})
    private String lineStyle = "Solid";
    @Parameter(label="Fill color")
    private ColorRGB fillColor = Colors.YELLOW;
    @Parameter(label="Fill opacity", description="The opacity or alpha of the interior of the overlay (0=transparent, 255=opaque)", style="scroll bar", min="0", max="255", persistKey="alpha.1")
    private int alpha = 63;
    @Parameter(label="Line start arrow style", description="The arrow style at the starting point of a line or other path", choices={"None", "Arrow"})
    private String startLineArrowStyle = "None";
    @Parameter(label="Line end arrow style", description="The arrow style at the end point of a line or other path", choices={"None", "Arrow"})
    private String endLineArrowStyle = "None";

    @Override
    public void run() {
        if (this.overlayService != null) {
            this.updateSettings(this.overlayService.getDefaultSettings());
        }
        super.run();
    }

    public void updateSettings(OverlaySettings settings) {
        settings.setLineColor(this.getLineColor());
        settings.setLineWidth(this.getLineWidth());
        settings.setLineStyle(this.getLineStyle());
        settings.setFillColor(this.getFillColor());
        settings.setAlpha(this.getAlpha());
        settings.setStartArrowStyle(this.getStartArrowStyle());
        settings.setEndArrowStyle(this.getEndArrowStyle());
    }

    public void setLineColor(ColorRGB color) {
        this.lineColor = color;
    }

    public ColorRGB getLineColor() {
        return this.lineColor;
    }

    public void setLineWidth(double width) {
        this.lineWidth = width < 0.1 ? 0.1 : width;
    }

    public double getLineWidth() {
        if (this.lineWidth < 0.1) {
            return 0.1;
        }
        return this.lineWidth;
    }

    public void setLineStyle(Overlay.LineStyle style) {
        switch (style) {
            case DASH: {
                this.lineStyle = dashLineStyle;
                break;
            }
            case DOT: {
                this.lineStyle = dotLineStyle;
                break;
            }
            case DOT_DASH: {
                this.lineStyle = dotDashLineStyle;
                break;
            }
            case SOLID: {
                this.lineStyle = solidLineStyle;
                break;
            }
            default: {
                this.lineStyle = "None";
            }
        }
    }

    public Overlay.LineStyle getLineStyle() {
        if (this.lineStyle.equals(dashLineStyle)) {
            return Overlay.LineStyle.DASH;
        }
        if (this.lineStyle.equals(dotLineStyle)) {
            return Overlay.LineStyle.DOT;
        }
        if (this.lineStyle.equals(dotDashLineStyle)) {
            return Overlay.LineStyle.DOT_DASH;
        }
        if (this.lineStyle.equals(solidLineStyle)) {
            return Overlay.LineStyle.SOLID;
        }
        return Overlay.LineStyle.NONE;
    }

    public void setFillColor(ColorRGB color) {
        this.fillColor = color;
    }

    public ColorRGB getFillColor() {
        return this.fillColor;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setStartArrowStyle(Overlay.ArrowStyle style) {
        this.startLineArrowStyle = style == Overlay.ArrowStyle.ARROW ? arrowLineDecoration : "None";
    }

    public Overlay.ArrowStyle getStartArrowStyle() {
        if (this.startLineArrowStyle.equals(arrowLineDecoration)) {
            return Overlay.ArrowStyle.ARROW;
        }
        return Overlay.ArrowStyle.NONE;
    }

    public void setEndArrowStyle(Overlay.ArrowStyle style) {
        this.endLineArrowStyle = style == Overlay.ArrowStyle.ARROW ? arrowLineDecoration : "None";
    }

    public Overlay.ArrowStyle getEndArrowStyle() {
        if (this.endLineArrowStyle.equals(arrowLineDecoration)) {
            return Overlay.ArrowStyle.ARROW;
        }
        return Overlay.ArrowStyle.NONE;
    }
}

