/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.options;

import net.imagej.config.ConfigFileParameters;
import org.scijava.options.OptionsPlugin;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=OptionsPlugin.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Options", mnemonic=111), @Menu(label="Memory & Threads...", weight=12.0)}, attrs={@Attr(name="no-legacy")})
public class OptionsMemoryAndThreads
extends OptionsPlugin {
    @Parameter(label="Maximum memory (MB)", persist=false)
    private int maxMemory = 0;
    @Parameter(label="Parallel threads for stacks")
    private int stackThreads = 2;
    @Parameter(label="Keep multiple undo buffers")
    private boolean multipleBuffers = false;
    @Parameter(label="Run garbage collector on status bar click")
    private boolean runGcOnClick = true;
    private ConfigFileParameters params;

    @Override
    public void load() {
        super.load();
        this.loadMaxMemory();
    }

    @Override
    public void save() {
        super.save();
        this.saveMaxMemory();
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public int getStackThreads() {
        return this.stackThreads;
    }

    public boolean isMultipleBuffers() {
        return this.multipleBuffers;
    }

    public boolean isRunGcOnClick() {
        return this.runGcOnClick;
    }

    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
        this.saveMaxMemory();
    }

    public void setStackThreads(int stackThreads) {
        this.stackThreads = stackThreads;
    }

    public void setMultipleBuffers(boolean multipleBuffers) {
        this.multipleBuffers = multipleBuffers;
    }

    public void setRunGcOnClick(boolean runGcOnClick) {
        this.runGcOnClick = runGcOnClick;
    }

    private void loadMaxMemory() {
        this.maxMemory = this.params().getMemoryInMB();
    }

    private void saveMaxMemory() {
        if (this.maxMemory == this.params().getMemoryInMB()) {
            return;
        }
        this.params().setMemoryInMB(this.maxMemory);
    }

    private ConfigFileParameters params() {
        if (this.params == null) {
            this.params = new ConfigFileParameters(this.getContext());
        }
        return this.params;
    }
}

