/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.minmax;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.minmax.AbstractMinMaxMethod;
import net.imagej.minmax.MinMaxMethod;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.app.StatusService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=MinMaxMethod.class)
public class DefaultMinMaxMethod<T extends Type<T> & Comparable<T>>
extends AbstractMinMaxMethod<T> {
    private final int MAX_UPDATES = 100;
    @Parameter
    private ThreadService threadService;
    @Parameter(required=false)
    private StatusService statusService;
    private long[] progress = null;
    private int reported = -1;
    private long imageSize;
    private IterableInterval<T> image;
    private T min;
    private T max;
    private String errorMessage = "";
    private int numThreads;
    private long processingTime;
    private Object lock = new Object();

    @Override
    public void initialize(Img<T> img, T min, T max) {
        this.initialize(img, min, max);
    }

    @Override
    public void initialize(IterableInterval<T> interval, T min, T max) {
        this.image = interval;
        this.min = min;
        this.max = max;
        this.init();
    }

    @Override
    public void initialize(RandomAccessibleInterval<T> interval, T min, T max) {
        this.initialize(interval, min, max);
    }

    @Override
    public void initialize(Img<T> img) {
        this.initialize((IterableInterval<T>)img);
    }

    @Override
    public void initialize(IterableInterval<T> interval) {
        this.image = interval;
        this.min = ((Type)this.image.firstElement()).createVariable();
        this.max = this.min.copy();
        this.init();
    }

    @Override
    public void initialize(RandomAccessibleInterval<T> interval) {
        this.initialize(Views.iterable(interval));
    }

    @Override
    public T getMin() {
        return this.min;
    }

    @Override
    public T getMax() {
        return this.max;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        this.imageSize = this.image.size();
        this.progress = new long[this.numThreads];
        this.progress[0] = -1L;
        this.report(0);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(this.imageSize, this.numThreads);
        final Vector minValues = new Vector();
        final Vector maxValues = new Vector();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            minValues.add(((Type)this.image.firstElement()).createVariable());
            maxValues.add(((Type)this.image.firstElement()).createVariable());
            threads[ithread] = this.threadService.newThread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    DefaultMinMaxMethod.this.compute(myNumber, myChunk.getStartPosition(), myChunk.getLoopSize(), (Type)minValues.get(myNumber), (Type)maxValues.get(myNumber));
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.min.set((Type)((Type)minValues.get(0)));
        this.max.set((Type)((Type)maxValues.get(0)));
        for (int i = 0; i < threads.length; ++i) {
            Type value = (Type)minValues.get(i);
            if (Util.min(this.min, value) == value) {
                this.min.set((Type)value);
            }
            if (Util.max(this.max, value = (Type)maxValues.get(i)) != value) continue;
            this.max.set((Type)value);
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        if (this.statusService != null) {
            this.statusService.showStatus("Computing min/max complete.");
        }
        return true;
    }

    protected void compute(int threadNumber, long startPos, long loopSize, T min, T max) {
        Cursor<T> cursor = this.image.cursor();
        cursor.fwd();
        min.set((Type)((Type)cursor.get()));
        max.set((Type)((Type)cursor.get()));
        cursor.reset();
        cursor.jumpFwd(startPos);
        for (long j = 0L; j < loopSize; ++j) {
            cursor.fwd();
            Type value = (Type)cursor.get();
            if (Util.min(min, value) == value) {
                min.set((Type)value);
            }
            if (Util.max(max, value) == value) {
                max.set((Type)value);
            }
            this.report(threadNumber);
        }
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ScaleSpace: [Image<A> img] is null.";
            return false;
        }
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void init() {
        this.setNumThreads();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(int threadNumber) {
        if (this.statusService == null) {
            return;
        }
        int n = threadNumber;
        this.progress[n] = this.progress[n] + 1L;
        long netProgress = 0L;
        for (int i = 0; i < this.progress.length; ++i) {
            netProgress += this.progress[i];
        }
        int percentWork = (int)((double)netProgress / (double)this.imageSize * 100.0);
        if (percentWork > this.reported) {
            Object object = this.lock;
            synchronized (object) {
                if (percentWork > this.reported) {
                    ++this.reported;
                    this.statusService.showStatus(percentWork, 100, "Computing min/max...");
                }
            }
        }
    }

    @Deprecated
    private static class Chunk {
        protected long startPosition;
        protected long loopSize;

        public Chunk(long startPosition, long loopSize) {
            this.startPosition = startPosition;
            this.loopSize = loopSize;
        }

        public long getStartPosition() {
            return this.startPosition;
        }

        public long getLoopSize() {
            return this.loopSize;
        }
    }

    private static class SimpleMultiThreading {
        private SimpleMultiThreading() {
        }

        public static Vector<Chunk> divideIntoChunks(long imageSize, int numThreads) {
            long threadChunkSize = imageSize / (long)numThreads;
            long threadChunkMod = imageSize % (long)numThreads;
            Vector<Chunk> chunks = new Vector<Chunk>();
            for (int threadID = 0; threadID < numThreads; ++threadID) {
                long startPosition = (long)threadID * threadChunkSize;
                long loopSize = threadID == numThreads - 1 ? threadChunkSize + threadChunkMod : threadChunkSize;
                chunks.add(new Chunk(startPosition, loopSize));
            }
            return chunks;
        }

        public static Thread[] newThreads(int numThreads) {
            return new Thread[numThreads];
        }

        public static void startAndJoin(Thread[] threads) {
            int ithread;
            if (1 == threads.length) {
                threads[0].run();
                return;
            }
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].setPriority(5);
                threads[ithread].start();
            }
            try {
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread].join();
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
    }
}

