/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display.process;

import java.util.Collection;
import org.scijava.convert.ConvertService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.plugin.Parameter;

public abstract class SingleInputPreprocessor<T>
extends AbstractPreprocessorPlugin {
    private final Class<T> inputType;
    @Parameter(required=false)
    private ModuleService moduleService;
    @Parameter(required=false)
    private ConvertService convertService;

    public SingleInputPreprocessor(Class<T> inputType) {
        this.inputType = inputType;
    }

    public abstract T getValue();

    @Override
    public void process(Module module) {
        ModuleItem<T> singleInput = this.getSingleInput(module, this.inputType);
        if (singleInput == null) {
            return;
        }
        T value = this.getValue();
        if (value == null) {
            return;
        }
        String itemName = singleInput.getName();
        value = this.convertService.convert(value, singleInput.getType());
        module.setInput(itemName, value);
        module.setResolved(itemName, true);
    }

    private ModuleItem<?> getSingleInput(Module module, Class<?> type) {
        if (this.moduleService == null || this.convertService == null) {
            return null;
        }
        ModuleItem<?> item = this.moduleService.getSingleInput(module, type);
        if (item == null || !item.isAutoFill()) {
            Collection<Class<?>> compatibleClasses = this.convertService.getCompatibleOutputClasses(type);
            item = this.moduleService.getSingleInput(module, compatibleClasses);
        }
        if (item == null || !item.isAutoFill()) {
            return null;
        }
        return item;
    }
}

