/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.display.SelectWindow;
import net.imagej.display.WindowService;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.command.CommandInfo;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.display.event.DisplayCreatedEvent;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.menu.MenuService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultWindowService
extends AbstractService
implements WindowService {
    private static final int MAX_LEADER_SIZE = 10;
    private static final int MAX_TRAILER_SIZE = 26;
    @Parameter
    private MenuService menuService;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private EventService eventService;
    private List<String> openWindows;
    private Map<String, ModuleInfo> windowModules;
    private int order = 1000;

    @Override
    public MenuService getMenuService() {
        return this.menuService;
    }

    @Override
    public ModuleService getModuleService() {
        return this.moduleService;
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public void add(String displayName) {
        ModuleInfo info = this.windowModules.get(displayName);
        if (info != null) {
            this.updateInfo(displayName);
        } else {
            this.windowModules.put(displayName, this.createInfo(displayName));
            this.openWindows.add(displayName);
        }
    }

    @Override
    public boolean remove(String displayName) {
        ModuleInfo info = this.windowModules.remove(displayName);
        if (info != null) {
            this.moduleService.removeModule(info);
        }
        return this.openWindows.remove(displayName);
    }

    @Override
    public void clear() {
        this.openWindows.clear();
        this.moduleService.removeModules(this.windowModules.values());
        this.windowModules.clear();
    }

    @Override
    public List<String> getOpenWindows() {
        return Collections.unmodifiableList(this.openWindows);
    }

    @Override
    public void initialize() {
        this.openWindows = new ArrayList<String>();
        this.windowModules = new HashMap<String, ModuleInfo>();
    }

    @EventHandler
    protected void onEvent(DisplayCreatedEvent event) {
        Object display = event.getObject();
        this.add(display.getName());
    }

    @EventHandler
    protected void onEvent(DisplayActivatedEvent event) {
        Display<?> display = event.getDisplay();
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent event) {
        Object display = event.getObject();
        this.remove(display.getName());
    }

    private ModuleInfo createInfo(String displayName) {
        CommandInfo info = new CommandInfo(SelectWindow.class.getName());
        HashMap<String, Object> presets = new HashMap<String, Object>();
        presets.put("displayToSelect", displayName);
        info.setPresets(presets);
        MenuPath menuPath = new MenuPath();
        menuPath.add(new MenuEntry("Window"));
        MenuEntry leaf = new MenuEntry(this.shortPath(displayName));
        menuPath.add(leaf);
        info.setMenuPath(menuPath);
        leaf.setWeight(this.order++);
        this.moduleService.addModule(info);
        return info;
    }

    private void updateInfo(String path) {
        ModuleInfo info = this.windowModules.get(path);
        info.update(this.eventService);
    }

    private String shortPath(String path) {
        String newPath = path;
        if (path != null && path.length() > 39) {
            newPath = path.substring(0, 10);
            newPath = newPath + "...";
            int p = path.length() - 26 - 1;
            newPath = newPath + path.substring(p, p + 26);
        }
        return newPath;
    }
}

