/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.List;
import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import org.scijava.display.DisplayService;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.script.ScriptService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultImageDisplayService
extends AbstractService
implements ImageDisplayService {
    @Parameter
    private EventService eventService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private ScriptService scriptService;

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public PluginService getPluginService() {
        return this.pluginService;
    }

    @Override
    public DisplayService getDisplayService() {
        return this.displayService;
    }

    @Override
    public DataView createDataView(Data data) {
        for (DataView dataView : this.getDataViews()) {
            if (!dataView.isCompatible(data)) continue;
            dataView.initialize(data);
            return dataView;
        }
        throw new IllegalArgumentException("No data view found for data: " + data);
    }

    @Override
    public List<? extends DataView> getDataViews() {
        return this.pluginService.createInstancesOfType(DataView.class);
    }

    @Override
    public ImageDisplay getActiveImageDisplay() {
        return this.displayService.getActiveDisplay(ImageDisplay.class);
    }

    @Override
    public Dataset getActiveDataset() {
        return this.getActiveDataset(this.getActiveImageDisplay());
    }

    @Override
    public DatasetView getActiveDatasetView() {
        return this.getActiveDatasetView(this.getActiveImageDisplay());
    }

    @Override
    public Position getActivePosition() {
        return this.getActivePosition(this.getActiveImageDisplay());
    }

    @Override
    public Dataset getActiveDataset(ImageDisplay display) {
        DatasetView activeDatasetView = this.getActiveDatasetView(display);
        return activeDatasetView == null ? null : activeDatasetView.getData();
    }

    @Override
    public DatasetView getActiveDatasetView(ImageDisplay display) {
        if (display == null) {
            return null;
        }
        DataView activeView = display.getActiveView();
        if (activeView instanceof DatasetView) {
            return (DatasetView)activeView;
        }
        return null;
    }

    @Override
    public Position getActivePosition(ImageDisplay display) {
        if (display == null) {
            return null;
        }
        DatasetView activeDatasetView = this.getActiveDatasetView(display);
        if (activeDatasetView == null) {
            return null;
        }
        return activeDatasetView.getPlanePosition();
    }

    @Override
    public List<ImageDisplay> getImageDisplays() {
        return this.displayService.getDisplaysOfType(ImageDisplay.class);
    }

    @Override
    public void initialize() {
        this.scriptService.addAlias(ImageDisplay.class);
        this.scriptService.addAlias(DatasetView.class);
        this.scriptService.addAlias(DataView.class);
        this.scriptService.addAlias(OverlayView.class);
        this.scriptService.addAlias(Overlay.class);
    }
}

