/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.event.MouseCursorEvent;
import net.imagej.display.event.PanZoomEvent;
import net.imagej.display.event.ViewportResizeEvent;
import org.scijava.event.EventService;
import org.scijava.input.MouseCursor;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.util.IntCoords;
import org.scijava.util.IntRect;
import org.scijava.util.RealCoords;
import org.scijava.util.RealRect;

public class DefaultImageCanvas
implements ImageCanvas {
    private static final RealCoords DATA_ZERO = new RealCoords(0.0, 0.0);
    private static final int MIN_ALLOWED_VIEW_SIZE = 25;
    private static double maxZoom;
    private static double[] defaultZooms;
    private final ImageDisplay display;
    private final IntCoords viewportSize;
    private final double[] zoomLevels;
    @Parameter(required=false)
    private LogService log;
    @Parameter(required=false)
    private EventService eventService;
    private double initialScale = 1.0;
    private double scale = 1.0;
    private MouseCursor mouseCursor;
    private RealCoords panCenter;

    public DefaultImageCanvas(ImageDisplay display) {
        display.getContext().inject(this);
        this.display = display;
        this.mouseCursor = MouseCursor.DEFAULT;
        this.viewportSize = new IntCoords(100, 100);
        this.zoomLevels = DefaultImageCanvas.validatedZoomLevels(defaultZooms);
    }

    @Override
    public ImageDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getViewportWidth() {
        return this.viewportSize.x;
    }

    @Override
    public int getViewportHeight() {
        return this.viewportSize.y;
    }

    @Override
    public void setViewportSize(int width, int height) {
        this.viewportSize.x = width;
        this.viewportSize.y = height;
        if (this.eventService != null) {
            this.eventService.publish(new ViewportResizeEvent(this));
        }
    }

    @Override
    public boolean isInImage(IntCoords point) {
        RealCoords dataCoords = this.panelToDataCoords(point);
        return this.getDisplay().getPlaneExtents().contains(dataCoords);
    }

    @Override
    public RealCoords panelToDataCoords(IntCoords panelCoords) {
        double dataX = (double)panelCoords.x / this.getZoomFactor() + this.getLeftImageX();
        double dataY = (double)panelCoords.y / this.getZoomFactor() + this.getTopImageY();
        return new RealCoords(dataX, dataY);
    }

    @Override
    public IntCoords dataToPanelCoords(RealCoords dataCoords) {
        int panelX = (int)Math.round(this.getZoomFactor() * (dataCoords.x - this.getLeftImageX()));
        int panelY = (int)Math.round(this.getZoomFactor() * (dataCoords.y - this.getTopImageY()));
        return new IntCoords(panelX, panelY);
    }

    @Override
    public MouseCursor getCursor() {
        return this.mouseCursor;
    }

    @Override
    public void setCursor(MouseCursor cursor) {
        this.mouseCursor = cursor;
        if (this.eventService != null) {
            this.eventService.publish(new MouseCursorEvent(this));
        }
    }

    @Override
    public RealCoords getPanCenter() {
        if (this.panCenter == null) {
            this.panReset();
        }
        if (this.panCenter == null) {
            throw new IllegalStateException();
        }
        return new RealCoords(this.panCenter.x, this.panCenter.y);
    }

    @Override
    public IntCoords getPanOffset() {
        IntCoords offset = this.dataToPanelCoords(DATA_ZERO);
        offset.x = -offset.x;
        offset.y = -offset.y;
        return offset;
    }

    @Override
    public void setPanCenter(RealCoords center) {
        if (this.panCenter == null) {
            this.panCenter = new RealCoords(center.x, center.y);
        } else {
            this.panCenter.x = center.x;
            this.panCenter.y = center.y;
        }
        this.publishPanZoomEvent();
    }

    @Override
    public void setPanCenter(IntCoords center) {
        this.setPanCenter(this.panelToDataCoords(center));
    }

    @Override
    public void pan(RealCoords delta) {
        double centerX = this.getPanCenter().x + delta.x;
        double centerY = this.getPanCenter().y + delta.y;
        this.setPanCenter(new RealCoords(centerX, centerY));
    }

    @Override
    public void pan(IntCoords delta) {
        double centerX = this.getPanCenter().x + (double)delta.x / this.getZoomFactor();
        double centerY = this.getPanCenter().y + (double)delta.y / this.getZoomFactor();
        this.setPanCenter(new RealCoords(centerX, centerY));
    }

    @Override
    public void panReset() {
        RealRect extents = this.getDisplay().getPlaneExtents();
        double centerX = extents.x + extents.width / 2.0;
        double centerY = extents.y + extents.height / 2.0;
        this.setPanCenter(new RealCoords(centerX, centerY));
    }

    @Override
    public void setZoom(double factor) {
        this.setZoomAndCenter(factor, this.getPanCenter());
    }

    @Override
    public void setZoomAtPoint(double factor, RealCoords pos) {
        double newScale = factor == 0.0 ? this.initialScale : factor;
        RealCoords center = this.getPanCenter();
        center.x = pos.x - (pos.x - center.x) * this.scale / newScale;
        center.y = pos.y - (pos.y - center.y) * this.scale / newScale;
        this.setZoomAndCenter(newScale, center);
    }

    @Override
    public void setZoomAtPoint(double factor, IntCoords pos) {
        this.setZoomAtPoint(factor, this.panelToDataCoords(pos));
    }

    @Override
    public void setZoomAndCenter(double factor) {
        double x = (double)this.getViewportWidth() / this.getZoomFactor() / 2.0;
        double y = (double)this.getViewportHeight() / this.getZoomFactor() / 2.0;
        this.setZoomAndCenter(factor, new RealCoords(x, y));
    }

    @Override
    public void setZoomAndCenter(double factor, RealCoords center) {
        double newScale;
        double d = newScale = factor == 0.0 ? this.initialScale : factor;
        if (this.scaleOutOfBounds(newScale)) {
            return;
        }
        this.scale = newScale;
        this.setPanCenter(center);
    }

    @Override
    public void zoomIn() {
        double newScale = DefaultImageCanvas.nextLargerZoom(this.zoomLevels, this.getZoomFactor());
        this.setZoom(newScale);
    }

    @Override
    public void zoomIn(RealCoords pos) {
        double desiredScale = DefaultImageCanvas.nextLargerZoom(this.zoomLevels, this.getZoomFactor());
        this.setZoomAtPoint(desiredScale, pos);
    }

    @Override
    public void zoomIn(IntCoords pos) {
        double desiredScale = DefaultImageCanvas.nextLargerZoom(this.zoomLevels, this.getZoomFactor());
        this.setZoomAtPoint(desiredScale, pos);
    }

    @Override
    public void zoomOut() {
        double desiredScale = DefaultImageCanvas.nextSmallerZoom(this.zoomLevels, this.getZoomFactor());
        this.setZoom(desiredScale);
    }

    @Override
    public void zoomOut(RealCoords pos) {
        double newScale = DefaultImageCanvas.nextSmallerZoom(this.zoomLevels, this.getZoomFactor());
        this.setZoomAtPoint(newScale, pos);
    }

    @Override
    public void zoomOut(IntCoords pos) {
        double newScale = DefaultImageCanvas.nextSmallerZoom(this.zoomLevels, this.getZoomFactor());
        this.setZoomAtPoint(newScale, pos);
    }

    @Override
    public void zoomToFit(IntRect viewportBox) {
        IntCoords topLeft = viewportBox.getTopLeft();
        IntCoords bottomRight = viewportBox.getBottomRight();
        RealCoords dataTopLeft = this.panelToDataCoords(topLeft);
        RealCoords dataBottomRight = this.panelToDataCoords(bottomRight);
        double newCenterX = Math.abs(dataBottomRight.x + dataTopLeft.x) / 2.0;
        double newCenterY = Math.abs(dataBottomRight.y + dataTopLeft.y) / 2.0;
        double dataSizeX = Math.abs(dataBottomRight.x - dataTopLeft.x);
        double dataSizeY = Math.abs(dataBottomRight.y - dataTopLeft.y);
        double xZoom = (double)this.getViewportWidth() / dataSizeX;
        double yZoom = (double)this.getViewportHeight() / dataSizeY;
        double factor = Math.min(xZoom, yZoom);
        this.setZoomAndCenter(factor, new RealCoords(newCenterX, newCenterY));
    }

    @Override
    public void zoomToFit(RealRect viewportBox) {
        double newCenterX = viewportBox.x + viewportBox.width / 2.0;
        double newCenterY = viewportBox.y + viewportBox.height / 2.0;
        double minScale = Math.min((double)this.getViewportWidth() / viewportBox.width, (double)this.getViewportHeight() / viewportBox.height);
        this.setZoomAndCenter(minScale, new RealCoords(newCenterX, newCenterY));
    }

    @Override
    public double getZoomFactor() {
        return this.scale;
    }

    @Override
    public double getInitialScale() {
        return this.initialScale;
    }

    @Override
    public void setInitialScale(double zoomFactor) {
        if (zoomFactor <= 0.0) {
            throw new IllegalArgumentException("Initial scale must be > 0");
        }
        this.initialScale = zoomFactor;
    }

    @Override
    public double getBestZoomLevel(double fractionalScale) {
        double[] levels = defaultZooms;
        int zoomIndex = DefaultImageCanvas.lookupZoomIndex(levels, fractionalScale);
        if (zoomIndex != -1) {
            return levels[zoomIndex];
        }
        return DefaultImageCanvas.nextSmallerZoom(levels, fractionalScale);
    }

    private void publishPanZoomEvent() {
        if (this.eventService != null) {
            this.eventService.publish(new PanZoomEvent(this));
        }
    }

    private double getLeftImageX() {
        double viewportImageWidth = (double)this.getViewportWidth() / this.getZoomFactor();
        return this.getPanCenter().x - viewportImageWidth / 2.0;
    }

    private double getTopImageY() {
        double viewportImageHeight = (double)this.getViewportHeight() / this.getZoomFactor();
        return this.getPanCenter().y - viewportImageHeight / 2.0;
    }

    private boolean scaleOutOfBounds(double desiredScale) {
        if (desiredScale <= 0.0) {
            if (this.log != null) {
                this.log.warn("**** BAD SCALE: " + desiredScale + " ****");
            }
            return true;
        }
        if (desiredScale > maxZoom) {
            return true;
        }
        if (desiredScale < this.getZoomFactor()) {
            RealRect planeExtents = this.getDisplay().getPlaneExtents();
            IntCoords nearCornerPanel = this.dataToPanelCoords(new RealCoords(planeExtents.x, planeExtents.y));
            IntCoords farCornerPanel = this.dataToPanelCoords(new RealCoords(planeExtents.x + planeExtents.width, planeExtents.y + planeExtents.height));
            int panelX = farCornerPanel.x - nearCornerPanel.x;
            int panelY = farCornerPanel.y - nearCornerPanel.y;
            if (panelX < 25 && panelY < 25) {
                return true;
            }
        }
        return false;
    }

    private static double nextSmallerZoom(double[] zoomLevels, double currScale) {
        int index = Arrays.binarySearch(zoomLevels, currScale);
        int nextIndex = index >= 0 ? index - 1 : -(index + 1) - 1;
        if (nextIndex < 0) {
            nextIndex = 0;
        }
        if (nextIndex > zoomLevels.length - 1) {
            nextIndex = zoomLevels.length - 1;
        }
        return zoomLevels[nextIndex];
    }

    private static double nextLargerZoom(double[] zoomLevels, double currScale) {
        int index = Arrays.binarySearch(zoomLevels, currScale);
        int nextIndex = index >= 0 ? index + 1 : -(index + 1);
        if (nextIndex < 0) {
            nextIndex = 0;
        }
        if (nextIndex > zoomLevels.length - 1) {
            nextIndex = zoomLevels.length - 1;
        }
        return zoomLevels[nextIndex];
    }

    private static double[] validatedZoomLevels(double[] levels) {
        double[] validatedLevels = (double[])levels.clone();
        Arrays.sort(validatedLevels);
        if (validatedLevels.length == 0) {
            throw new IllegalArgumentException("given zoom level array is empty");
        }
        double prevEntry = validatedLevels[0];
        if (prevEntry <= 0.0) {
            throw new IllegalArgumentException("zoom level array contains nonpositive entries");
        }
        for (int i = 1; i < validatedLevels.length; ++i) {
            double currEntry = validatedLevels[i];
            if (currEntry == prevEntry) {
                throw new IllegalArgumentException("zoom level array contains duplicate entries");
            }
            prevEntry = currEntry;
        }
        return validatedLevels;
    }

    private static int lookupZoomIndex(double[] levels, double requestedZoom) {
        int lo = 0;
        int hi = levels.length - 1;
        do {
            int mid;
            double possibleZoom;
            if (Math.abs(requestedZoom - (possibleZoom = levels[mid = (lo + hi) / 2])) < 1.0E-5) {
                return mid;
            }
            if (requestedZoom < possibleZoom) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        } while (hi >= lo);
        return -1;
    }

    static {
        ArrayList<Double> midLevelZooms = new ArrayList<Double>();
        midLevelZooms.add(0.03125);
        midLevelZooms.add(0.041666666666666664);
        midLevelZooms.add(0.0625);
        midLevelZooms.add(0.08333333333333333);
        midLevelZooms.add(0.125);
        midLevelZooms.add(0.16666666666666666);
        midLevelZooms.add(0.25);
        midLevelZooms.add(0.3333333333333333);
        midLevelZooms.add(0.5);
        midLevelZooms.add(0.75);
        midLevelZooms.add(1.0);
        midLevelZooms.add(1.5);
        midLevelZooms.add(2.0);
        midLevelZooms.add(3.0);
        midLevelZooms.add(4.0);
        midLevelZooms.add(6.0);
        midLevelZooms.add(8.0);
        midLevelZooms.add(12.0);
        midLevelZooms.add(16.0);
        midLevelZooms.add(24.0);
        midLevelZooms.add(32.0);
        int EXTRA_ZOOMS = 30;
        ArrayList<Double> loZooms = new ArrayList<Double>();
        double prevDenom = 1.0 / (Double)midLevelZooms.get(0);
        for (int i = 0; i < 30; ++i) {
            double newDenom = prevDenom + 16.0;
            loZooms.add(1.0 / newDenom);
            prevDenom = newDenom;
        }
        Collections.reverse(loZooms);
        ArrayList<Double> hiZooms = new ArrayList<Double>();
        double prevNumer = (Double)midLevelZooms.get(midLevelZooms.size() - 1);
        for (int i = 0; i < 30; ++i) {
            double newNumer = prevNumer + 16.0;
            hiZooms.add(newNumer / 1.0);
            prevNumer = newNumer;
        }
        ArrayList<Double> combinedZoomLevels = new ArrayList<Double>();
        combinedZoomLevels.addAll(loZooms);
        combinedZoomLevels.addAll(midLevelZooms);
        combinedZoomLevels.addAll(hiZooms);
        defaultZooms = new double[combinedZoomLevels.size()];
        for (int i = 0; i < defaultZooms.length; ++i) {
            DefaultImageCanvas.defaultZooms[i] = (Double)combinedZoomLevels.get(i);
        }
        maxZoom = (Double)hiZooms.get(hiZooms.size() - 1);
    }
}

