/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.imagej.ChannelCollection;
import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.Position;
import net.imagej.autoscale.AutoscaleService;
import net.imagej.autoscale.DataRange;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.display.AbstractDataView;
import net.imagej.display.ColorMode;
import net.imagej.display.ColorTables;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.SourceOptimizedCompositeXYProjector;
import net.imagej.display.event.DataViewUpdatedEvent;
import net.imagej.display.event.LUTsChangedEvent;
import net.imagej.event.DatasetRGBChangedEvent;
import net.imagej.event.DatasetTypeChangedEvent;
import net.imagej.event.DatasetUpdatedEvent;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.RealLUTConverter;
import net.imglib2.display.ColorTable;
import net.imglib2.display.projector.composite.CompositeXYProjector;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Binning;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;
import org.scijava.util.ColorRGB;

@Plugin(type=DataView.class)
public class DefaultDatasetView
extends AbstractDataView
implements DatasetView {
    @Parameter
    private AutoscaleService autoscaleService;
    @Parameter
    private ThreadService threadService;
    @Parameter(required=false)
    private EventService eventService;
    private int channelDimIndex;
    private ArrayList<ColorTable> defaultLUTs;
    private ARGBScreenImage screenImage;
    private CompositeXYProjector<? extends RealType<?>> projector;
    private final ArrayList<RealLUTConverter<? extends RealType<?>>> converters = new ArrayList();

    @Override
    public int getChannelCount() {
        if (this.channelDimIndex < 0) {
            return 1;
        }
        return (int)this.getData().dimension(this.channelDimIndex);
    }

    @Override
    public ARGBScreenImage getScreenImage() {
        return this.screenImage;
    }

    @Override
    public int getCompositeDimIndex() {
        return this.channelDimIndex;
    }

    @Override
    public CompositeXYProjector<? extends RealType<?>> getProjector() {
        return this.projector;
    }

    @Override
    public double getChannelMin(int c) {
        if (!this.isInitialized()) {
            return Double.NaN;
        }
        return this.converters.get(c).getMin();
    }

    @Override
    public double getChannelMax(int c) {
        if (!this.isInitialized()) {
            return Double.NaN;
        }
        return this.converters.get(c).getMax();
    }

    @Override
    public void setChannelRange(int c, double min, double max) {
        if (!this.isInitialized()) {
            return;
        }
        this.converters.get(c).setMin(min);
        this.converters.get(c).setMax(max);
    }

    @Override
    public void setChannelRanges(double min, double max) {
        for (int c = 0; c < this.converters.size(); ++c) {
            this.setChannelRange(c, min, max);
        }
    }

    @Override
    public void autoscale(int c) {
        Dataset data = this.getData();
        double min = data.getChannelMinimum(c);
        double max = data.getChannelMaximum(c);
        if (Double.isNaN(min) || Double.isNaN(max)) {
            RandomAccessibleInterval<? extends RealType<?>> interval = this.channelData(data, c);
            interval = this.xyPlane(interval);
            DataRange result = this.autoscaleService.getDefaultRandomAccessRange(interval);
            min = result.getMin();
            max = result.getMax();
            data.setChannelMinimum(c, min);
            data.setChannelMaximum(c, max);
        }
        this.setChannelRange(c, min, max);
    }

    @Override
    public void setComposite(boolean composite) {
        if (!this.isInitialized()) {
            return;
        }
        this.projector.setComposite(composite);
    }

    @Override
    public List<ColorTable> getColorTables() {
        return Collections.unmodifiableList(this.defaultLUTs);
    }

    @Override
    public void setColorTable(ColorTable colorTable, int channel) {
        this.defaultLUTs.set(channel, colorTable);
        this.updateLUTs();
    }

    @Override
    public void resetColorTables(boolean grayscale) {
        int channelCount = this.getChannelCount();
        this.defaultLUTs.clear();
        this.defaultLUTs.ensureCapacity(channelCount);
        if (grayscale) {
            for (int i = 0; i < channelCount; ++i) {
                this.defaultLUTs.add(ColorTables.GRAYS);
            }
        } else {
            ImgPlus<RealType<?>> imgPlus = this.getData().getImgPlus();
            for (int c = 0; c < channelCount; ++c) {
                ColorTable ct = null;
                if (imgPlus != null) {
                    int planeIndex = 1;
                    for (int i = 2; i < imgPlus.dimensionIndex(Axes.CHANNEL); ++i) {
                        planeIndex = (int)((long)planeIndex * imgPlus.dimension(i));
                    }
                    if ((planeIndex = planeIndex + c - 1) < imgPlus.getColorTableCount()) {
                        ct = imgPlus.getColorTable(planeIndex);
                    }
                }
                if (ct == null) {
                    ct = channelCount == 1 ? ColorTables.GRAYS : ColorTables.getDefaultColorTable(c);
                }
                this.defaultLUTs.add(ct);
            }
        }
        this.updateLUTs();
    }

    @Override
    public ColorMode getColorMode() {
        boolean composite = this.projector.isComposite();
        if (composite) {
            return ColorMode.COMPOSITE;
        }
        List<ColorTable> colorTables = this.getColorTables();
        for (ColorTable colorTable : colorTables) {
            if (colorTable == ColorTables.GRAYS) continue;
            return ColorMode.COLOR;
        }
        return ColorMode.GRAYSCALE;
    }

    @Override
    public void setColorMode(ColorMode colorMode) {
        if (!this.isInitialized()) {
            return;
        }
        this.resetColorTables(colorMode == ColorMode.GRAYSCALE);
        this.projector.setComposite(colorMode == ColorMode.COMPOSITE);
        this.projector.map();
    }

    @Override
    public synchronized ColorRGB getColor(ChannelCollection channels) {
        int b;
        int g;
        int r;
        if (!this.isInitialized()) {
            return null;
        }
        int channelCount = this.getChannelCount();
        ColorMode mode = this.getColorMode();
        if (mode == ColorMode.COMPOSITE) {
            double rSum = 0.0;
            double gSum = 0.0;
            double bSum = 0.0;
            for (int c = 0; c < channelCount; ++c) {
                double value = channels.getChannelValue(c);
                RealLUTConverter<RealType<?>> converter = this.converters.get(c);
                double min = converter.getMin();
                double max = converter.getMax();
                int grayValue = Binning.valueToBin((int)256, (double)min, (double)max, (double)value);
                ColorTable colorTable = converter.getLUT();
                rSum += (double)colorTable.getResampled(0, 256, grayValue);
                gSum += (double)colorTable.getResampled(1, 256, grayValue);
                bSum += (double)colorTable.getResampled(2, 256, grayValue);
            }
            r = rSum > 255.0 ? 255 : (int)Math.round(rSum);
            g = gSum > 255.0 ? 255 : (int)Math.round(gSum);
            b = bSum > 255.0 ? 255 : (int)Math.round(bSum);
        } else {
            long currChannel = this.getLongPosition(Axes.CHANNEL);
            double value = channels.getChannelValue(currChannel);
            RealLUTConverter<RealType<?>> converter = this.converters.get((int)currChannel);
            double min = converter.getMin();
            double max = converter.getMax();
            int grayValue = Binning.valueToBin((int)256, (double)min, (double)max, (double)value);
            if (mode == ColorMode.COLOR) {
                ColorTable colorTable = converter.getLUT();
                r = colorTable.getResampled(0, 256, grayValue);
                g = colorTable.getResampled(1, 256, grayValue);
                b = colorTable.getResampled(2, 256, grayValue);
            } else {
                r = grayValue;
                g = grayValue;
                b = grayValue;
            }
        }
        return new ColorRGB(r, g, b);
    }

    @Override
    public RandomAccessibleInterval<? extends RealType<?>> xyPlane() {
        return this.xyPlane(this.getData().getImgPlus());
    }

    @Override
    public RandomAccessibleInterval<? extends RealType<?>> xyPlane(RandomAccessibleInterval<? extends RealType<?>> inputInterval) {
        RandomAccessibleInterval<RealType<?>> interval = inputInterval;
        long[] min = new long[interval.numDimensions()];
        long[] max = new long[interval.numDimensions()];
        interval.dimensions(max);
        int i = 0;
        while (i < 2) {
            int n = i++;
            max[n] = max[n] - 1L;
        }
        for (i = 2; i < interval.numDimensions(); ++i) {
            min[i] = max[i] = this.getLongPosition(i);
        }
        interval = Views.interval(interval, min, max);
        return interval;
    }

    @Override
    public boolean isCompatible(Data data) {
        return data != null && Dataset.class.isAssignableFrom(data.getClass());
    }

    @Override
    public Dataset getData() {
        return (Dataset)super.getData();
    }

    @Override
    public int getPreferredWidth() {
        return this.getScreenImage().image().getWidth(null);
    }

    @Override
    public int getPreferredHeight() {
        return this.getScreenImage().image().getHeight(null);
    }

    @Override
    public void update() {
        this.publish(new DataViewUpdatedEvent(this));
    }

    @Override
    public synchronized void rebuild() {
        this.uninitializeView();
        this.channelDimIndex = this.getChannelDimIndex();
        ImgPlus<RealType<?>> img = this.getData().getImgPlus();
        if (this.defaultLUTs == null || this.defaultLUTs.size() != this.getChannelCount()) {
            this.defaultLUTs = new ArrayList();
            this.resetColorTables(false);
        }
        int width = (int)img.dimension(0);
        int height = (int)img.dimension(1);
        this.screenImage = new ARGBScreenImage(width, height);
        this.initializeView(this.isComposite());
        this.updateLUTs();
        this.projector.map();
    }

    @Override
    public long getLongPosition(AxisType axis) {
        if (!this.isInitialized()) {
            return 0L;
        }
        if (axis.isXY()) {
            return 0L;
        }
        int dim = this.getData().dimensionIndex(axis);
        if (dim < 0) {
            return 0L;
        }
        if (dim >= this.projector.numDimensions()) {
            return 0L;
        }
        return this.projector.getLongPosition(dim);
    }

    @Override
    public void setPosition(long position, AxisType axis) {
        if (!this.isInitialized()) {
            return;
        }
        if (axis.isXY()) {
            return;
        }
        int dim = this.getData().dimensionIndex(axis);
        if (dim < 0) {
            return;
        }
        long currentValue = this.projector.getLongPosition(dim);
        if (position == currentValue) {
            return;
        }
        this.projector.setPosition(position, dim);
        if (dim != this.channelDimIndex) {
            this.updateLUTs();
        }
        this.projector.map();
        super.setPosition(position, axis);
    }

    @EventHandler
    protected void onEvent(DatasetTypeChangedEvent event) {
        if (this.getData() == event.getObject()) {
            this.threadService.run(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Context context = DefaultDatasetView.this.getContext();
                    synchronized (context) {
                        DefaultDatasetView.this.rebuild();
                    }
                }
            });
        }
    }

    @EventHandler
    protected void onEvent(DatasetRGBChangedEvent event) {
        if (this.getData() == event.getObject()) {
            this.threadService.run(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Context context = DefaultDatasetView.this.getContext();
                    synchronized (context) {
                        DefaultDatasetView.this.rebuild();
                    }
                }
            });
        }
    }

    @EventHandler
    protected void onEvent(DatasetUpdatedEvent event) {
        if (event instanceof DatasetTypeChangedEvent) {
            return;
        }
        if (event instanceof DatasetRGBChangedEvent) {
            return;
        }
        if (this.getData() == event.getObject()) {
            if (event.isMetaDataOnly()) {
                return;
            }
            this.projector.map();
        }
    }

    private int getChannelDimIndex() {
        return this.getData().dimensionIndex(Axes.CHANNEL);
    }

    private boolean isComposite() {
        return this.getData().getCompositeChannelCount() > 1 || this.getData().isRGBMerged();
    }

    private boolean isInitialized() {
        return this.projector != null;
    }

    private void uninitializeView() {
        this.converters.clear();
        this.projector = null;
    }

    private void initializeView(boolean composite) {
        this.converters.clear();
        int channelCount = this.getChannelCount();
        for (int c = 0; c < channelCount; ++c) {
            this.autoscale(c);
            RealLUTConverter converter = new RealLUTConverter(this.getData().getImgPlus().getChannelMinimum(c), this.getData().getImgPlus().getChannelMaximum(c), null);
            this.converters.add(converter);
        }
        ImgPlus<RealType<?>> img = this.getData().getImgPlus();
        this.projector = AbstractCellImg.class.isAssignableFrom(img.getImg().getClass()) ? new SourceOptimizedCompositeXYProjector(this.getData().getImgPlus(), this.screenImage, this.converters, this.channelDimIndex) : new CompositeXYProjector(this.getData().getImgPlus(), this.screenImage, this.converters, this.channelDimIndex);
        this.projector.setComposite(composite);
    }

    private void updateLUTs() {
        if (!this.isInitialized()) {
            return;
        }
        int channelCount = this.getChannelCount();
        for (int c = 0; c < channelCount; ++c) {
            ColorTable lut = this.getCurrentLUT(c);
            this.converters.get(c).setLUT(lut);
        }
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (this.eventService == null) {
            return;
        }
        this.eventService.publishLater(new LUTsChangedEvent(this));
    }

    private ColorTable getCurrentLUT(int cPos) {
        Position pos = this.getPlanePosition();
        if (this.channelDimIndex >= 0) {
            pos.setPosition(cPos, this.channelDimIndex - 2);
        }
        int no = (int)pos.getIndex();
        ColorTable lut = this.getData().getColorTable(no);
        if (lut != null) {
            return lut;
        }
        return this.defaultLUTs.get(cPos);
    }

    private RandomAccessibleInterval<? extends RealType<?>> channelData(Dataset d, int c) {
        ImgPlus<RealType<?>> imgPlus = d.getImgPlus();
        int chIndex = imgPlus.dimensionIndex(Axes.CHANNEL);
        if (chIndex < 0) {
            return imgPlus;
        }
        long[] mn = new long[d.numDimensions()];
        long[] mx = Intervals.dimensionsAsLongArray((Dimensions)d);
        int i = 0;
        while (i < mx.length) {
            int n = i++;
            mx[n] = mx[n] - 1L;
        }
        mn[chIndex] = c;
        mx[chIndex] = c;
        return Views.interval(imgPlus, mn, mx);
    }
}

