/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.command;

import net.imagej.command.PlanarCommand;
import net.imagej.display.DatasetView;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;

public abstract class AbstractPlanarCommand
implements PlanarCommand {
    @Parameter
    private DatasetView view;
    @Parameter
    private boolean doWholeDataset;

    @Override
    public void run() {
        RandomAccessibleInterval<RealType<?>> img = this.getView().getData().getImgPlus();
        if (this.isPlanar()) {
            for (int i = 2; i < img.numDimensions(); ++i) {
                img = Views.hyperSlice(img, i, this.getView().getLongPosition(i));
            }
        }
        this.run(img);
    }

    @Override
    public DatasetView getView() {
        return this.view;
    }

    @Override
    public boolean isPlanar() {
        return !this.doWholeDataset;
    }

    @Override
    public void setView(DatasetView view) {
        this.view = view;
    }

    @Override
    public void setPlanar(boolean planar) {
        this.doWholeDataset = !planar;
    }
}

