/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.autoscale;

import java.util.List;
import net.imagej.autoscale.AbstractAutoscaleMethod;
import net.imagej.autoscale.AutoscaleMethod;
import net.imagej.autoscale.DataRange;
import net.imagej.minmax.MinMaxMethod;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;

@Plugin(type=AutoscaleMethod.class, name="Default")
public class DefaultAutoscaleMethod<T extends RealType<T>>
extends AbstractAutoscaleMethod<T> {
    @Parameter
    private PluginService pluginService;

    @Override
    public DataRange getRange(IterableInterval<T> interval) {
        List<MinMaxMethod> methods = this.pluginService.createInstancesOfType(MinMaxMethod.class);
        MinMaxMethod minmax = methods.get(0);
        minmax.initialize(interval);
        minmax.process();
        double min = ((RealType)minmax.getMin()).getRealDouble();
        double max = ((RealType)minmax.getMax()).getRealDouble();
        if (min == max) {
            RealType theType = (RealType)interval.firstElement();
            min = theType.getMinValue();
            max = theType.getMaxValue();
        }
        return new DataRange(min, max);
    }
}

