/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.app;

import net.imagej.display.WindowService;
import net.imagej.options.OptionsMisc;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, label="Quit", iconPath="/icons/commands/door_in.png", menu={@Menu(label="File", weight=0.0, mnemonic=102), @Menu(label="Quit", weight=1.7976931348623157E308, mnemonic=113, accelerator="^Q")}, attrs={@Attr(name="no-legacy"), @Attr(name="app-command")})
public class QuitProgram
extends ContextCommand {
    public static final String MESSAGE = "Quit ImageJ?";
    @Parameter
    private StatusService statusService;
    @Parameter
    private WindowService windowService;
    @Parameter
    private UIService uiService;
    @Parameter
    private OptionsService optionsService;

    @Override
    public void run() {
        if (this.windowService != null && this.windowService.getOpenWindows().size() > 0 && !this.promptForQuit()) {
            return;
        }
        if (this.statusService != null) {
            this.statusService.showStatus("Quitting...");
        }
        OptionsMisc opts = this.optionsService.getOptions(OptionsMisc.class);
        boolean exitWhenQuitting = opts.isExitWhenQuitting();
        this.getContext().dispose();
        if (exitWhenQuitting) {
            System.exit(0);
        }
    }

    private boolean promptForQuit() {
        DialogPrompt.Result result = this.uiService.showDialog(MESSAGE, "Quit", DialogPrompt.MessageType.QUESTION_MESSAGE, DialogPrompt.OptionType.YES_NO_OPTION);
        return result == DialogPrompt.Result.YES_OPTION;
    }
}

