/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.app;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.DrawingTool;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.render.RenderingService;
import net.imagej.render.TextRenderer;
import org.scijava.ItemIO;
import org.scijava.app.App;
import org.scijava.app.AppService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.io.IOService;
import org.scijava.log.LogService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;
import org.scijava.util.Manifest;
import org.scijava.util.MersenneTwisterFast;

@Plugin(type=Command.class, label="About ImageJ...", iconPath="/icons/commands/information.png", menu={@Menu(label="Help", weight=1.0E7, mnemonic=104), @Menu(label="About ImageJ...", weight=43.0)}, headless=true, attrs={@Attr(name="no-legacy"), @Attr(name="app-command")})
public class AboutImageJ
extends ContextCommand {
    @Parameter
    private LogService log;
    @Parameter
    private AppService appService;
    @Parameter
    private IOService ioSrv;
    @Parameter
    private DatasetService dataSrv;
    @Parameter
    private DisplayService dispSrv;
    @Parameter
    private RenderingService rendSrv;
    @Parameter(type=ItemIO.OUTPUT)
    private Display<?> display;
    private final List<String> attributionStrings = new LinkedList<String>();
    private ColorRGB textColor = Colors.YELLOW;
    private final ColorRGB outlineColor = Colors.BLACK;
    private int largestFontSize = 35;
    private ChannelCollection textChannels = null;
    private ChannelCollection outlineChannels = null;

    @Override
    public void run() {
        Dataset dataset = this.createDataset();
        this.drawTextOverImage(dataset);
        String title = this.getApp().getTitle();
        this.display = this.dispSrv.createDisplay("About " + title, dataset);
    }

    public Display<?> getDisplay() {
        return this.display;
    }

    private Dataset createDataset() {
        File imageFile = this.getRandomAboutImagePath();
        String source = imageFile != null ? imageFile.getAbsolutePath() : "About ImageJ&pixelType=uint16&axisTypes=X,Y&axisLengths=512,512.fake";
        String title = "About " + this.getApp().getTitle();
        Dataset ds = null;
        try {
            Object obj = this.ioSrv.open(source);
            if (obj instanceof Dataset) {
                ds = (Dataset)obj;
            } else {
                this.log.error(obj.getClass().getName() + " is not a Dataset: " + source);
            }
        }
        catch (IOException e) {
            this.log.error(e);
        }
        if (ds != null) {
            boolean validImage = true;
            if (validImage &= ds.numDimensions() == 3) {
                this.loadAttributes(imageFile);
            } else {
                ds = null;
            }
        }
        if (ds == null) {
            this.log.warn("Could not load a 3 channel unsigned 8 bit image as backdrop");
            ds = this.dataSrv.create(new long[]{500L, 500L, 3L}, title, new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL}, 8, false, false);
        }
        ds.setName(title);
        try {
            ds.setRGBMerged(true);
        }
        catch (IllegalArgumentException e) {
            this.log.debug(e);
        }
        return ds;
    }

    private File getRandomAboutImagePath() {
        File imagesDir = new File(this.appService.getApp().getBaseDirectory(), "images");
        File aboutDir = new File(imagesDir, "about");
        if (!aboutDir.exists()) {
            this.log.warn("About folder '" + aboutDir.getPath() + "' does not exist.");
            return null;
        }
        File[] aboutFiles = aboutDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().toLowerCase().endsWith(".txt");
            }
        });
        MersenneTwisterFast rng = new MersenneTwisterFast();
        int index = rng.nextInt(aboutFiles.length);
        return aboutFiles[index];
    }

    private void drawTextOverImage(Dataset ds) {
        this.textChannels = new ChannelCollection(this.textColor);
        this.outlineChannels = new ChannelCollection(this.outlineColor);
        DrawingTool tool = new DrawingTool(ds, this.rendSrv);
        tool.setUAxis(0);
        tool.setVAxis(1);
        long width = ds.dimension(0);
        long x = width / 2L;
        long y = 50L;
        tool.setTextAntialiasing(true);
        tool.setFontSize(this.largestFontSize);
        this.drawOutlinedText(tool, x, y, this.getApp().getTitle(), TextRenderer.TextJustification.CENTER, this.textChannels, this.outlineChannels);
        y += (long)(5 * tool.getFontSize() / 4);
        tool.setFontSize((int)Math.round(0.6 * (double)this.largestFontSize));
        for (String line : this.getTextBlock()) {
            this.drawOutlinedText(tool, x, y, line, TextRenderer.TextJustification.CENTER, this.textChannels, this.outlineChannels);
            y += (long)(5 * tool.getFontSize() / 4);
        }
    }

    private void drawOutlinedText(DrawingTool tool, long x, long y, String text, TextRenderer.TextJustification just, ChannelCollection textValues, ChannelCollection outlineValues) {
        tool.setChannels(outlineValues);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                tool.drawText(x + (long)dx, y + (long)dy, text, just);
            }
        }
        tool.setChannels(textValues);
        tool.drawText(x, y, text, just);
    }

    private List<String> getTextBlock() {
        Manifest mft = this.getApp().getManifest();
        LinkedList<String> stringList = new LinkedList<String>();
        stringList.add("Version: " + this.getApp().getVersion());
        if (mft != null) {
            String build = mft.getImplementationBuild();
            stringList.add("Build: " + (build == null || build.length() < 10 ? build : build.substring(0, 10)));
            stringList.add("Date: " + mft.getImplementationDate());
        }
        stringList.add("Open source image processing software");
        int year = Calendar.getInstance().get(1);
        stringList.add("Copyright 2010 - " + year);
        stringList.add("http://imagej.net/Contributors");
        stringList.addAll(this.attributionStrings);
        return stringList;
    }

    private void loadAttributes(File baseFile) {
        if (baseFile == null) {
            return;
        }
        String fileName = baseFile.getAbsolutePath() + ".txt";
        File file2 = new File(fileName);
        if (file2.exists()) {
            Pattern attributionPattern = Pattern.compile("attribution\\s+(.*)");
            Pattern colorPattern = Pattern.compile("color\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
            Pattern fontsizePattern = Pattern.compile("fontsize\\s+([1-9][0-9]*)");
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(file2);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    Matcher fontsizeMatcher;
                    Matcher colorMatcher;
                    Matcher attributionMatcher = attributionPattern.matcher(strLine);
                    if (attributionMatcher.matches()) {
                        this.attributionStrings.add(attributionMatcher.group(1).trim());
                    }
                    if ((colorMatcher = colorPattern.matcher(strLine)).matches()) {
                        try {
                            int r = Integer.parseInt(colorMatcher.group(1));
                            int g = Integer.parseInt(colorMatcher.group(2));
                            int b = Integer.parseInt(colorMatcher.group(3));
                            this.textColor = new ColorRGB(r, g, b);
                        }
                        catch (Exception r) {
                            // empty catch block
                        }
                    }
                    if (!(fontsizeMatcher = fontsizePattern.matcher(strLine)).matches()) continue;
                    try {
                        this.largestFontSize = Integer.parseInt(fontsizeMatcher.group(1));
                    }
                    catch (Exception exception) {}
                }
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private App getApp() {
        return this.appService.getApp();
    }
}

