/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.animation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.imagej.Data;
import net.imagej.animation.Animation;
import net.imagej.animation.AnimationService;
import net.imagej.display.ImageDisplay;
import net.imagej.event.DataRestructuredEvent;
import org.scijava.app.StatusService;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.input.KeyCode;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultAnimationService
extends AbstractService
implements AnimationService {
    private static final String STARTED_STATUS = "Animation started. Press '\\' or ESC to stop.";
    private static final String STOPPED_STATUS = "Animation stopped. Press '\\' to resume.";
    private static final String ALL_STOPPED_STATUS = "All animations stopped.";
    @Parameter
    private EventService eventService;
    @Parameter
    private StatusService statusService;
    private Map<ImageDisplay, Animation> animations;

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public void toggle(ImageDisplay display) {
        if (this.getAnimation(display).isActive()) {
            this.stop(display);
        } else {
            this.start(display);
        }
    }

    @Override
    public void start(ImageDisplay display) {
        this.getAnimation(display).start();
        this.statusService.showStatus(STARTED_STATUS);
    }

    @Override
    public void stop(ImageDisplay display) {
        Animation animation = this.animations.get(display);
        if (animation != null) {
            animation.stop();
            this.statusService.showStatus(STOPPED_STATUS);
        }
    }

    @Override
    public void stopAll() {
        for (Animation animation : this.animations.values()) {
            animation.stop();
        }
        this.statusService.showStatus(ALL_STOPPED_STATUS);
    }

    @Override
    public Animation getAnimation(ImageDisplay display) {
        Animation animation = this.animations.get(display);
        if (animation == null) {
            animation = new Animation(display);
            this.animations.put(display, animation);
        }
        return animation;
    }

    @Override
    public void initialize() {
        this.animations = new ConcurrentHashMap<ImageDisplay, Animation>();
    }

    @Override
    public void dispose() {
        this.stopAll();
    }

    @EventHandler
    protected void onEvent(KyPressedEvent event) {
        ImageDisplay imageDisplay = this.toImageDisplay(event.getDisplay());
        if (imageDisplay == null) {
            return;
        }
        if (event.getCode() == KeyCode.ESCAPE) {
            this.stop(imageDisplay);
        }
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent event) {
        ImageDisplay imageDisplay = this.toImageDisplay((Display<?>)event.getObject());
        if (imageDisplay == null) {
            return;
        }
        this.stop(imageDisplay);
        this.animations.remove(imageDisplay);
    }

    @EventHandler
    protected void onEvent(DataRestructuredEvent event) {
        Data data = event.getObject();
        for (Animation animation : this.animations.values()) {
            ImageDisplay display = animation.getDisplay();
            if (!display.isDisplaying(data)) continue;
            this.stop(display);
        }
    }

    private ImageDisplay toImageDisplay(Display<?> display) {
        if (!(display instanceof ImageDisplay)) {
            return null;
        }
        return (ImageDisplay)display;
    }
}

