/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import java.util.Arrays;
import java.util.LinkedList;
import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.DrawingTool;
import net.imagej.axis.Axes;
import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.RealType;
import org.scijava.util.RealRect;

public class FloodFiller {
    private final DrawingTool tool;
    private int channelAxis;
    private int uAxis;
    private int vAxis;
    private final StackOfLongs uStack;
    private final StackOfLongs vStack;

    public FloodFiller(DrawingTool tool) {
        this.tool = tool;
        this.channelAxis = tool.getDataset().dimensionIndex(Axes.CHANNEL);
        this.uAxis = -1;
        this.vAxis = -1;
        this.uStack = new StackOfLongs();
        this.vStack = new StackOfLongs();
    }

    public boolean fill4(long u0, long v0, long[] position) {
        Dataset ds = this.tool.getDataset();
        RandomAccess<RealType<?>> accessor = ds.getImgPlus().randomAccess();
        accessor.setPosition(position);
        this.uAxis = this.tool.getUAxis();
        this.vAxis = this.tool.getVAxis();
        ChannelCollection fillValues = this.tool.getChannels();
        if (this.matches(accessor, u0, v0, fillValues)) {
            return false;
        }
        ChannelCollection origValues = this.getValues(accessor, u0, v0);
        long maxU = ds.dimension(this.uAxis) - 1L;
        long maxV = ds.dimension(this.vAxis) - 1L;
        this.clearUV();
        this.pushUV(u0, v0);
        while (!this.uStack.isEmpty()) {
            long i;
            long u1;
            long v;
            long u = this.popU();
            if (!this.matches(accessor, u, v = this.popV(), origValues)) continue;
            long u2 = u;
            for (u1 = u; u1 >= 0L && this.matches(accessor, u1, v, origValues); --u1) {
            }
            ++u1;
            while (u2 <= maxU && this.matches(accessor, u2, v, origValues)) {
                ++u2;
            }
            this.tool.drawLine(u1, v, --u2, v);
            boolean inScanLine = false;
            for (i = u1; i <= u2; ++i) {
                if (!inScanLine && v > 0L && this.matches(accessor, i, v - 1L, origValues)) {
                    this.pushUV(i, v - 1L);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || v <= 0L || this.matches(accessor, i, v - 1L, origValues)) continue;
                inScanLine = false;
            }
            inScanLine = false;
            for (i = u1; i <= u2; ++i) {
                if (!inScanLine && v < maxV && this.matches(accessor, i, v + 1L, origValues)) {
                    this.pushUV(i, v + 1L);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || v >= maxV || this.matches(accessor, i, v + 1L, origValues)) continue;
                inScanLine = false;
            }
        }
        return true;
    }

    public boolean fill8(long u0, long v0, long[] position) {
        Dataset ds = this.tool.getDataset();
        RandomAccess<RealType<?>> accessor = ds.getImgPlus().randomAccess();
        accessor.setPosition(position);
        this.uAxis = this.tool.getUAxis();
        this.vAxis = this.tool.getVAxis();
        ChannelCollection fillValues = this.tool.getChannels();
        if (this.matches(accessor, u0, v0, fillValues)) {
            return false;
        }
        ChannelCollection origValues = this.getValues(accessor, u0, v0);
        long maxU = ds.dimension(this.uAxis) - 1L;
        long maxV = ds.dimension(this.vAxis) - 1L;
        this.clearUV();
        this.pushUV(u0, v0);
        while (!this.uStack.isEmpty()) {
            long i;
            long u1;
            long u = this.popU();
            long v = this.popV();
            long u2 = u;
            if (this.matches(accessor, u, v, origValues)) {
                for (u1 = u; u1 >= 0L && this.matches(accessor, u1, v, origValues); --u1) {
                }
                ++u1;
                while (u2 <= maxU && this.matches(accessor, u2, v, origValues)) {
                    ++u2;
                }
                this.tool.drawLine(u1, v, --u2, v);
            }
            if (v > 0L) {
                if (u1 > 0L && this.matches(accessor, u1 - 1L, v - 1L, origValues)) {
                    this.pushUV(u1 - 1L, v - 1L);
                }
                if (u2 < maxU && this.matches(accessor, u2 + 1L, v - 1L, origValues)) {
                    this.pushUV(u2 + 1L, v - 1L);
                }
            }
            if (v < maxV) {
                if (u1 > 0L && this.matches(accessor, u1 - 1L, v + 1L, origValues)) {
                    this.pushUV(u1 - 1L, v + 1L);
                }
                if (u2 < maxU && this.matches(accessor, u2 + 1L, v + 1L, origValues)) {
                    this.pushUV(u2 + 1L, v + 1L);
                }
            }
            boolean inScanLine = false;
            for (i = u1; i <= u2; ++i) {
                if (!inScanLine && v > 0L && this.matches(accessor, i, v - 1L, origValues)) {
                    this.pushUV(i, v - 1L);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || v <= 0L || this.matches(accessor, i, v - 1L, origValues)) continue;
                inScanLine = false;
            }
            inScanLine = false;
            for (i = u1; i <= u2; ++i) {
                if (!inScanLine && v < maxV && this.matches(accessor, i, v + 1L, origValues)) {
                    this.pushUV(i, v + 1L);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || v >= maxV || this.matches(accessor, i, v + 1L, origValues)) continue;
                inScanLine = false;
            }
        }
        return true;
    }

    public void particleAnalyzerFill(long u0, long v0, long[] position, double level1, double level2, DrawingTool maskTool, RealRect bounds) {
        Dataset ds = this.tool.getDataset();
        if (this.channelAxis != -1 || ds.dimension(this.channelAxis) != 1L) {
            throw new IllegalArgumentException("particle analyzer cannot support multiple channels");
        }
        RandomAccess<RealType<?>> acc = ds.getImgPlus().randomAccess();
        acc.setPosition(position);
        this.uAxis = this.tool.getUAxis();
        this.vAxis = this.tool.getVAxis();
        long maxU = ds.dimension(this.uAxis) - 1L;
        long maxV = ds.dimension(this.vAxis) - 1L;
        long numChan = ds.dimension(this.channelAxis);
        this.setValues(maskTool, numChan, 0.0);
        maskTool.fill();
        this.setValues(maskTool, numChan, 255.0);
        this.clearUV();
        this.pushUV(u0, v0);
        while (!this.uStack.isEmpty()) {
            long i;
            long u1;
            long v;
            long u = this.popU();
            if (!this.inParticle(acc, u, v = this.popV(), level1, level2)) continue;
            long u2 = u;
            for (u1 = u; this.inParticle(acc, u1, v, level1, level2) && u1 >= 0L; --u1) {
            }
            ++u1;
            while (this.inParticle(acc, u2, v, level1, level2) && u2 <= maxU) {
                ++u2;
            }
            maskTool.drawLine((long)((double)u1 - bounds.x), (long)((double)v - bounds.y), (long)((double)(--u2) - bounds.x), (long)((double)v - bounds.y));
            this.tool.drawLine(u1, v, u2, v);
            boolean inScanLine = false;
            if (u1 > 0L) {
                --u1;
            }
            if (u2 < maxU) {
                ++u2;
            }
            for (i = u1; i <= u2; ++i) {
                if (!inScanLine && v > 0L && this.inParticle(acc, i, v - 1L, level1, level2)) {
                    this.pushUV(i, v - 1L);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || v <= 0L || this.inParticle(acc, i, v - 1L, level1, level2)) continue;
                inScanLine = false;
            }
            inScanLine = false;
            for (i = u1; i <= u2; ++i) {
                if (!inScanLine && v < maxV && this.inParticle(acc, i, v + 1L, level1, level2)) {
                    this.pushUV(i, v + 1L);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || v >= maxV || this.inParticle(acc, i, v + 1L, level1, level2)) continue;
                inScanLine = false;
            }
        }
    }

    private boolean inParticle(RandomAccess<? extends RealType<?>> accessor, long u, long v, double level1, double level2) {
        accessor.setPosition(u, this.uAxis);
        accessor.setPosition(v, this.vAxis);
        double val = ((RealType)accessor.get()).getRealDouble();
        return val >= level1 && val <= level2;
    }

    private void setValues(DrawingTool tool, long numChan, double value) {
        LinkedList<Double> values = new LinkedList<Double>();
        for (long i = 0L; i < numChan; ++i) {
            values.add(value);
        }
        ChannelCollection channels = new ChannelCollection(values);
        tool.setChannels(channels);
    }

    private boolean matches(RandomAccess<? extends RealType<?>> accessor, long u, long v, ChannelCollection channels) {
        accessor.setPosition(u, this.uAxis);
        accessor.setPosition(v, this.vAxis);
        if (this.channelAxis == -1) {
            double val = ((RealType)accessor.get()).getRealDouble();
            return val == channels.getChannelValue(0L);
        }
        long numChan = this.tool.getDataset().dimension(this.channelAxis);
        for (long c = 0L; c < numChan; ++c) {
            accessor.setPosition(c, this.channelAxis);
            double value = ((RealType)accessor.get()).getRealDouble();
            if (value == channels.getChannelValue(c)) continue;
            return false;
        }
        return true;
    }

    private ChannelCollection getValues(RandomAccess<? extends RealType<?>> accessor, long u, long v) {
        LinkedList<Double> channels = new LinkedList<Double>();
        accessor.setPosition(u, this.uAxis);
        accessor.setPosition(v, this.vAxis);
        long numChannels = 1L;
        if (this.channelAxis != -1) {
            numChannels = this.tool.getDataset().dimension(this.channelAxis);
        }
        for (long c = 0L; c < numChannels; ++c) {
            if (this.channelAxis != -1) {
                accessor.setPosition(c, this.channelAxis);
            }
            double val = ((RealType)accessor.get()).getRealDouble();
            channels.add(val);
        }
        return new ChannelCollection(channels);
    }

    private void pushUV(long u, long v) {
        this.uStack.push(u);
        this.vStack.push(v);
    }

    private long popU() {
        return this.uStack.pop();
    }

    private long popV() {
        return this.vStack.pop();
    }

    private void clearUV() {
        this.uStack.clear();
        this.vStack.clear();
    }

    private class StackOfLongs {
        private int top = -1;
        private long[] stack = new long[400];

        public boolean isEmpty() {
            return this.top < 0;
        }

        public void clear() {
            this.top = -1;
        }

        public void push(long value) {
            if (this.top == this.stack.length - 1) {
                this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
            }
            ++this.top;
            this.stack[this.top] = value;
        }

        public long pop() {
            if (this.top < 0) {
                throw new IllegalArgumentException("can't pop empty stack");
            }
            long value = this.stack[this.top];
            --this.top;
            return value;
        }
    }
}

