/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.enums.Immersion;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OIRReader
extends FormatReader {
    private HashMap<String, PixelBlock> pixelBlocks = new HashMap();
    private ArrayList<Channel> channels = new ArrayList();
    private ArrayList<Laser> lasers = new ArrayList();
    private ArrayList<Detector> detectors = new ArrayList();
    private ArrayList<Objective> objectives = new ArrayList();
    private Length physicalSizeX;
    private Length physicalSizeY;
    private Length physicalSizeZ;
    private Timestamp acquisitionDate;
    private int defaultXMLSkip = 36;
    private int blocksPerPlane = 0;
    private String[] pixelUIDs = null;
    private String baseName;
    private int lastChannel = -1;

    public OIRReader() {
        super("Olympus OIR", "oir");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        int pixelType = this.getPixelType();
        if (pixelType != 0 && pixelType != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= this.channels.size()) {
            return null;
        }
        return (byte[][])this.channels.get((int)this.lastChannel).lut;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        int pixelType = this.getPixelType();
        if (pixelType != 2 && pixelType != 3 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= this.channels.size()) {
            return null;
        }
        return (short[][])this.channels.get((int)this.lastChannel).lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] zct = this.getZCTCoords(no);
        this.lastChannel = zct[1];
        int newNo = this.getIndex(zct[0], 0, zct[2]) / this.getSizeC();
        int startIndex = -1;
        int step = this.blocksPerPlane * this.getSizeZ() * this.getSizeT();
        for (int first = newNo * this.getSizeC() * this.blocksPerPlane + zct[1] * this.blocksPerPlane; first < this.pixelUIDs.length; first += step) {
            if (this.pixelUIDs[first].indexOf(this.channels.get((int)(zct[1] % this.channels.size())).id) <= 0) continue;
            startIndex = first;
            break;
        }
        int end = startIndex + this.blocksPerPlane;
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int bufferOffset = bpp * (y * this.getSizeX() + x);
        int rowLen = bpp * w;
        int imageWidth = bpp * this.getSizeX();
        int bufferEnd = bpp * ((y + h) * this.getSizeX() + x + w);
        int bufferPointer = 0;
        for (int i = startIndex; i < end; ++i) {
            PixelBlock block = this.pixelBlocks.get(this.pixelUIDs[i]);
            if (bufferPointer + block.length < bufferOffset || bufferPointer >= bufferEnd) {
                bufferPointer += block.length;
                continue;
            }
            byte[] pixels = this.readPixelBlock(block.offset);
            if (pixels != null) {
                int blockY = bufferPointer / imageWidth;
                int blockH = pixels.length / imageWidth;
                for (int yy = blockY; yy < blockY + blockH; ++yy) {
                    if (yy < y || yy >= y + h) continue;
                    int blockOffset = (yy - blockY) * imageWidth + x * bpp;
                    int bufOffset = (yy - y) * rowLen;
                    System.arraycopy(pixels, blockOffset, buf, bufOffset, rowLen);
                }
            }
            bufferPointer += block.length;
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelBlocks.clear();
            this.channels.clear();
            this.lasers.clear();
            this.detectors.clear();
            this.objectives.clear();
            this.physicalSizeX = null;
            this.physicalSizeY = null;
            this.physicalSizeZ = null;
            this.acquisitionDate = null;
            this.defaultXMLSkip = 36;
            this.blocksPerPlane = 0;
            this.pixelUIDs = null;
            this.baseName = null;
            this.lastChannel = -1;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String lsid;
        int i;
        String prefix;
        int tIndex;
        int zIndex;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.indexed = true;
        m.falseColor = true;
        long baseOffset = 16L;
        this.in.seek(baseOffset);
        while (this.in.readInt() != -1) {
        }
        this.in.skipBytes(4);
        while (this.skipPixelBlock(false)) {
        }
        this.readXMLBlock();
        while (this.skipPixelBlock(true)) {
        }
        this.readXMLBlock();
        while (this.in.getFilePointer() < this.in.length() - 16L) {
            boolean expectPixelBlock;
            this.in.findString("<?xml");
            this.in.seek(this.in.getFilePointer() - 9L);
            int length = this.in.readInt();
            if (length < 0 || (long)length + this.in.getFilePointer() > this.in.length()) break;
            long fp = this.in.getFilePointer();
            String xml = this.in.readString(length);
            if (!xml.startsWith("<?xml")) {
                this.in.seek(fp - 2L);
                continue;
            }
            LOGGER.trace("xml = {}", (Object)xml);
            if (this.channels.size() == 0 || this.getSizeX() == 0 || this.getSizeY() == 0) {
                this.parseXML(xml, fp);
            }
            if (!(expectPixelBlock = xml.endsWith(":frameProperties>"))) continue;
            while (this.skipPixelBlock(true)) {
            }
        }
        m.sizeC *= this.channels.size();
        m.imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
        if (this.blocksPerPlane * this.getImageCount() > this.pixelBlocks.size()) {
            if (this.getSizeT() > 1) {
                m.sizeT = this.pixelBlocks.size() / (this.blocksPerPlane * this.getSizeC() * this.getSizeZ());
            } else if (this.getSizeZ() > 1) {
                m.sizeZ = this.pixelBlocks.size() / (this.blocksPerPlane * this.getSizeC());
            }
            m.imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
        }
        m.dimensionOrder = "XYC";
        m.dimensionOrder = this.getSizeZ() == 1 || this.getSizeT() == 1 ? m.dimensionOrder + "ZT" : ((zIndex = this.baseName.toLowerCase().indexOf("z")) < (tIndex = this.baseName.toLowerCase().indexOf("t")) ? m.dimensionOrder + "TZ" : m.dimensionOrder + "ZT");
        this.pixelUIDs = this.pixelBlocks.keySet().toArray(new String[this.pixelBlocks.size()]);
        Arrays.sort(this.pixelUIDs, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int lastUnderscore1 = s1.lastIndexOf("_");
                int lastUnderscore2 = s2.lastIndexOf("_");
                Integer block1 = new Integer(s1.substring(lastUnderscore1 + 1));
                Integer block2 = new Integer(s2.substring(lastUnderscore2 + 1));
                int underscore1 = s1.lastIndexOf("_", lastUnderscore1 - 1);
                int underscore2 = s2.lastIndexOf("_", lastUnderscore2 - 1);
                String prefix1 = s1.substring(0, underscore1);
                String prefix2 = s2.substring(0, underscore2);
                String channel1 = s1.substring(underscore1 + 1, lastUnderscore1);
                String channel2 = s2.substring(underscore2 + 1, lastUnderscore2);
                if (!prefix1.equals(prefix2)) {
                    return s1.compareTo(s2);
                }
                if (!channel1.equals(channel2)) {
                    Integer index1 = -1;
                    Integer index2 = -2;
                    for (int i = 0; i < OIRReader.this.channels.size(); ++i) {
                        if (((Channel)((OIRReader)OIRReader.this).channels.get((int)i)).id.equals(channel1)) {
                            index1 = i;
                        }
                        if (!((Channel)((OIRReader)OIRReader.this).channels.get((int)i)).id.equals(channel2)) continue;
                        index2 = i;
                    }
                    return index1.compareTo(index2);
                }
                return block1.compareTo(block2);
            }
        });
        if (LOGGER.isTraceEnabled()) {
            for (int i2 = 0; i2 < this.pixelUIDs.length; ++i2) {
                LOGGER.trace("pixel UID #{} = {}", (Object)i2, (Object)this.pixelUIDs[i2]);
            }
        }
        Hashtable<String, Object> tmpMeta = new Hashtable<String, Object>();
        this.addMeta("Creation date", this.acquisitionDate, tmpMeta);
        this.addMeta("Pixel Length X", this.physicalSizeX, tmpMeta);
        this.addMeta("Pixel Length Y", this.physicalSizeY, tmpMeta);
        this.addMeta("Z step", this.physicalSizeZ, tmpMeta);
        for (Channel channel : this.channels) {
            prefix = "Channel " + channel.name + " ";
            this.addMetaList(prefix + "ID", channel.id, tmpMeta);
            this.addMetaList(prefix + "color", channel.color, tmpMeta);
            this.addMetaList(prefix + "pinhole", channel.pinhole, tmpMeta);
            this.addMetaList(prefix + "start wavelength", channel.excitation, tmpMeta);
            this.addMetaList(prefix + "end wavelength", channel.emission, tmpMeta);
            this.addMetaList(prefix + "linked laser index", channel.laserIndex, tmpMeta);
        }
        for (Objective objective : this.objectives) {
            this.addMetaList("Objective Lens name", objective.name, tmpMeta);
            this.addMetaList("Objective Lens magnification", objective.magnification, tmpMeta);
            this.addMetaList("Objective Lens na", objective.na, tmpMeta);
            this.addMetaList("Objective Lens wd", objective.wd, tmpMeta);
            this.addMetaList("Objective Lens refractive index", objective.ri, tmpMeta);
            this.addMetaList("Objective Lens immersion", objective.immersion, tmpMeta);
        }
        for (Laser laser : this.lasers) {
            prefix = "Laser " + laser.name + " ";
            this.addMetaList(prefix + "ID", laser.id, tmpMeta);
            this.addMetaList(prefix + "data ID", laser.dataId, tmpMeta);
            this.addMetaList(prefix + "power", laser.power, tmpMeta);
            this.addMetaList(prefix + "transmissivity", laser.transmissivity, tmpMeta);
            this.addMetaList(prefix + "wavelength", laser.wavelength, tmpMeta);
        }
        for (Detector detector : this.detectors) {
            this.addMetaList("Detector ID", detector.id, tmpMeta);
            this.addMetaList("Detector linked channel ID", detector.channelId, tmpMeta);
            this.addMetaList("Detector voltage", detector.voltage, tmpMeta);
            this.addMetaList("Detector offset", detector.offset, tmpMeta);
            this.addMetaList("Detector gain", detector.gain, tmpMeta);
        }
        MetadataTools.merge(tmpMeta, this.metadata, "\u0000");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        for (i = 0; i < this.lasers.size(); ++i) {
            Laser l = this.lasers.get(i);
            lsid = MetadataTools.createLSID("LightSource", 0, i);
            store.setLaserID(lsid, 0, i);
            store.setLaserModel(l.id, 0, i);
            if (l.wavelength == null) continue;
            store.setLaserWavelength(FormatTools.getWavelength(l.wavelength, null), 0, i);
        }
        for (i = 0; i < this.detectors.size(); ++i) {
            Detector detector = this.detectors.get(i);
            lsid = MetadataTools.createLSID("Detector", 0, i);
            store.setDetectorID(lsid, 0, i);
            store.setDetectorOffset(detector.offset, 0, i);
            store.setDetectorVoltage(FormatTools.createElectricPotential(detector.voltage, UNITS.VOLT), 0, i);
            store.setDetectorGain(detector.gain, 0, i);
        }
        for (i = 0; i < this.objectives.size(); ++i) {
            Objective objective = this.objectives.get(i);
            lsid = MetadataTools.createLSID("Objective", 0, i);
            store.setObjectiveID(lsid, 0, i);
            store.setObjectiveModel(objective.name, 0, i);
            store.setObjectiveNominalMagnification(objective.magnification, 0, i);
            store.setObjectiveLensNA(objective.na, 0, i);
            store.setObjectiveWorkingDistance(FormatTools.createLength(objective.wd, UNITS.MILLIMETRE), 0, i);
            store.setObjectiveImmersion(objective.immersion, 0, i);
            if (i != 0) continue;
            store.setObjectiveSettingsID(lsid, 0);
            store.setObjectiveSettingsRefractiveIndex(objective.ri, 0);
        }
        if (this.acquisitionDate != null) {
            store.setImageAcquisitionDate(this.acquisitionDate, 0);
        }
        if (this.physicalSizeX != null) {
            store.setPixelsPhysicalSizeX(this.physicalSizeX, 0);
        }
        if (this.physicalSizeY != null) {
            store.setPixelsPhysicalSizeY(this.physicalSizeY, 0);
        }
        if (this.physicalSizeZ != null) {
            store.setPixelsPhysicalSizeZ(this.physicalSizeZ, 0);
        }
        for (int c = 0; c < this.channels.size(); ++c) {
            Channel ch = this.channels.get(c);
            store.setChannelName(ch.name, 0, c);
            if (ch.color != null) {
                store.setChannelColor(ch.color, 0, c);
            }
            if (ch.pinhole != null) {
                store.setChannelPinholeSize(ch.pinhole, 0, c);
            }
            if (ch.emission != null) {
                store.setChannelEmissionWavelength(ch.emission, 0, c);
            }
            if (ch.excitation != null) {
                store.setChannelExcitationWavelength(ch.excitation, 0, c);
            }
            for (int d = 0; d < this.detectors.size(); ++d) {
                if (!this.detectors.get((int)d).channelId.equals(ch.id)) continue;
                store.setDetectorSettingsID(MetadataTools.createLSID("Detector", 0, d), 0, c);
            }
            if (ch.laserIndex < 0 || ch.laserIndex >= this.lasers.size()) continue;
            String laserId = MetadataTools.createLSID("LightSource", 0, ch.laserIndex);
            store.setChannelLightSourceSettingsID(laserId, 0, c);
        }
    }

    private void readXMLBlock() throws FormatException, IOException {
        long offset = this.in.getFilePointer();
        if (this.in.getFilePointer() + 8L >= this.in.length()) {
            return;
        }
        int totalBlockLength = this.in.readInt();
        long end = this.in.getFilePointer() + (long)totalBlockLength - 4L;
        this.in.skipBytes(4);
        while (this.in.getFilePointer() < end) {
            long start = this.in.getFilePointer();
            this.in.skipBytes(this.defaultXMLSkip);
            int xmlLength = this.in.readInt();
            if (xmlLength <= 32) {
                xmlLength = this.in.readInt();
                String uid = this.in.readString(xmlLength);
                xmlLength = this.in.readInt();
            } else if (xmlLength < 0 || (long)xmlLength >= this.in.length() - this.in.getFilePointer()) {
                this.in.seek(this.in.getFilePointer() - 40L);
                xmlLength = this.in.readInt();
                if (xmlLength <= 0 || (long)xmlLength + this.in.getFilePointer() > this.in.length()) {
                    this.in.seek(start);
                    xmlLength = this.in.readInt();
                    if (xmlLength <= 0 || (long)xmlLength + this.in.getFilePointer() > this.in.length()) {
                        return;
                    }
                }
                String uid = this.in.readString(xmlLength);
                xmlLength = this.in.readInt();
                if (xmlLength < 0 || xmlLength > totalBlockLength) {
                    this.in.seek(offset + 4L);
                    int skipped = 0;
                    while (this.in.readInt() != totalBlockLength - skipped) {
                        skipped += 4;
                        if (this.in.getFilePointer() + 4L < this.in.length()) continue;
                        this.in.seek(end);
                        return;
                    }
                    xmlLength = totalBlockLength - skipped;
                    this.defaultXMLSkip = skipped - 4;
                }
            }
            if (xmlLength <= 32 || this.in.getFilePointer() + (long)xmlLength > end + 8L) break;
            long fp = this.in.getFilePointer();
            String xml = this.in.readString(xmlLength).trim();
            LOGGER.trace("xml = {}", (Object)xml);
            this.parseXML(xml, fp);
        }
    }

    private void parseXML(String xml, long startFilePointer) throws FormatException, IOException {
        Element root = null;
        try {
            root = XMLTools.parseDOM(xml).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            LOGGER.debug("Could not parse XML", e);
            return;
        }
        catch (SAXException e) {
            LOGGER.debug("Could not parse XML", e);
            return;
        }
        if (root != null) {
            String name = root.getNodeName();
            if ("lsmimage:imageProperties".equals(name)) {
                this.parseImageProperties(root);
            } else if ("lsmframe:frameProperties".equals(name)) {
                this.parseFrameProperties(root);
            } else if ("lut:LUT".equals(name)) {
                long fp = this.in.getFilePointer();
                this.in.seek(startFilePointer - 44L);
                int uidLength = this.in.readInt();
                String uid = this.in.readString(uidLength);
                this.in.seek(fp);
                this.parseLUT(root, uid);
            }
            this.parseOriginalMetadata(root);
        }
    }

    private void parseLUT(Element root, String uid) throws FormatException {
        Element data;
        Element linear = this.getFirstChild(root, "lut:linear");
        boolean isLinear = false;
        if (linear != null) {
            isLinear = Boolean.valueOf(linear.getTextContent());
        }
        if ((data = this.getFirstChild(root, "lut:data")) != null) {
            String lutContent = data.getTextContent();
            for (int i = 0; i < this.channels.size(); ++i) {
                if (this.channels.get((int)i).lut != null || !this.channels.get((int)i).id.equals(uid)) continue;
                if (this.getPixelType() == 1) {
                    this.channels.get((int)i).lut = new byte[3][lutContent.length() / 8];
                } else if (this.getPixelType() == 3) {
                    this.channels.get((int)i).lut = new short[3][lutContent.length() / 8];
                } else {
                    LOGGER.warn("Skipping LUTs for pixel type {}", (Object)this.getPixelType());
                    return;
                }
                for (int q = 0; q < lutContent.length(); q += 8) {
                    int r = Integer.parseInt(lutContent.substring(q, q + 2), 16);
                    int g = Integer.parseInt(lutContent.substring(q + 2, q + 4), 16);
                    int b = Integer.parseInt(lutContent.substring(q + 4, q + 6), 16);
                    if (this.channels.get((int)i).lut instanceof byte[][]) {
                        ((byte[][])this.channels.get((int)i).lut)[0][q / 8] = (byte)(r & 0xFF);
                        ((byte[][])this.channels.get((int)i).lut)[1][q / 8] = (byte)(g & 0xFF);
                        ((byte[][])this.channels.get((int)i).lut)[2][q / 8] = (byte)(b & 0xFF);
                    } else if (this.channels.get((int)i).lut instanceof short[][]) {
                        ((short[][])this.channels.get((int)i).lut)[0][q / 8] = (short)((r & 0xFFFF) * 256);
                        ((short[][])this.channels.get((int)i).lut)[1][q / 8] = (short)((g & 0xFFFF) * 256);
                        ((short[][])this.channels.get((int)i).lut)[2][q / 8] = (short)((b & 0xFFFF) * 256);
                    }
                    if (!isLinear || q != lutContent.length() - 8) continue;
                    this.channels.get((int)i).color = new Color(r, g, b, 255);
                }
                break;
            }
        }
    }

    private void parseFrameProperties(Element root) throws FormatException {
        Element name;
        Element general;
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        Element imageDefinition = this.getFirstChild(root, "commonframe:imageDefinition");
        if (imageDefinition != null) {
            Element width = this.getFirstChild(imageDefinition, "base:width");
            Element height = this.getFirstChild(imageDefinition, "base:height");
            Element depth = this.getFirstChild(imageDefinition, "base:depth");
            Element bitCount = this.getFirstChild(imageDefinition, "base:bitCounts");
            if (width != null) {
                m.sizeX = Integer.parseInt(width.getTextContent());
            }
            if (height != null) {
                m.sizeY = Integer.parseInt(height.getTextContent());
            }
            if (depth != null) {
                int bytes = Integer.parseInt(depth.getTextContent());
                m.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
            }
            if (bitCount != null) {
                m.bitsPerPixel = Integer.parseInt(bitCount.getTextContent());
            }
        }
        if ((general = this.getFirstChild(root, "commonframe:general")) != null && (name = this.getFirstChild(general, "base:name")) != null) {
            this.baseName = name.getTextContent();
        }
    }

    private void parseImageProperties(Element root) throws FormatException {
        block63: {
            boolean appendChannels;
            String id;
            NodeList imagingMainLasers;
            Element imagingParam;
            NodeList objectiveLenses;
            Element imageInfo;
            int i;
            Element lsm;
            Element creationDate;
            CoreMetadata m = (CoreMetadata)this.core.get(0);
            Element general = this.getFirstChild(root, "commonimage:general");
            if (general != null && (creationDate = this.getFirstChild(general, "base:creationDateTime")) != null) {
                String date = creationDate.getTextContent();
                this.acquisitionDate = new Timestamp(date);
            }
            if ((lsm = this.getFirstChild(root, "commonimage:lsm")) != null) {
                NodeList laserNodes = lsm.getElementsByTagName("commonimage:laser");
                for (i = 0; i < laserNodes.getLength(); ++i) {
                    Element laser = (Element)laserNodes.item(i);
                    Element idNode = this.getFirstChild(laser, "commonimage:id");
                    Element nameNode = this.getFirstChild(laser, "commonimage:name");
                    Laser l = new Laser();
                    if (idNode != null) {
                        l.id = idNode.getTextContent();
                    }
                    if (nameNode != null) {
                        l.name = nameNode.getTextContent();
                    }
                    this.lasers.add(l);
                }
            }
            if ((imageInfo = this.getFirstChild(root, "commonimage:imageInfo")) != null) {
                NodeList axisNodes;
                Element width = this.getFirstChild(imageInfo, "commonimage:width");
                Element height = this.getFirstChild(imageInfo, "commonimage:height");
                if (width != null && this.getSizeX() == 0) {
                    m.sizeX = Integer.parseInt(width.getTextContent());
                }
                if (height != null && this.getSizeY() == 0) {
                    m.sizeY = Integer.parseInt(height.getTextContent());
                }
                if ((axisNodes = imageInfo.getElementsByTagName("commonimage:axis")) != null) {
                    for (int i2 = 0; i2 < axisNodes.getLength(); ++i2) {
                        this.parseAxis((Element)axisNodes.item(i2));
                    }
                }
                NodeList channelNodes = imageInfo.getElementsByTagName("commonphase:channel");
                for (int i3 = 0; i3 < channelNodes.getLength(); ++i3) {
                    Element imageDefinition;
                    Double wave;
                    Double pinholeSize;
                    Element pinhole;
                    Channel c = new Channel();
                    Element channelNode = (Element)channelNodes.item(i3);
                    c.id = channelNode.getAttribute("id");
                    int index = Integer.parseInt(channelNode.getAttribute("order")) - 1;
                    Element name = this.getFirstChild(channelNode, "commonphase:name");
                    if (name != null) {
                        c.name = name.getTextContent();
                    }
                    if ((pinhole = this.getFirstChild(channelNode, "fvCommonphase:pinholeDiameter")) != null && (pinholeSize = DataTools.parseDouble(pinhole.getTextContent())) != null) {
                        c.pinhole = new Length(pinholeSize, UNITS.MICROMETER);
                    }
                    Element startWavelength = this.getFirstChild(channelNode, "opticalelement:startWavelength");
                    Element endWavelength = this.getFirstChild(channelNode, "opticalelement:endWavelength");
                    if (startWavelength != null && (wave = DataTools.parseDouble(startWavelength.getTextContent())) != null) {
                        c.excitation = FormatTools.getExcitationWavelength(wave);
                    }
                    if (endWavelength != null && (wave = DataTools.parseDouble(endWavelength.getTextContent())) != null) {
                        c.emission = FormatTools.getEmissionWavelength(wave);
                    }
                    if ((imageDefinition = this.getFirstChild(channelNode, "commonphase:imageDefinition")) != null) {
                        Element depth = this.getFirstChild(imageDefinition, "commonphase:depth");
                        Element bitCount = this.getFirstChild(imageDefinition, "commonphase:bitCounts");
                        if (depth != null) {
                            int bytes = Integer.parseInt(depth.getTextContent());
                            m.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
                        }
                        if (bitCount != null) {
                            m.bitsPerPixel = Integer.parseInt(bitCount.getTextContent());
                        }
                    }
                    Element length = this.getFirstChild(channelNode, "commonphase:length");
                    Element pixelUnit = this.getFirstChild(channelNode, "commonphase:pixelUnit");
                    if (length != null) {
                        Element xLength = this.getFirstChild(length, "commonparam:x");
                        Element xUnit = this.getFirstChild(pixelUnit, "commonphase:x");
                        if (xLength != null) {
                            Double x = DataTools.parseDouble(xLength.getTextContent());
                            String unit = null;
                            if (xUnit != null) {
                                unit = xUnit.getTextContent();
                            }
                            this.physicalSizeX = FormatTools.getPhysicalSize(x, unit);
                        }
                        Element yLength = this.getFirstChild(length, "commonparam:y");
                        Element yUnit = this.getFirstChild(pixelUnit, "commonphase:y");
                        if (yLength != null) {
                            Double y = DataTools.parseDouble(yLength.getTextContent());
                            String unit = null;
                            if (yUnit != null) {
                                unit = yUnit.getTextContent();
                            }
                            this.physicalSizeY = FormatTools.getPhysicalSize(y, unit);
                        }
                        Element zLength = this.getFirstChild(length, "commonparam:z");
                        Element zUnit = this.getFirstChild(pixelUnit, "commonphase:z");
                        if (zLength != null) {
                            Double z = DataTools.parseDouble(zLength.getTextContent());
                            String unit = null;
                            if (zUnit != null) {
                                unit = zUnit.getTextContent();
                            }
                            this.physicalSizeZ = FormatTools.getPhysicalSize(z, unit);
                        }
                    }
                    while (index > this.channels.size()) {
                        this.channels.add(null);
                    }
                    if (index == this.channels.size()) {
                        this.channels.add(c);
                        continue;
                    }
                    this.channels.set(index, c);
                }
            }
            for (i = 0; i < this.channels.size(); ++i) {
                if (this.channels.get(i) != null) continue;
                this.channels.remove(i);
                --i;
            }
            Element acquisition = this.getFirstChild(root, "commonimage:acquisition");
            if (acquisition == null) {
                acquisition = this.getFirstChild(root, "lsmimage:acquisition");
            }
            if (acquisition == null) break block63;
            Element microscopeConfiguration = this.getFirstChild(acquisition, "commonimage:microscopeConfiguration");
            if (microscopeConfiguration != null && (objectiveLenses = microscopeConfiguration.getElementsByTagName("commonimage:objectiveLens")) != null) {
                for (int i4 = 0; i4 < objectiveLenses.getLength(); ++i4) {
                    Element lens = (Element)objectiveLenses.item(i4);
                    Objective objective = new Objective();
                    Element lensName = this.getFirstChild(lens, "opticalelement:displayName");
                    Element magnification = this.getFirstChild(lens, "opticalelement:magnification");
                    Element na = this.getFirstChild(lens, "opticalelement:naValue");
                    Element wd = this.getFirstChild(lens, "opticalelement:wdValue");
                    Element refraction = this.getFirstChild(lens, "opticalelement:refraction");
                    Element immersion = this.getFirstChild(lens, "opticalelement:immersion");
                    if (lensName != null) {
                        objective.name = lensName.getTextContent();
                    }
                    if (magnification != null) {
                        objective.magnification = DataTools.parseDouble(magnification.getTextContent());
                    }
                    if (na != null) {
                        objective.na = DataTools.parseDouble(na.getTextContent());
                    }
                    if (wd != null) {
                        objective.wd = DataTools.parseDouble(wd.getTextContent());
                    }
                    if (refraction != null) {
                        objective.ri = DataTools.parseDouble(refraction.getTextContent());
                    }
                    if (immersion != null) {
                        objective.immersion = this.getImmersion(immersion.getTextContent());
                    }
                    this.objectives.add(objective);
                }
            }
            if ((imagingParam = this.getFirstChild(acquisition, "commonimage:imagingParam")) == null) {
                imagingParam = this.getFirstChild(acquisition, "lsmimage:imagingParam");
            }
            if (imagingParam != null) {
                Element resolution;
                NodeList mainLasers;
                NodeList pmts;
                NodeList axes = imagingParam.getElementsByTagName("commonparam:axis");
                if (axes != null) {
                    for (int i5 = 0; i5 < axes.getLength(); ++i5) {
                        Element dimensionAxis = (Element)axes.item(i5);
                        if (!dimensionAxis.hasAttribute("enable") || !dimensionAxis.getAttribute("enable").equals("true") || dimensionAxis.hasAttribute("paramEnable") && !dimensionAxis.getAttribute("paramEnable").equals("true")) continue;
                        this.parseAxis(dimensionAxis);
                    }
                }
                if ((pmts = imagingParam.getElementsByTagName("lsmparam:pmt")) != null) {
                    for (int i6 = 0; i6 < pmts.getLength(); ++i6) {
                        Element pmt = (Element)pmts.item(i6);
                        Detector detector = new Detector();
                        detector.id = pmt.getAttribute("detectorId");
                        detector.channelId = pmt.getAttribute("channelId");
                        Element voltage = this.getFirstChild(pmt, "lsmparam:voltage");
                        Element offset = this.getFirstChild(pmt, "lsmparam:offset");
                        Element gain = this.getFirstChild(pmt, "lsmparam:gain");
                        if (voltage != null) {
                            detector.voltage = DataTools.parseDouble(voltage.getTextContent());
                        }
                        if (offset != null) {
                            detector.offset = DataTools.parseDouble(offset.getTextContent());
                        }
                        if (gain != null) {
                            detector.gain = DataTools.parseDouble(gain.getTextContent());
                        }
                        this.detectors.add(detector);
                    }
                }
                if ((mainLasers = imagingParam.getElementsByTagName("lsmparam:mainLaser")) != null) {
                    for (int i7 = 0; i7 < mainLasers.getLength(); ++i7) {
                        Element mainLaser = (Element)mainLasers.item(i7);
                        String id2 = mainLaser.getAttribute("laserDataId");
                        Laser currentLaser = null;
                        for (int laser = 0; laser < this.lasers.size(); ++laser) {
                            if (!id2.startsWith(this.lasers.get((int)laser).id)) continue;
                            currentLaser = this.lasers.get(laser);
                            break;
                        }
                        if (currentLaser == null) continue;
                        currentLaser.dataId = id2;
                        Element power = this.getFirstChild(mainLaser, "commonparam:power");
                        Element transmissivity = this.getFirstChild(mainLaser, "commonparam:transmissivity");
                        if (power != null) {
                            currentLaser.power = DataTools.parseDouble(power.getTextContent());
                        }
                        if (transmissivity == null) continue;
                        currentLaser.transmissivity = DataTools.parseDouble(transmissivity.getTextContent());
                    }
                }
                if ((resolution = this.getFirstChild(imagingParam, "commonparam:pixelResolution")) != null) {
                    Element x = this.getFirstChild(resolution, "commonparam:x");
                    Element y = this.getFirstChild(resolution, "commonparam:y");
                    Element z = this.getFirstChild(resolution, "commonparam:z");
                    if (x != null && this.physicalSizeX == null) {
                        Double xValue = DataTools.parseDouble(x.getTextContent());
                        this.physicalSizeX = FormatTools.getPhysicalSize(xValue, null);
                    }
                    if (y != null && this.physicalSizeY == null) {
                        Double yValue = DataTools.parseDouble(y.getTextContent());
                        this.physicalSizeY = FormatTools.getPhysicalSize(yValue, null);
                    }
                    if (z != null && this.physicalSizeZ == null) {
                        Double zValue = DataTools.parseDouble(z.getTextContent());
                        this.physicalSizeZ = FormatTools.getPhysicalSize(zValue, null);
                    }
                }
            }
            if ((imagingMainLasers = acquisition.getElementsByTagName("lsmimage:imagingMainLaser")) != null) {
                for (int i8 = 0; i8 < imagingMainLasers.getLength(); ++i8) {
                    Element wavelength;
                    Element mainLaser = (Element)imagingMainLasers.item(i8);
                    id = mainLaser.getAttribute("id");
                    String enable = mainLaser.getAttribute("enable");
                    if (!"true".equals(enable) || (wavelength = this.getFirstChild(mainLaser, "commonimage:wavelength")) == null) continue;
                    for (Laser l : this.lasers) {
                        if (!id.equals(l.dataId)) continue;
                        l.wavelength = DataTools.parseDouble(wavelength.getTextContent());
                    }
                }
            }
            NodeList channelLinkages = acquisition.getElementsByTagName("commonphase:channel");
            for (int c = 0; c < this.channels.size(); ++c) {
                id = this.channels.get((int)c).id;
                boolean hasUID = false;
                for (String uid : this.pixelBlocks.keySet()) {
                    if (uid.indexOf(id) < 0) continue;
                    hasUID = true;
                    break;
                }
                if (hasUID) continue;
                this.channels.remove(c);
                --c;
            }
            boolean bl = appendChannels = this.channels.size() == 0;
            if (channelLinkages != null && channelLinkages.getLength() > 0) {
                for (int i9 = 0; i9 < channelLinkages.getLength(); ++i9) {
                    Element channel = (Element)channelLinkages.item(i9);
                    this.parseChannel(channel, appendChannels);
                }
            } else {
                channelLinkages = acquisition.getElementsByTagName("lsmimage:channel");
                for (int i10 = 0; i10 < channelLinkages.getLength(); ++i10) {
                    Element channel = (Element)channelLinkages.item(i10);
                    this.parseChannel(channel, appendChannels);
                }
            }
        }
    }

    private void parseChannel(Element channel, boolean appendChannels) {
        if (channel.hasAttribute("enable") && !channel.getAttribute("enable").equals("true")) {
            return;
        }
        String id = channel.getAttribute("id");
        NodeList laserIds = channel.getElementsByTagName("lsmimage:laserDataId");
        if (laserIds == null) {
            laserIds = channel.getElementsByTagName("fvLsmimage:laserDataId");
        }
        if (!(laserIds != null && laserIds.getLength() <= 1 || appendChannels)) {
            return;
        }
        String type = channel.getAttribute("xsi:type");
        if (type != null && !type.endsWith("NormalChannel")) {
            return;
        }
        Element laserId = (Element)laserIds.item(0);
        Element name = this.getFirstChild(channel, "commonimage:name");
        String channelName = null;
        if (name != null) {
            channelName = name.getTextContent();
        }
        if (id != null) {
            boolean foundChannel = false;
            block0: for (Channel ch : this.channels) {
                if (!ch.id.equals(id)) continue;
                foundChannel = true;
                if (laserId == null) continue;
                for (int l = 0; l < this.lasers.size(); ++l) {
                    Laser laser = this.lasers.get(l);
                    if (!laser.dataId.equals(laserId.getTextContent())) continue;
                    ch.laserIndex = l;
                    continue block0;
                }
            }
            if (!foundChannel && appendChannels) {
                Channel c = new Channel();
                c.id = id;
                c.name = channelName;
                if (laserId != null) {
                    for (int l = 0; l < this.lasers.size(); ++l) {
                        Laser laser = this.lasers.get(l);
                        if (!laser.dataId.equals(laserId.getTextContent())) continue;
                        c.laserIndex = l;
                        break;
                    }
                }
                this.channels.add(c);
            }
        }
    }

    private void parseAxis(Element dimensionAxis) {
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        Element axis = this.getFirstChild(dimensionAxis, "commonparam:axis");
        Element size = this.getFirstChild(dimensionAxis, "commonparam:maxSize");
        Element start = this.getFirstChild(dimensionAxis, "commonparam:startPosition");
        Element end = this.getFirstChild(dimensionAxis, "commonparam:endPosition");
        Element step = this.getFirstChild(dimensionAxis, "commonparam:step");
        if (axis != null && size != null) {
            String name = axis.getTextContent();
            if (name.equals("ZSTACK")) {
                if (m.sizeZ <= 1) {
                    m.sizeZ = Integer.parseInt(size.getTextContent());
                }
            } else if (name.equals("TIMELAPSE")) {
                if (m.sizeT <= 1) {
                    m.sizeT = Integer.parseInt(size.getTextContent());
                }
            } else if (name.equals("LAMBDA")) {
                m.sizeC = Integer.parseInt(size.getTextContent());
                m.moduloC.type = "Spectra";
                m.moduloC.start = DataTools.parseDouble(start.getTextContent());
                m.moduloC.step = DataTools.parseDouble(step.getTextContent());
                m.moduloC.end = m.moduloC.start + m.moduloC.step * (double)(m.sizeC - 1);
            } else {
                LOGGER.warn("Unhandled axis '{}'", (Object)name);
            }
        }
    }

    private void parseOriginalMetadata(Node root) {
        String value = root.getNodeValue();
        if (value != null && value.trim().length() > 0) {
            Node grandparent;
            value = value.trim();
            String key = "";
            Node parent = root.getParentNode();
            if (parent != null) {
                String name = parent.getNodeName();
                key = name.substring(name.indexOf(":") + 1);
            }
            if ((grandparent = parent.getParentNode()) != null) {
                String name = grandparent.getNodeName();
                name = name.substring(name.indexOf(":") + 1);
                key = name + " " + key;
            }
            this.addSeriesMetaList(key, value);
        } else {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.parseOriginalMetadata(children.item(i));
            }
        }
    }

    private Element getFirstChild(Element root, String tag) {
        if (root == null || tag == null) {
            return null;
        }
        NodeList list = root.getElementsByTagName(tag);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return (Element)list.item(0);
    }

    private boolean skipPixelBlock(boolean store) throws IOException {
        long offset = this.in.getFilePointer();
        if (offset + 8L >= this.in.length()) {
            return false;
        }
        int checkLength = this.in.readInt();
        int check = this.in.readInt();
        if (check != 3) {
            this.in.seek(offset);
            if (check == 2) {
                this.in.seek(offset + (long)checkLength + 8L);
                return true;
            }
            return false;
        }
        this.in.skipBytes(8);
        int uidLength = this.in.readInt();
        if (checkLength != uidLength + 12) {
            this.in.seek(offset);
            return false;
        }
        String uid = this.in.readString(uidLength);
        if (store) {
            LOGGER.debug("pixel uid = {} @ {}", (Object)uid, (Object)offset);
        }
        if (this.in.getFilePointer() + 4L >= this.in.length()) {
            return false;
        }
        int pixelBytes = this.in.readInt();
        this.in.skipBytes(4);
        if (store && pixelBytes > 0) {
            PixelBlock block = new PixelBlock();
            block.offset = offset;
            block.length = pixelBytes;
            this.pixelBlocks.put(uid, block);
            int blockIndex = Integer.parseInt(uid.substring(uid.lastIndexOf("_") + 1));
            if (blockIndex >= this.blocksPerPlane) {
                this.blocksPerPlane = blockIndex + 1;
            }
            LOGGER.debug("added pixel block @ {}, size = {}", (Object)offset, (Object)this.pixelBlocks.size());
        } else if (pixelBytes <= 0) {
            return false;
        }
        this.in.skipBytes(pixelBytes);
        return true;
    }

    private byte[] readPixelBlock(long offset) throws IOException {
        this.in.seek(offset);
        int checkLength = this.in.readInt();
        int check = this.in.readInt();
        if (check != 3) {
            this.in.seek(offset);
            return null;
        }
        this.in.skipBytes(8);
        int uidLength = this.in.readInt();
        String uid = this.in.readString(uidLength);
        LOGGER.debug("reading pixel block with uid = {}", (Object)uid);
        if (checkLength != uidLength + 12) {
            this.in.seek(offset);
            return null;
        }
        int pixelBytes = this.in.readInt();
        this.in.skipBytes(4);
        byte[] pixels = new byte[pixelBytes];
        this.in.readFully(pixels);
        return pixels;
    }

    class PixelBlock {
        public long offset;
        public int length;

        PixelBlock() {
        }
    }

    class Objective {
        public String name;
        public Double magnification;
        public Double na;
        public Double wd;
        public Double ri;
        public Immersion immersion;

        Objective() {
        }
    }

    class Detector {
        public String id;
        public String channelId;
        public Double voltage;
        public Double offset;
        public Double gain;

        Detector() {
        }
    }

    class Laser {
        public String id;
        public String dataId;
        public String name;
        public Double power;
        public Double transmissivity;
        public Double wavelength;

        Laser() {
        }
    }

    class Channel {
        public String id;
        public String name;
        public int laserIndex = -1;
        public Object lut;
        public Color color;
        public Length pinhole;
        public Length excitation;
        public Length emission;

        Channel() {
        }
    }
}

