/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.common.services.ServiceException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.JPEGTileDecoder;
import loci.formats.in.JPEGReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.JPEGTurboService;
import loci.formats.services.JPEGTurboServiceImpl;
import ome.units.quantity.Length;

public class HamamatsuVMSReader
extends FormatReader {
    private static final int MAX_JPEG_SIZE = 61440;
    private static final int MAX_SIZE = 2048;
    private int initializedSeries = -1;
    private int initializedPlane = -1;
    private String initializedFile = null;
    private ArrayList<String> files = new ArrayList();
    private String[][][] tileFiles;
    private JPEGTurboService service;
    private HashMap<String, long[]> restartMarkers = new HashMap();
    private String macroFile;
    private String mapFile;
    private int nRows;
    private int nCols;

    public HamamatsuVMSReader() {
        super("Hamamatsu VMS", "vms");
        this.domains = new String[]{"Histology"};
        this.datasetDescription = "One .vms file plus several .jpg files";
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return 1024;
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return 1024;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        ArrayList<String> f = new ArrayList<String>();
        f.add(this.currentId);
        f.addAll(this.files);
        return f.toArray(new String[f.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int startCol = x / 61440;
        int startRow = y / 61440;
        String file2 = null;
        switch (this.getCoreIndex()) {
            case 0: {
                file2 = this.tileFiles[no][startRow][startCol];
                break;
            }
            case 1: {
                file2 = this.macroFile;
                break;
            }
            case 2: {
                file2 = this.mapFile;
            }
        }
        if (this.getSizeX() <= 2048 || this.getSizeY() <= 2048) {
            JPEGReader reader = new JPEGReader();
            reader.setId(file2);
            reader.openBytes(0, buf, x, y, w, h);
            reader.close();
            return buf;
        }
        if (this.service == null) {
            this.service = new JPEGTurboServiceImpl();
        }
        try {
            Region image = new Region(x, y, w, h);
            for (int row = startRow; row < this.nRows; ++row) {
                for (int col = startCol; col < this.nCols; ++col) {
                    Region tile = new Region(col * 61440, row * 61440, col == this.nCols - 1 ? this.getSizeX() % 61440 : 61440, row == this.nRows - 1 ? this.getSizeY() % 61440 : 61440);
                    if (!tile.intersects(image)) continue;
                    file2 = this.tileFiles[no][row][col];
                    if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no || !file2.equals(this.initializedFile)) {
                        this.service.close();
                        if (this.restartMarkers.containsKey(file2)) {
                            this.service.setRestartMarkers(this.restartMarkers.get(file2));
                        } else {
                            this.service.setRestartMarkers(null);
                        }
                        RandomAccessInputStream s = new RandomAccessInputStream(file2);
                        this.service.initialize(s, tile.width, tile.height);
                        this.restartMarkers.put(file2, this.service.getRestartMarkers());
                        this.initializedSeries = this.getCoreIndex();
                        this.initializedPlane = no;
                        this.initializedFile = file2;
                    }
                    Region intersection = tile.intersection(image);
                    int tileX = intersection.x % 61440;
                    int tileY = intersection.y % 61440;
                    int rowLen = intersection.width * this.getRGBChannelCount();
                    byte[] b = new byte[rowLen * intersection.height];
                    this.service.getTile(b, tileX, tileY, intersection.width, intersection.height);
                    for (int tileRow = 0; tileRow < intersection.height; ++tileRow) {
                        int src = tileRow * rowLen;
                        int dest = ((intersection.y + tileRow - y) * w + (intersection.x - x)) * this.getRGBChannelCount();
                        System.arraycopy(b, src, buf, dest, rowLen);
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tileFiles = null;
            this.files.clear();
            if (this.service != null) {
                this.service.close();
                this.service = null;
            }
            this.restartMarkers.clear();
            this.initializedSeries = -1;
            this.initializedPlane = -1;
            this.nRows = 0;
            this.nCols = 0;
            this.initializedFile = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        IniParser parser = new IniParser();
        IniList layout = parser.parseINI(new BufferedReader(new InputStreamReader((InputStream)this.in, "UTF-8")));
        IniTable slideInfo = layout.getTable("Virtual Microscope Specimen");
        int nLayers = Integer.parseInt((String)slideInfo.get("NoLayers"));
        this.nRows = Integer.parseInt((String)slideInfo.get("NoJpegRows"));
        this.nCols = Integer.parseInt((String)slideInfo.get("NoJpegColumns"));
        String imageFile = (String)slideInfo.get("ImageFile");
        this.mapFile = (String)slideInfo.get("MapFile");
        String optimisationFile = (String)slideInfo.get("OptimisationFile");
        this.macroFile = (String)slideInfo.get("MacroImage");
        Double physicalWidth = new Double((String)slideInfo.get("PhysicalWidth"));
        Double physicalHeight = new Double((String)slideInfo.get("PhysicalHeight"));
        Double magnification = new Double((String)slideInfo.get("SourceLens"));
        Double macroWidth = new Double((String)slideInfo.get("PhysicalMacroWidth"));
        Double macroHeight = new Double((String)slideInfo.get("PhysicalMacroHeight"));
        for (String key : slideInfo.keySet()) {
            this.addGlobalMeta(key, slideInfo.get(key));
        }
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        if (imageFile != null) {
            imageFile = new Location(dir, imageFile).getAbsolutePath();
            this.files.add(imageFile);
        }
        this.tileFiles = new String[nLayers][this.nRows][this.nCols];
        this.tileFiles[0][0][0] = imageFile;
        for (int layer = 0; layer < nLayers; ++layer) {
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nCols; ++col) {
                    String f = (String)slideInfo.get("ImageFile(" + col + "," + row + ")");
                    if (f == null) continue;
                    this.tileFiles[layer][row][col] = f = new Location(dir, f).getAbsolutePath();
                    this.files.add(f);
                }
            }
        }
        if (this.mapFile != null) {
            this.mapFile = new Location(dir, this.mapFile).getAbsolutePath();
            this.files.add(this.mapFile);
        }
        if (optimisationFile != null) {
            optimisationFile = new Location(dir, optimisationFile).getAbsolutePath();
            this.files.add(optimisationFile);
        }
        if (this.macroFile != null) {
            this.macroFile = new Location(dir, this.macroFile).getAbsolutePath();
            this.files.add(this.macroFile);
        }
        int seriesCount = 3;
        this.core.clear();
        for (int i = 0; i < seriesCount; ++i) {
            int[] dims;
            String file2 = null;
            switch (i) {
                case 0: {
                    file2 = this.tileFiles[0][this.nRows - 1][this.nCols - 1];
                    break;
                }
                case 1: {
                    file2 = this.macroFile;
                    break;
                }
                case 2: {
                    file2 = this.mapFile;
                }
            }
            try (RandomAccessInputStream s = new RandomAccessInputStream(file2);
                 JPEGTileDecoder decoder = new JPEGTileDecoder();){
                dims = decoder.preprocess(s);
            }
            CoreMetadata m = new CoreMetadata();
            if (i == 0) {
                m.sizeX = 61440 * (this.nCols - 1) + dims[0];
                m.sizeY = 61440 * (this.nRows - 1) + dims[1];
            } else {
                m.sizeX = dims[0];
                m.sizeY = dims[1];
            }
            m.sizeZ = 1;
            m.sizeC = 3;
            m.sizeT = 1;
            m.rgb = true;
            m.imageCount = 1;
            m.dimensionOrder = "XYCZT";
            m.pixelType = 1;
            m.interleaved = m.sizeX > 2048 && m.sizeY > 2048;
            m.thumbnail = i > 0;
            this.core.add(m);
        }
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String path = new Location(this.currentId).getAbsoluteFile().getName();
        store.setImageName(path + " full resolution", 0);
        store.setImageName(path + " macro", 1);
        store.setImageName(path + " map", 2);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX(physicalWidth / (double)ms0.sizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(physicalHeight / (double)ms0.sizeY);
            Length macroSizeX = FormatTools.getPhysicalSizeX(macroWidth / (double)((CoreMetadata)this.core.get((int)1)).sizeX);
            Length macroSizeY = FormatTools.getPhysicalSizeY(macroHeight / (double)((CoreMetadata)this.core.get((int)1)).sizeY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (macroSizeX != null) {
                store.setPixelsPhysicalSizeX(macroSizeX, 1);
            }
            if (macroSizeY != null) {
                store.setPixelsPhysicalSizeY(macroSizeY, 1);
            }
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveNominalMagnification(magnification, 0, 0);
            store.setObjectiveSettingsID(objectiveID, 0);
        }
    }
}

