/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Frame;

public class MeasurementsWriter
implements PlugIn {
    @Override
    public void run(String path) {
        this.save(path);
    }

    public boolean save(String path) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow && !"Log".equals(frame.getTitle())) {
            TextWindow tw = (TextWindow)frame;
            return tw.getTextPanel().saveAs(path);
        }
        if (IJ.isResultsWindow()) {
            TextPanel tp = IJ.getTextPanel();
            return tp == null || tp.saveAs(path);
        }
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt == null || rt.getCounter() == 0) {
            frame = WindowManager.getFrame("Results");
            if (frame == null || !(frame instanceof TextWindow)) {
                return false;
            }
            TextWindow tw = (TextWindow)frame;
            return tw.getTextPanel().saveAs(path);
        }
        if (path.equals("")) {
            SaveDialog sd = new SaveDialog("Save as Text", "Results", Prefs.defaultResultsExtension());
            String file2 = sd.getFileName();
            if (file2 == null) {
                return false;
            }
            path = sd.getDirectory() + file2;
        }
        return rt.save(path);
    }
}

