/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class JavaScriptEvaluator
implements PlugIn,
Runnable {
    private Thread thread;
    private String script;
    private Object result;

    @Override
    public void run(String script) {
        if (script.equals("")) {
            return;
        }
        if (!IJ.isJava16()) {
            IJ.error("Java 1.6 or later required");
            return;
        }
        this.script = script;
        this.thread = new Thread((Runnable)this, "JavaScript");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public String run(String script, String arg) {
        this.script = script;
        this.run();
        return null;
    }

    @Override
    public void run() {
        block7: {
            this.result = null;
            Thread.currentThread().setContextClassLoader(IJ.getClassLoader());
            try {
                ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                ScriptEngine engine = scriptEngineManager.getEngineByName("ECMAScript");
                if (engine == null) {
                    IJ.error("Could not find JavaScript engine");
                    return;
                }
                if (!IJ.isJava18()) {
                    engine.eval("function load(path) {\n  importClass(Packages.sun.org.mozilla.javascript.internal.Context);\n  importClass(Packages.java.io.FileReader);\n  var cx = Context.getCurrentContext();\n  cx.evaluateReader(this, new FileReader(path), path, 1, null);\n}");
                }
                this.result = engine.eval(this.script);
            }
            catch (Throwable e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "";
                }
                if (msg.startsWith("sun.org.mozilla.javascript.internal.EcmaError: ")) {
                    msg = msg.substring(47, msg.length());
                }
                if (msg.startsWith("sun.org.mozilla.javascript.internal.EvaluatorException")) {
                    msg = "Error" + msg.substring(54, msg.length());
                }
                if (msg.length() <= 0 || msg.contains("Macro canceled")) break block7;
                IJ.log(msg);
            }
        }
    }

    public String toString() {
        return this.result != null ? "" + this.result : "";
    }
}

