/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.Random;

public class Grid
implements PlugIn,
DialogListener {
    private static final String OPTIONS = "grid.options";
    private static final String GRID = "|GRID|";
    private static double crossSize = 0.1;
    private static String[] colors = new String[]{"Red", "Green", "Blue", "Magenta", "Cyan", "Yellow", "Orange", "Black", "White"};
    private static final int LINES = 0;
    private static final int HLINES = 1;
    private static final int CROSSES = 2;
    private static final int POINTS = 3;
    private static final int CIRCLES = 4;
    private static final int NONE = 4;
    private static String[] types = new String[]{"Lines", "Horizontal Lines", "Crosses", "Points", "Circles", "None"};
    private Random random = new Random(System.currentTimeMillis());
    private ImagePlus imp;
    private double tileWidth;
    private double tileHeight;
    private int xstart;
    private int ystart;
    private int linesV;
    private int linesH;
    private double pixelWidth = 1.0;
    private double pixelHeight = 1.0;
    private String units = "pixels";
    private boolean isMacro;
    private Roi gridOnEntry;
    private String type = types[0];
    private double areaPerPoint;
    private static double saveAreaPerPoint;
    private String color = "Cyan";
    private boolean bold;
    private boolean randomOffset;

    @Override
    public void run(String arg) {
        int index;
        this.imp = IJ.getImage();
        Overlay overlay = this.imp.getOverlay();
        int n = index = overlay != null ? overlay.getIndex(GRID) : -1;
        if (index >= 0) {
            this.gridOnEntry = overlay.get(index);
        }
        if (this.showDialog() && !this.isMacro) {
            this.saveSettings();
        }
    }

    private void drawCircles(double size) {
        double R = size * this.tileWidth;
        if (R < 1.0) {
            R = 1.0;
        }
        if (this.bold && this.type.equals(types[3])) {
            R *= 1.5;
        }
        double kappa = 0.5522847771644592;
        GeneralPath path = new GeneralPath();
        for (int h = 0; h < this.linesV; ++h) {
            for (int v = 0; v < this.linesH; ++v) {
                double x = (double)this.xstart + (double)h * this.tileWidth;
                double y = (double)this.ystart + (double)v * this.tileHeight;
                path.moveTo(x, y - R);
                path.curveTo(x + R * kappa, y - R, x + R, y - R * kappa, x + R, y);
                path.curveTo(x + R, y + R * kappa, x + R * kappa, y + R, x, y + R);
                path.curveTo(x - R * kappa, y + R, x - R, y + R * kappa, x - R, y);
                path.curveTo(x - R, y - R * kappa, x - R * kappa, y - R, x, y - R);
                path.closePath();
            }
        }
        this.drawGrid(path);
    }

    private void drawCrosses() {
        GeneralPath path = new GeneralPath();
        double arm = crossSize * this.tileWidth;
        if (arm < 3.0) {
            arm = 3.0;
        }
        for (int h = 0; h < this.linesV; ++h) {
            for (int v = 0; v < this.linesH; ++v) {
                double x = (double)this.xstart + (double)h * this.tileWidth;
                double y = (double)this.ystart + (double)v * this.tileHeight;
                path.moveTo(x - arm, y);
                path.lineTo(x + arm, y);
                path.moveTo(x, y - arm);
                path.lineTo(x, y + arm);
            }
        }
        this.drawGrid(path);
    }

    private void drawLines() {
        int i;
        GeneralPath path = new GeneralPath();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        for (i = 0; i < this.linesV; ++i) {
            float xoff = (float)((double)this.xstart + (double)i * this.tileWidth);
            path.moveTo(xoff, 0.0f);
            path.lineTo(xoff, height);
        }
        for (i = 0; i < this.linesH; ++i) {
            float yoff = (float)((double)this.ystart + (double)i * this.tileHeight);
            path.moveTo(0.0f, yoff);
            path.lineTo(width, yoff);
        }
        this.drawGrid(path);
    }

    private void drawHorizontalLines() {
        GeneralPath path = new GeneralPath();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        for (int i = 0; i < this.linesH; ++i) {
            float yoff = (float)((double)this.ystart + (double)i * this.tileHeight);
            path.moveTo(0.0f, yoff);
            path.lineTo(width, yoff);
        }
        this.drawGrid(path);
    }

    void drawGrid(Shape shape) {
        if (shape == null) {
            Overlay overlay = this.imp.getOverlay();
            if (overlay != null) {
                if (overlay.size() > 1) {
                    overlay.remove(GRID);
                    this.imp.draw();
                } else {
                    this.imp.setOverlay(null);
                }
            }
        } else {
            ShapeRoi roi = new ShapeRoi(shape);
            roi.setStrokeColor(Colors.getColor(this.color, Color.cyan));
            if (this.bold && this.linesV * this.linesH < 5000) {
                ImageCanvas ic = this.imp.getCanvas();
                double mag = ic != null ? ic.getMagnification() : 1.0;
                double width = 2.0;
                if (mag < 1.0) {
                    width /= mag;
                }
                roi.setStrokeWidth(width);
            }
            IJ.showStatus(this.linesV * this.linesH + " nodes");
            Overlay overlay = this.imp.getOverlay();
            if (overlay != null) {
                overlay.remove(GRID);
            } else {
                overlay = new Overlay();
            }
            overlay.add(roi, GRID);
            this.imp.setOverlay(overlay);
        }
    }

    private boolean showDialog() {
        int places;
        boolean bl = this.isMacro = Macro.getOptions() != null;
        if (!this.isMacro) {
            this.getSettings();
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        Calibration cal = this.imp.getCalibration();
        if (cal.scaled()) {
            this.pixelWidth = cal.pixelWidth;
            this.pixelHeight = cal.pixelHeight;
            this.units = cal.getUnits();
            places = 2;
        } else {
            this.pixelWidth = 1.0;
            this.pixelHeight = 1.0;
            this.units = "pixels";
            places = 0;
        }
        if (this.areaPerPoint == 0.0) {
            this.areaPerPoint = (double)width * cal.pixelWidth * (double)height * cal.pixelHeight / 81.0;
        }
        GenericDialog gd = new GenericDialog("Grid...");
        gd.addChoice("Grid type:", types, this.type);
        gd.addNumericField("Area per point:", this.areaPerPoint, places, 6, this.units + "^2");
        gd.addChoice("Color:", colors, this.color);
        gd.addCheckbox("Bold", this.bold);
        gd.addCheckbox("Random offset", this.randomOffset);
        gd.addDialogListener(this);
        this.dialogItemChanged(gd, null);
        gd.showDialog();
        if (gd.wasCanceled()) {
            Overlay overlay = this.imp.getOverlay();
            if (overlay != null && this.gridOnEntry != null) {
                overlay.remove(GRID);
                overlay.add(this.gridOnEntry);
                this.imp.draw();
            } else {
                this.drawGrid(null);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        this.type = gd.getNextChoice();
        this.areaPerPoint = gd.getNextNumber();
        this.color = gd.getNextChoice();
        this.bold = gd.getNextBoolean();
        this.randomOffset = gd.getNextBoolean();
        double minArea = (double)(width * height) / 50000.0;
        if (this.type.equals(types[2]) && minArea < 50.0) {
            minArea = 50.0;
        } else if (minArea < 16.0) {
            minArea = 16.0;
        }
        if (this.areaPerPoint / (this.pixelWidth * this.pixelHeight) < minArea) {
            String err = "\"Area per Point\" too small";
            if (gd.wasOKed()) {
                IJ.error("Grid", err);
            } else {
                IJ.showStatus(err);
            }
            return true;
        }
        double tileSize = Math.sqrt(this.areaPerPoint);
        this.tileWidth = tileSize / this.pixelWidth;
        this.tileHeight = tileSize / this.pixelHeight;
        if (this.randomOffset) {
            this.xstart = (int)(this.random.nextDouble() * this.tileWidth);
            this.ystart = (int)(this.random.nextDouble() * this.tileHeight);
        } else {
            this.xstart = (int)(this.tileWidth / 2.0 + 0.5);
            this.ystart = (int)(this.tileHeight / 2.0 + 0.5);
        }
        this.linesV = (int)((double)(width - this.xstart) / this.tileWidth) + 1;
        this.linesH = (int)((double)(height - this.ystart) / this.tileHeight) + 1;
        if (gd.invalidNumber()) {
            return true;
        }
        this.drawGrid();
        return true;
    }

    private void drawGrid() {
        if (this.type.equals(types[0])) {
            this.drawLines();
        } else if (this.type.equals(types[1])) {
            this.drawHorizontalLines();
        } else if (this.type.equals(types[2])) {
            this.drawCrosses();
        } else if (this.type.equals(types[3])) {
            this.drawCircles(0.01);
        } else if (this.type.equals(types[4])) {
            this.drawCircles(0.1);
        } else {
            this.drawGrid(null);
        }
    }

    private void getSettings() {
        String prefs = Prefs.get(OPTIONS, "Lines,Cyan,-");
        String[] options = Tools.split(prefs, ",");
        if (options.length >= 3) {
            this.type = options[0];
            if ("None".equals(this.type)) {
                this.type = types[0];
            }
            this.areaPerPoint = saveAreaPerPoint;
            this.color = options[1];
            this.bold = options[2].contains("bold");
            this.randomOffset = options[2].contains("random");
        }
    }

    private void saveSettings() {
        String options = this.type + "," + this.color + "," + (this.bold ? "bold" : "") + " " + (this.randomOffset ? "random" : "");
        Prefs.set(OPTIONS, options);
        saveAreaPerPoint = this.areaPerPoint;
    }
}

