/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.ScrollbarWithLabel;
import ij.plugin.frame.SyncWindows;
import java.awt.EventQueue;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class StackWindow
extends ImageWindow
implements Runnable,
AdjustmentListener,
ActionListener,
MouseWheelListener {
    protected Scrollbar sliceSelector;
    protected ScrollbarWithLabel cSelector;
    protected ScrollbarWithLabel zSelector;
    protected ScrollbarWithLabel tSelector;
    protected Thread thread;
    protected volatile boolean done;
    protected volatile int slice;
    private ScrollbarWithLabel animationSelector;
    boolean hyperStack;
    int nChannels = 1;
    int nSlices = 1;
    int nFrames = 1;
    int c = 1;
    int z = 1;
    int t = 1;

    public StackWindow(ImagePlus imp) {
        this(imp, null);
    }

    public StackWindow(ImagePlus imp, ImageCanvas ic) {
        super(imp, ic);
        this.addScrollbars(imp);
        this.addMouseWheelListener(this);
        if (this.sliceSelector == null && this.getClass().getName().indexOf("Image5D") != -1) {
            this.sliceSelector = new Scrollbar();
        }
        this.pack();
        ic = imp.getCanvas();
        if (ic != null) {
            ic.setMaxBounds();
        }
        this.show();
        int previousSlice = imp.getCurrentSlice();
        if (previousSlice > 1 && previousSlice <= imp.getStackSize()) {
            imp.setSlice(previousSlice);
        } else {
            imp.setSlice(1);
        }
        this.thread = new Thread((Runnable)this, "zSelector");
        this.thread.start();
    }

    void addScrollbars(ImagePlus imp) {
        ImageWindow win;
        ImageStack s = imp.getStack();
        int stackSize = s.getSize();
        int sliderHeight = 0;
        this.nSlices = stackSize;
        this.hyperStack = imp.getOpenAsHyperStack();
        int[] dim = imp.getDimensions();
        int nDimensions = 2 + (dim[2] > 1 ? 1 : 0) + (dim[3] > 1 ? 1 : 0) + (dim[4] > 1 ? 1 : 0);
        if (nDimensions <= 3 && dim[2] != this.nSlices) {
            this.hyperStack = false;
        }
        if (this.hyperStack) {
            this.nChannels = dim[2];
            this.nSlices = dim[3];
            this.nFrames = dim[4];
        }
        if (this.nSlices == stackSize) {
            this.hyperStack = false;
        }
        if (this.nChannels * this.nSlices * this.nFrames != stackSize) {
            this.hyperStack = false;
        }
        if (this.cSelector != null || this.zSelector != null || this.tSelector != null) {
            this.removeScrollbars();
        }
        ImageJ ij = IJ.getInstance();
        if (this.nChannels > 1) {
            this.cSelector = new ScrollbarWithLabel(this, 1, 1, 1, this.nChannels + 1, 'c');
            this.add(this.cSelector);
            sliderHeight += this.cSelector.getPreferredSize().height + 5;
            if (ij != null) {
                this.cSelector.addKeyListener(ij);
            }
            this.cSelector.addAdjustmentListener(this);
            this.cSelector.setFocusable(false);
            this.cSelector.setUnitIncrement(1);
            this.cSelector.setBlockIncrement(1);
        }
        if (this.nSlices > 1) {
            char label;
            char c = label = this.nChannels > 1 || this.nFrames > 1 ? (char)'z' : 't';
            if (stackSize == dim[2] && imp.isComposite()) {
                label = 'c';
            }
            this.zSelector = new ScrollbarWithLabel(this, 1, 1, 1, this.nSlices + 1, label);
            if (label == 't') {
                this.animationSelector = this.zSelector;
            }
            this.add(this.zSelector);
            sliderHeight += this.zSelector.getPreferredSize().height + 5;
            if (ij != null) {
                this.zSelector.addKeyListener(ij);
            }
            this.zSelector.addAdjustmentListener(this);
            this.zSelector.setFocusable(false);
            int blockIncrement = this.nSlices / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.zSelector.setUnitIncrement(1);
            this.zSelector.setBlockIncrement(blockIncrement);
            this.sliceSelector = this.zSelector.bar;
        }
        if (this.nFrames > 1) {
            this.animationSelector = this.tSelector = new ScrollbarWithLabel(this, 1, 1, 1, this.nFrames + 1, 't');
            this.add(this.tSelector);
            sliderHeight += this.tSelector.getPreferredSize().height + 5;
            if (ij != null) {
                this.tSelector.addKeyListener(ij);
            }
            this.tSelector.addAdjustmentListener(this);
            this.tSelector.setFocusable(false);
            int blockIncrement = this.nFrames / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.tSelector.setUnitIncrement(1);
            this.tSelector.setBlockIncrement(blockIncrement);
        }
        if ((win = imp.getWindow()) != null) {
            win.setSliderHeight(sliderHeight);
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.running2 || this.imp.isHyperStack()) {
            if (e.getSource() == this.cSelector) {
                this.c = this.cSelector.getValue();
                if (this.c == this.imp.getChannel() && e.getAdjustmentType() == 5) {
                    return;
                }
            } else if (e.getSource() == this.zSelector) {
                int slice;
                this.z = this.zSelector.getValue();
                int n = slice = this.hyperStack ? this.imp.getSlice() : this.imp.getCurrentSlice();
                if (this.z == slice && e.getAdjustmentType() == 5) {
                    return;
                }
            } else if (e.getSource() == this.tSelector) {
                this.t = this.tSelector.getValue();
                if (this.t == this.imp.getFrame() && e.getAdjustmentType() == 5) {
                    return;
                }
            }
            this.updatePosition();
            this.notify();
        }
        if (!this.running) {
            this.syncWindows(e.getSource());
        }
    }

    private void syncWindows(Object source) {
        if (SyncWindows.getInstance() == null) {
            return;
        }
        if (source == this.cSelector) {
            SyncWindows.setC(this, this.cSelector.getValue());
        } else if (source == this.zSelector) {
            int stackSize = this.imp.getStackSize();
            if (this.imp.getNChannels() == stackSize) {
                SyncWindows.setC(this, this.zSelector.getValue());
            } else if (this.imp.getNFrames() == stackSize) {
                SyncWindows.setT(this, this.zSelector.getValue());
            } else {
                SyncWindows.setZ(this, this.zSelector.getValue());
            }
        } else if (source == this.tSelector) {
            SyncWindows.setT(this, this.tSelector.getValue());
        } else {
            throw new RuntimeException("Unknownsource:" + source);
        }
    }

    void updatePosition() {
        this.slice = (this.t - 1) * this.nChannels * this.nSlices + (this.z - 1) * this.nChannels + this.c;
        this.imp.updatePosition(this.c, this.z, this.t);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            boolean ctrl;
            int rotation = e.getWheelRotation();
            boolean bl = ctrl = (e.getModifiers() & 2) != 0;
            if ((ctrl || IJ.shiftKeyDown()) && this.ic != null) {
                int ox = this.ic.offScreenX(e.getX());
                int oy = this.ic.offScreenY(e.getX());
                if (rotation < 0) {
                    this.ic.zoomIn(ox, oy);
                } else {
                    this.ic.zoomOut(ox, oy);
                }
                return;
            }
            if (this.hyperStack) {
                if (rotation > 0) {
                    IJ.run(this.imp, "Next Slice [>]", "");
                } else if (rotation < 0) {
                    IJ.run(this.imp, "Previous Slice [<]", "");
                }
            } else {
                int slice = this.imp.getCurrentSlice() + rotation;
                if (slice < 1) {
                    slice = 1;
                } else if (slice > this.imp.getStack().getSize()) {
                    slice = this.imp.getStack().getSize();
                }
                this.setSlice(this.imp, slice);
                this.imp.updateStatusbarValue();
                SyncWindows.setZ(this, slice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (!super.close()) {
            return false;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            this.done = true;
            this.notify();
        }
        return true;
    }

    public void showSlice(int index) {
        if (this.imp != null && index >= 1 && index <= this.imp.getStackSize()) {
            this.setSlice(this.imp, index);
            SyncWindows.setZ(this, index);
        }
    }

    public void updateSliceSelector() {
        if (this.hyperStack || this.zSelector == null || this.imp == null) {
            return;
        }
        int stackSize = this.imp.getStackSize();
        int max = this.zSelector.getMaximum();
        if (max != stackSize + 1) {
            this.zSelector.setMaximum(stackSize + 1);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StackWindow.this.imp != null && StackWindow.this.zSelector != null) {
                    StackWindow.this.zSelector.setValue(StackWindow.this.imp.getCurrentSlice());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            StackWindow stackWindow = this;
            synchronized (stackWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0) continue;
            int s = this.slice;
            this.slice = 0;
            if (s == this.imp.getCurrentSlice()) continue;
            this.setSlice(this.imp, s);
        }
    }

    @Override
    public String createSubtitle() {
        String subtitle = super.createSubtitle();
        if (!this.hyperStack) {
            return subtitle;
        }
        String s = "";
        int[] dim = this.imp.getDimensions(false);
        int channels = dim[2];
        int slices = dim[3];
        int frames = dim[4];
        if (channels > 1) {
            s = s + "c:" + this.imp.getChannel() + "/" + channels;
            if (slices > 1 || frames > 1) {
                s = s + " ";
            }
        }
        if (slices > 1) {
            s = s + "z:" + this.imp.getSlice() + "/" + slices;
            if (frames > 1) {
                s = s + " ";
            }
        }
        if (frames > 1) {
            s = s + "t:" + this.imp.getFrame() + "/" + frames;
        }
        if (this.running2) {
            return s;
        }
        int index = subtitle.indexOf(";");
        if (index != -1) {
            int index2 = subtitle.indexOf("(");
            if (index2 >= 0 && index2 < index && subtitle.length() > index2 + 4 && !subtitle.substring(index2 + 1, index2 + 4).equals("ch:")) {
                index = index2;
                s = s + " ";
            }
            subtitle = subtitle.substring(index, subtitle.length());
        } else {
            subtitle = "";
        }
        return s + subtitle;
    }

    public boolean isHyperStack() {
        return this.hyperStack && this.getNScrollbars() > 0;
    }

    public void setPosition(int channel, int slice, int frame) {
        if (this.cSelector != null && channel != this.c) {
            this.c = channel;
            this.cSelector.setValue(channel);
            SyncWindows.setC(this, channel);
        }
        if (this.zSelector != null && slice != this.z) {
            this.z = slice;
            this.zSelector.setValue(slice);
            SyncWindows.setZ(this, slice);
        }
        if (this.tSelector != null && frame != this.t) {
            this.t = frame;
            this.tSelector.setValue(frame);
            SyncWindows.setT(this, frame);
        }
        this.updatePosition();
        if (this.slice > 0) {
            int s = this.slice;
            this.slice = 0;
            if (s != this.imp.getCurrentSlice()) {
                this.imp.setSlice(s);
            }
        }
    }

    private void setSlice(ImagePlus imp, int n) {
        if (imp.isLocked()) {
            IJ.beep();
            IJ.showStatus("Image is locked");
        } else {
            imp.setSlice(n);
        }
    }

    public boolean validDimensions() {
        int c = this.imp.getNChannels();
        int z = this.imp.getNSlices();
        int t = this.imp.getNFrames();
        int size = this.imp.getStackSize();
        if (c == size && c * z * t == size && this.nSlices == size && this.nChannels * this.nSlices * this.nFrames == size) {
            return true;
        }
        return c == this.nChannels && z == this.nSlices && t == this.nFrames && c * z * t == size;
    }

    public void setAnimate(boolean b) {
        if (this.running2 != b && this.animationSelector != null) {
            this.animationSelector.updatePlayPauseIcon();
        }
        this.running2 = b;
    }

    public boolean getAnimate() {
        return this.running2;
    }

    public int getNScrollbars() {
        int n = 0;
        if (this.cSelector != null) {
            ++n;
        }
        if (this.zSelector != null) {
            ++n;
        }
        if (this.tSelector != null) {
            ++n;
        }
        return n;
    }

    void removeScrollbars() {
        if (this.cSelector != null) {
            this.remove(this.cSelector);
            this.cSelector.removeAdjustmentListener(this);
            this.cSelector = null;
        }
        if (this.zSelector != null) {
            this.remove(this.zSelector);
            this.zSelector.removeAdjustmentListener(this);
            this.zSelector = null;
        }
        if (this.tSelector != null) {
            this.remove(this.tSelector);
            this.tSelector.removeAdjustmentListener(this);
            this.tSelector = null;
        }
    }
}

