/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVReadProc;
import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVRuntimeException;
import au.com.bytecode.opencsv.CSVWriteProc;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class CSV {
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final Charset charset;
    private final String lineEnd;
    private final int skipLines;
    private final boolean strictQuotes;
    private final boolean ignoreLeadingWhiteSpace;

    private CSV(char separator, char quotechar, char escapechar, String lineEnd, int skipLines, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, Charset charset) {
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
        this.skipLines = skipLines;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.charset = charset;
    }

    private CSV() {
        this(',', '\"', '\\', "\n", 0, false, true, Charset.defaultCharset());
    }

    public CSVWriter writer(Writer writer) {
        return new CSVWriter(writer, this.separator, this.quotechar, this.escapechar, this.lineEnd);
    }

    public CSVWriter writer(OutputStream os) {
        return this.writer(new OutputStreamWriter(os, this.charset));
    }

    public CSVWriter writer(File file2) {
        try {
            return this.writer(new FileOutputStream(file2));
        }
        catch (FileNotFoundException e) {
            throw new CSVRuntimeException(e);
        }
    }

    public CSVWriter writer(String fileName) {
        return this.writer(new File(fileName));
    }

    public void write(Writer writer, CSVWriteProc proc) {
        this.write(this.writer(writer), proc);
    }

    public void write(OutputStream os, CSVWriteProc proc) {
        this.write(this.writer(os), proc);
    }

    public void write(String fileName, CSVWriteProc proc) {
        this.write(new File(fileName), proc);
    }

    public void write(CSVWriter writer, CSVWriteProc proc) {
        try {
            writer.write(proc);
            writer.flush();
        }
        catch (IOException e) {
            throw new CSVRuntimeException(e);
        }
    }

    public void write(File file2, CSVWriteProc proc) {
        this.writeAndClose(this.writer(file2), proc);
    }

    public void writeAndClose(Writer writer, CSVWriteProc proc) {
        this.writeAndClose(this.writer(writer), proc);
    }

    public void writeAndClose(OutputStream os, CSVWriteProc proc) {
        this.writeAndClose(this.writer(os), proc);
    }

    public void writeAndClose(CSVWriter writer, CSVWriteProc proc) {
        try {
            writer.write(proc);
        }
        catch (RuntimeException re) {
            try {
                writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw re;
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new CSVRuntimeException(e);
        }
    }

    public CSVReader reader(Reader reader) {
        return new CSVReader(reader, this.separator, this.quotechar, this.escapechar, this.skipLines, this.strictQuotes, this.ignoreLeadingWhiteSpace);
    }

    public CSVReader reader(InputStream is) {
        return this.reader(new InputStreamReader(is, this.charset));
    }

    public CSVReader reader(File file2) {
        try {
            return this.reader(new FileInputStream(file2));
        }
        catch (IOException e) {
            throw new CSVRuntimeException(e);
        }
    }

    public CSVReader reader(String fileName) {
        return this.reader(new File(fileName));
    }

    public void read(InputStream is, CSVReadProc proc) {
        this.read(this.reader(is), proc);
    }

    public void read(Reader reader, CSVReadProc proc) {
        this.read(this.reader(reader), proc);
    }

    public void read(File file2, CSVReadProc proc) {
        this.readAndClose(this.reader(file2), proc);
    }

    public void read(String fileName, CSVReadProc proc) {
        this.read(new File(fileName), proc);
    }

    public void read(CSVReader reader, CSVReadProc proc) {
        reader.read(proc);
    }

    public void readAndClose(InputStream is, CSVReadProc proc) {
        this.readAndClose(this.reader(is), proc);
    }

    public void readAndClose(Reader reader, CSVReadProc proc) {
        this.readAndClose(this.reader(reader), proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndClose(CSVReader reader, CSVReadProc proc) {
        try {
            this.read(reader, proc);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static CSV create() {
        return new CSV();
    }

    public static Builder separator(char separator) {
        return new Builder().separator(separator);
    }

    public static Builder quote(char quoteChar) {
        return new Builder().quote(quoteChar);
    }

    public static Builder noQuote() {
        return new Builder().noQuote();
    }

    public static Builder escape(char escapeChar) {
        return new Builder().escape(escapeChar);
    }

    public static Builder noEscape() {
        return new Builder().noEscape();
    }

    public static Builder lineEnd(String lineEnd) {
        return new Builder().lineEnd(lineEnd);
    }

    public static Builder skipLines(int skipLines) {
        return new Builder().skipLines(skipLines);
    }

    public static Builder strictQuotes() {
        return new Builder().strictQuotes();
    }

    public static Builder notStrictQuotes() {
        return new Builder().notStrictQuotes();
    }

    public static Builder ignoreLeadingWhiteSpace() {
        return new Builder().ignoreLeadingWhiteSpace();
    }

    public static Builder notIgnoreLeadingWhiteSpace() {
        return new Builder().notIgnoreLeadingWhiteSpace();
    }

    public static Builder charset(Charset charset) {
        return new Builder().charset(charset);
    }

    public static Builder charset(String charsetName) {
        return new Builder().charset(charsetName);
    }

    public static class Builder {
        private final CSV csv;

        private Builder() {
            this.csv = new CSV();
        }

        private Builder(CSV csv) {
            this.csv = csv;
        }

        public CSV create() {
            return this.csv;
        }

        public Builder separator(char separator) {
            return new Builder(new CSV(separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder quote(char quoteChar) {
            return new Builder(new CSV(this.csv.separator, quoteChar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder escape(char escapeChar) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, escapeChar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder lineEnd(String lineEnd) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder skipLines(int skipLines) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        private Builder setStrictQuotes(boolean strictQuotes) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        private Builder setIgnoreLeadingWhiteSpace(boolean ignoreLeadingWhiteSpace) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder charset(Charset charset) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, charset));
        }

        public Builder noQuote() {
            return this.quote('\u0000');
        }

        public Builder noEscape() {
            return this.escape('\u0000');
        }

        public Builder strictQuotes() {
            return this.setStrictQuotes(true);
        }

        public Builder notStrictQuotes() {
            return this.setStrictQuotes(false);
        }

        public Builder ignoreLeadingWhiteSpace() {
            return this.setIgnoreLeadingWhiteSpace(true);
        }

        public Builder notIgnoreLeadingWhiteSpace() {
            return this.setIgnoreLeadingWhiteSpace(false);
        }

        public Builder charset(String charsetName) {
            return this.charset(Charset.forName(charsetName));
        }
    }
}

