/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.Exception;
import Ice.LocalException;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.SystemException;
import Ice.UnknownException;
import IceInternal.BasicStream;
import IceInternal.DispatchWorkItem;
import IceInternal.Incoming;
import IceInternal.OutgoingAsync;
import IceInternal.OutgoingAsyncBase;
import IceInternal.Protocol;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.ResponseHandler;
import IceInternal.ServantError;
import IceInternal.ServantManager;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class CollocatedRequestHandler
implements RequestHandler,
ResponseHandler {
    private final Reference _reference;
    private final boolean _dispatcher;
    private final boolean _response;
    private final ObjectAdapterI _adapter;
    private final Logger _logger;
    private final TraceLevels _traceLevels;
    private int _requestId;
    private Map<OutgoingAsyncBase, Integer> _sendAsyncRequests = new HashMap<OutgoingAsyncBase, Integer>();
    private Map<Integer, OutgoingAsyncBase> _asyncRequests = new HashMap<Integer, OutgoingAsyncBase>();

    public CollocatedRequestHandler(Reference ref, ObjectAdapter adapter) {
        this._reference = ref;
        this._dispatcher = ref.getInstance().initializationData().dispatcher != null;
        this._adapter = (ObjectAdapterI)adapter;
        this._response = this._reference.getMode() == 0;
        this._logger = this._reference.getInstance().initializationData().logger;
        this._traceLevels = this._reference.getInstance().traceLevels();
        this._requestId = 0;
    }

    @Override
    public RequestHandler update(RequestHandler previousHandler, RequestHandler newHandler) {
        return previousHandler == this ? newHandler : this;
    }

    @Override
    public int sendAsyncRequest(ProxyOutgoingAsyncBase outAsync) {
        return outAsync.invokeCollocated(this);
    }

    @Override
    public synchronized void asyncRequestCanceled(OutgoingAsyncBase outAsync, LocalException ex) {
        Integer requestId = this._sendAsyncRequests.remove(outAsync);
        if (requestId != null) {
            if (requestId > 0) {
                this._asyncRequests.remove(requestId);
            }
            if (outAsync.completed(ex)) {
                outAsync.invokeCompletedAsync();
            }
            this._adapter.decDirectCount();
            return;
        }
        if (outAsync instanceof OutgoingAsync) {
            OutgoingAsync o = (OutgoingAsync)outAsync;
            assert (o != null);
            for (Map.Entry<Integer, OutgoingAsyncBase> e : this._asyncRequests.entrySet()) {
                if (e.getValue() != o) continue;
                this._asyncRequests.remove(e.getKey());
                if (outAsync.completed(ex)) {
                    outAsync.invokeCompletedAsync();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(int requestId, BasicStream os, byte status, boolean amd) {
        OutgoingAsyncBase outAsync = null;
        CollocatedRequestHandler collocatedRequestHandler = this;
        synchronized (collocatedRequestHandler) {
            assert (this._response);
            os.pos(Protocol.replyHdr.length + 4);
            if (this._traceLevels.protocol >= 1) {
                this.fillInValue(os, 10, os.size());
                TraceUtil.traceRecv(os, this._logger, this._traceLevels);
            }
            if ((outAsync = this._asyncRequests.remove(requestId)) != null && !outAsync.completed(os)) {
                outAsync = null;
            }
        }
        if (outAsync != null) {
            if (amd) {
                outAsync.invokeCompletedAsync();
            } else {
                outAsync.invokeCompleted();
            }
        }
        this._adapter.decDirectCount();
    }

    @Override
    public void sendNoResponse() {
        this._adapter.decDirectCount();
    }

    @Override
    public boolean systemException(int requestId, SystemException ex, boolean amd) {
        this.handleException(requestId, ex, amd);
        this._adapter.decDirectCount();
        return true;
    }

    @Override
    public void invokeException(int requestId, LocalException ex, int batchRequestNum, boolean amd) {
        this.handleException(requestId, ex, amd);
        this._adapter.decDirectCount();
    }

    @Override
    public Reference getReference() {
        return this._reference;
    }

    @Override
    public ConnectionI getConnection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int invokeAsyncRequest(OutgoingAsyncBase outAsync, int batchRequestNum, boolean synchronous) {
        this._adapter.incDirectCount();
        int requestId = 0;
        try {
            CollocatedRequestHandler collocatedRequestHandler = this;
            synchronized (collocatedRequestHandler) {
                outAsync.cancelable(this);
                if (this._response) {
                    requestId = ++this._requestId;
                    this._asyncRequests.put(requestId, outAsync);
                }
                this._sendAsyncRequests.put(outAsync, requestId);
            }
        }
        catch (java.lang.Exception ex) {
            this._adapter.decDirectCount();
            throw ex;
        }
        outAsync.attachCollocatedObserver(this._adapter, requestId);
        if (synchronous) {
            if (!this._response || this._reference.getInstance().queueRequests() || this._reference.getInvocationTimeout() > 0) {
                this._adapter.getThreadPool().dispatch(new InvokeAllAsync(outAsync, outAsync.getOs(), requestId, batchRequestNum));
            } else if (this._dispatcher) {
                this._adapter.getThreadPool().dispatchFromThisThread(new InvokeAllAsync(outAsync, outAsync.getOs(), requestId, batchRequestNum));
            } else if (this.sentAsync(outAsync)) {
                this.invokeAll(outAsync.getOs(), requestId, batchRequestNum);
            }
        } else {
            this._adapter.getThreadPool().dispatch(new InvokeAllAsync(outAsync, outAsync.getOs(), requestId, batchRequestNum));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sentAsync(OutgoingAsyncBase outAsync) {
        CollocatedRequestHandler collocatedRequestHandler = this;
        synchronized (collocatedRequestHandler) {
            if (this._sendAsyncRequests.remove(outAsync) == null) {
                return false;
            }
            if (!outAsync.sent()) {
                return true;
            }
        }
        outAsync.invokeSent();
        return true;
    }

    private void invokeAll(BasicStream os, int requestId, int batchRequestNum) {
        block14: {
            int invokeNum;
            if (batchRequestNum > 0) {
                os.pos(Protocol.requestBatchHdr.length);
            } else {
                os.pos(Protocol.requestHdr.length);
            }
            if (this._traceLevels.protocol >= 1) {
                this.fillInValue(os, 10, os.size());
                if (requestId > 0) {
                    this.fillInValue(os, 14, requestId);
                } else if (batchRequestNum > 0) {
                    this.fillInValue(os, 14, batchRequestNum);
                }
                TraceUtil.traceSend(os, this._logger, this._traceLevels);
            }
            ServantManager servantManager = this._adapter.getServantManager();
            try {
                for (invokeNum = batchRequestNum > 0 ? batchRequestNum : 1; invokeNum > 0; --invokeNum) {
                    try {
                        this._adapter.incDirectCount();
                    }
                    catch (ObjectAdapterDeactivatedException ex) {
                        this.handleException(requestId, ex, false);
                        break;
                    }
                    Incoming in = new Incoming(this._reference.getInstance(), this, null, this._adapter, this._response, 0, requestId);
                    in.invoke(servantManager, os);
                }
            }
            catch (LocalException ex) {
                this.invokeException(requestId, ex, invokeNum, false);
            }
            catch (ServantError ex) {
                Throwable t = ex.getCause();
                if (!(t instanceof AssertionError) && !(t instanceof OutOfMemoryError)) {
                    throw (Error)t;
                }
            }
            catch (Error ex) {
                UnknownException uex = new UnknownException(ex);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                uex.unknown = sw.toString();
                this._logger.error(uex.unknown);
                this.invokeException(requestId, uex, invokeNum, false);
                if (ex instanceof AssertionError || ex instanceof OutOfMemoryError) break block14;
                throw ex;
            }
        }
        this._adapter.decDirectCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(int requestId, Exception ex, boolean amd) {
        if (requestId == 0) {
            return;
        }
        OutgoingAsyncBase outAsync = null;
        CollocatedRequestHandler collocatedRequestHandler = this;
        synchronized (collocatedRequestHandler) {
            outAsync = this._asyncRequests.remove(requestId);
            if (outAsync != null && !outAsync.completed(ex)) {
                outAsync = null;
            }
        }
        if (outAsync != null) {
            if (amd) {
                outAsync.invokeCompletedAsync();
            } else {
                outAsync.invokeCompleted();
            }
        }
    }

    private void fillInValue(BasicStream os, int pos, int value) {
        os.rewriteInt(value, pos);
    }

    private class InvokeAllAsync
    extends DispatchWorkItem {
        private final OutgoingAsyncBase _outAsync;
        private BasicStream _os;
        private final int _requestId;
        private final int _batchRequestNum;

        private InvokeAllAsync(OutgoingAsyncBase outAsync, BasicStream os, int requestId, int batchRequestNum) {
            this._outAsync = outAsync;
            this._os = os;
            this._requestId = requestId;
            this._batchRequestNum = batchRequestNum;
        }

        @Override
        public void run() {
            if (CollocatedRequestHandler.this.sentAsync(this._outAsync)) {
                CollocatedRequestHandler.this.invokeAll(this._os, this._requestId, this._batchRequestNum);
            }
        }
    }
}

