/*
 * Decompiled with CFR 0.152.
 */
package Glacier2;

import Glacier2.RouterPrx;
import Glacier2.RouterPrxHelper;
import Glacier2.SessionNotExistException;
import Glacier2.SessionPrx;
import Ice.ACMHeartbeat;
import Ice.Connection;
import Ice.ConnectionCallback;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.Holder;
import Ice.Identity;
import Ice.InitializationData;
import Ice.IntOptional;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.OperationNotExistException;
import Ice.Optional;
import Ice.RequestFailedException;
import Ice.SignalPolicy;
import Ice.StringSeqHolder;
import Ice.TimeoutException;
import Ice.UnknownLocalException;
import Ice.Util;
import IceInternal.Ex;
import java.util.UUID;

public abstract class Application
extends Ice.Application {
    private static ObjectAdapter _adapter;
    private static RouterPrx _router;
    private static SessionPrx _session;
    private static boolean _createdSession;
    private static String _category;

    public Application() {
    }

    public Application(SignalPolicy signalPolicy) {
        super(signalPolicy);
    }

    public abstract int runWithSession(String[] var1) throws RestartSessionException;

    @Override
    public final int run(String[] args) {
        assert (false);
        return 0;
    }

    public void restart() throws RestartSessionException {
        throw new RestartSessionException();
    }

    public abstract SessionPrx createSession();

    public void sessionDestroyed() {
    }

    public static RouterPrx router() {
        return _router;
    }

    public static SessionPrx session() {
        return _session;
    }

    public String categoryForClient() throws SessionNotExistException {
        if (_router == null) {
            throw new SessionNotExistException();
        }
        return _category;
    }

    public Identity createCallbackIdentity(String name) throws SessionNotExistException {
        return new Identity(name, this.categoryForClient());
    }

    public ObjectPrx addWithUUID(Ice.Object servant) throws SessionNotExistException {
        return this.objectAdapter().add(servant, this.createCallbackIdentity(UUID.randomUUID().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter objectAdapter() throws SessionNotExistException {
        if (_router == null) {
            throw new SessionNotExistException();
        }
        Application application = this;
        synchronized (application) {
            if (_adapter == null) {
                _adapter = Application.communicator().createObjectAdapterWithRouter("", _router);
                _adapter.activate();
            }
        }
        return _adapter;
    }

    @Override
    protected int doMain(StringSeqHolder argHolder, InitializationData initData) {
        InitializationData id;
        StringSeqHolder h;
        boolean restart;
        initData.properties.setProperty("Ice.RetryIntervals", "-1");
        Holder<Integer> ret = new Holder<Integer>();
        do {
            id = initData.clone();
            id.properties = id.properties._clone();
            h = new StringSeqHolder();
            h.value = ((String[])argHolder.value).clone();
        } while (restart = this.doMain(h, id, ret));
        return (Integer)ret.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doMain(StringSeqHolder argHolder, InitializationData initData, Holder<Integer> status) {
        boolean restart;
        block41: {
            _callbackInProgress = false;
            _destroyed = false;
            _interrupted = false;
            restart = false;
            status.value = 0;
            try {
                _communicator = Util.initialize(argHolder, initData);
                _router = RouterPrxHelper.uncheckedCast(Application.communicator().getDefaultRouter());
                if (_router == null) {
                    Util.getProcessLogger().error("no glacier2 router configured");
                    status.value = 1;
                    break block41;
                }
                if (_signalPolicy == SignalPolicy.HandleSignals) {
                    Application.destroyOnInterrupt();
                }
                try {
                    _session = this.createSession();
                    _createdSession = true;
                }
                catch (LocalException ex) {
                    Util.getProcessLogger().error(Ex.toString(ex));
                    status.value = 1;
                }
                if (!_createdSession) break block41;
                int acmTimeout = 0;
                try {
                    acmTimeout = _router.getACMTimeout();
                }
                catch (OperationNotExistException operationNotExistException) {
                    // empty catch block
                }
                if (acmTimeout <= 0) {
                    acmTimeout = (int)_router.getSessionTimeout();
                }
                if (acmTimeout > 0) {
                    Connection connection = _router.ice_getCachedConnection();
                    assert (connection != null);
                    connection.setACM(new IntOptional(acmTimeout), null, new Optional<ACMHeartbeat>(ACMHeartbeat.HeartbeatAlways));
                    connection.setCallback(new ConnectionCallbackI());
                }
                _category = _router.getCategoryForClient();
                status.value = this.runWithSession((String[])argHolder.value);
            }
            catch (RestartSessionException ex) {
                restart = true;
            }
            catch (ConnectionRefusedException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (ConnectionLostException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (UnknownLocalException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (RequestFailedException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (TimeoutException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                restart = true;
            }
            catch (LocalException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                status.value = 1;
            }
            catch (Exception ex) {
                Util.getProcessLogger().error("unknown exception:\n" + Ex.toString(ex));
                status.value = 1;
            }
            catch (Error err2) {
                Util.getProcessLogger().error("Java error:\n" + Ex.toString(err2));
                status.value = 1;
            }
        }
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Application.defaultInterrupt();
        }
        Object err2 = _mutex;
        synchronized (err2) {
            while (_callbackInProgress) {
                try {
                    _mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (_destroyed) {
                _communicator = null;
            } else {
                _destroyed = true;
            }
        }
        if (_createdSession && _router != null) {
            try {
                _router.destroySession();
            }
            catch (ConnectionLostException err2) {
            }
            catch (SessionNotExistException err2) {
            }
            catch (Throwable ex) {
                Util.getProcessLogger().error("unexpected exception when destroying the session:\n" + Ex.toString(ex));
            }
            _router = null;
        }
        if (_communicator != null) {
            try {
                _communicator.destroy();
            }
            catch (LocalException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                status.value = 1;
            }
            catch (Exception ex) {
                Util.getProcessLogger().error("unknown exception:\n" + Ex.toString(ex));
                status.value = 1;
            }
            _communicator = null;
        }
        Object object = _mutex;
        synchronized (object) {
            if (_appHook != null) {
                _appHook.done();
            }
        }
        _adapter = null;
        _router = null;
        _session = null;
        _createdSession = false;
        _category = null;
        return restart;
    }

    static {
        _createdSession = false;
    }

    private class ConnectionCallbackI
    implements ConnectionCallback {
        private ConnectionCallbackI() {
        }

        @Override
        public void heartbeat(Connection con) {
        }

        @Override
        public void closed(Connection con) {
            Application.this.sessionDestroyed();
        }
    }

    public class RestartSessionException
    extends Exception {
    }
}

