/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glrm;

import hex.genmodel.utils.ArrayUtils;

public enum GlrmLoss {
    Quadratic{

        @Override
        public boolean isForNumeric() {
            return true;
        }

        @Override
        public boolean isForCategorical() {
            return false;
        }

        @Override
        public boolean isForBinary() {
            return false;
        }

        @Override
        public double loss(double u2, double a2) {
            return (u2 - a2) * (u2 - a2);
        }

        @Override
        public double lgrad(double u2, double a2) {
            return 2.0 * (u2 - a2);
        }

        @Override
        public double impute(double u2) {
            return u2;
        }
    }
    ,
    Absolute{

        @Override
        public boolean isForNumeric() {
            return true;
        }

        @Override
        public boolean isForCategorical() {
            return false;
        }

        @Override
        public boolean isForBinary() {
            return false;
        }

        @Override
        public double loss(double u2, double a2) {
            return Math.abs(u2 - a2);
        }

        @Override
        public double lgrad(double u2, double a2) {
            return Math.signum(u2 - a2);
        }

        @Override
        public double impute(double u2) {
            return u2;
        }
    }
    ,
    Huber{

        @Override
        public boolean isForNumeric() {
            return true;
        }

        @Override
        public boolean isForCategorical() {
            return false;
        }

        @Override
        public boolean isForBinary() {
            return false;
        }

        @Override
        public double loss(double u2, double a2) {
            double x2 = u2 - a2;
            return x2 > 1.0 ? x2 - 0.5 : (x2 < -1.0 ? -x2 - 0.5 : 0.5 * x2 * x2);
        }

        @Override
        public double lgrad(double u2, double a2) {
            double x2 = u2 - a2;
            return x2 > 1.0 ? 1.0 : (x2 < -1.0 ? -1.0 : x2);
        }

        @Override
        public double impute(double u2) {
            return u2;
        }
    }
    ,
    Poisson{

        @Override
        public boolean isForNumeric() {
            return true;
        }

        @Override
        public boolean isForCategorical() {
            return false;
        }

        @Override
        public boolean isForBinary() {
            return false;
        }

        @Override
        public double loss(double u2, double a2) {
            assert (a2 >= 0.0) : "Poisson loss L(u,a) requires variable a >= 0";
            return Math.exp(u2) + (a2 == 0.0 ? 0.0 : -a2 * u2 + a2 * Math.log(a2) - a2);
        }

        @Override
        public double lgrad(double u2, double a2) {
            assert (a2 >= 0.0) : "Poisson loss L(u,a) requires variable a >= 0";
            return Math.exp(u2) - a2;
        }

        @Override
        public double impute(double u2) {
            return Math.exp(u2);
        }
    }
    ,
    Periodic{
        private double f;
        private int period;

        @Override
        public boolean isForNumeric() {
            return true;
        }

        @Override
        public boolean isForCategorical() {
            return false;
        }

        @Override
        public boolean isForBinary() {
            return false;
        }

        @Override
        public double loss(double u2, double a2) {
            return 1.0 - Math.cos((u2 - a2) * this.f);
        }

        @Override
        public double lgrad(double u2, double a2) {
            return this.f * Math.sin((u2 - a2) * this.f);
        }

        @Override
        public double impute(double u2) {
            return u2;
        }

        @Override
        public void setParameters(int period) {
            this.period = period;
            this.f = Math.PI * 2 / (double)period;
        }

        public String toString() {
            return "Periodic(" + this.period + ")";
        }
    }
    ,
    Logistic{

        @Override
        public boolean isForNumeric() {
            return false;
        }

        @Override
        public boolean isForCategorical() {
            return false;
        }

        @Override
        public boolean isForBinary() {
            return true;
        }

        @Override
        public double loss(double u2, double a2) {
            assert (a2 == 0.0 || a2 == 1.0) : "Logistic loss should be applied to binary features only";
            return Math.log(1.0 + Math.exp((1.0 - 2.0 * a2) * u2));
        }

        @Override
        public double lgrad(double u2, double a2) {
            double s2 = 1.0 - 2.0 * a2;
            return s2 / (1.0 + Math.exp(-s2 * u2));
        }

        @Override
        public double impute(double u2) {
            return u2 > 0.0 ? 1.0 : 0.0;
        }
    }
    ,
    Hinge{

        @Override
        public boolean isForNumeric() {
            return false;
        }

        @Override
        public boolean isForCategorical() {
            return false;
        }

        @Override
        public boolean isForBinary() {
            return true;
        }

        @Override
        public double loss(double u2, double a2) {
            assert (a2 == 0.0 || a2 == 1.0) : "Hinge loss should be applied to binary variables only";
            return Math.max(1.0 + (1.0 - 2.0 * a2) * u2, 0.0);
        }

        @Override
        public double lgrad(double u2, double a2) {
            double s2 = 1.0 - 2.0 * a2;
            return 1.0 + s2 * u2 > 0.0 ? s2 : 0.0;
        }

        @Override
        public double impute(double u2) {
            return u2 > 0.0 ? 1.0 : 0.0;
        }
    }
    ,
    Categorical{

        @Override
        public boolean isForNumeric() {
            return false;
        }

        @Override
        public boolean isForCategorical() {
            return true;
        }

        @Override
        public boolean isForBinary() {
            return false;
        }

        @Override
        public double mloss(double[] u2, int a2) {
            return this.mloss(u2, a2, u2.length);
        }

        @Override
        public double mloss(double[] u2, int a2, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            double sum = 0.0;
            for (int ind = 0; ind < u_len; ++ind) {
                sum += Math.max(1.0 + u2[ind], 0.0);
            }
            return sum += Math.max(1.0 - u2[a2], 0.0) - Math.max(1.0 + u2[a2], 0.0);
        }

        @Override
        public double[] mlgrad(double[] u2, int a2) {
            double[] grad = new double[u2.length];
            return this.mlgrad(u2, a2, grad, u2.length);
        }

        @Override
        public double[] mlgrad(double[] u2, int a2, double[] grad, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            for (int i2 = 0; i2 < u_len; ++i2) {
                grad[i2] = 1.0 + u2[i2] > 0.0 ? 1.0 : 0.0;
            }
            grad[a2] = 1.0 - u2[a2] > 0.0 ? -1.0 : 0.0;
            return grad;
        }

        @Override
        public int mimpute(double[] u2) {
            return ArrayUtils.maxIndex(u2);
        }
    }
    ,
    Ordinal{

        @Override
        public boolean isForNumeric() {
            return false;
        }

        @Override
        public boolean isForCategorical() {
            return true;
        }

        @Override
        public boolean isForBinary() {
            return false;
        }

        @Override
        public double mloss(double[] u2, int a2) {
            return this.mloss(u2, a2, u2.length);
        }

        @Override
        public double mloss(double[] u2, int a2, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            double sum = 0.0;
            for (int i2 = 0; i2 < u_len - 1; ++i2) {
                sum += a2 > i2 ? Math.max(1.0 - u2[i2], 0.0) : 1.0;
            }
            return sum;
        }

        @Override
        public double[] mlgrad(double[] u2, int a2) {
            double[] grad = new double[u2.length];
            return this.mlgrad(u2, a2, grad, u2.length);
        }

        @Override
        public double[] mlgrad(double[] u2, int a2, double[] grad, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            for (int i2 = 0; i2 < u_len - 1; ++i2) {
                grad[i2] = a2 > i2 && 1.0 - u2[i2] > 0.0 ? -1.0 : 0.0;
            }
            return grad;
        }

        @Override
        public int mimpute(double[] u2) {
            double sum;
            double best_loss = sum = (double)(u2.length - 1);
            int best_a = 0;
            for (int a2 = 1; a2 < u2.length; ++a2) {
                if (!((sum -= Math.min(1.0, u2[a2 - 1])) < best_loss)) continue;
                best_loss = sum;
                best_a = a2;
            }
            return best_a;
        }
    };


    public abstract boolean isForNumeric();

    public abstract boolean isForCategorical();

    public abstract boolean isForBinary();

    public double loss(double u2, double a2) {
        throw new UnsupportedOperationException();
    }

    public double lgrad(double u2, double a2) {
        throw new UnsupportedOperationException();
    }

    public double impute(double u2) {
        throw new UnsupportedOperationException();
    }

    public double mloss(double[] u2, int a2) {
        throw new UnsupportedOperationException();
    }

    public double mloss(double[] u2, int a2, int u_len) {
        throw new UnsupportedOperationException();
    }

    public double[] mlgrad(double[] u2, int a2) {
        throw new UnsupportedOperationException();
    }

    public double[] mlgrad(double[] u2, int a2, double[] prod, int u_len) {
        throw new UnsupportedOperationException();
    }

    public int mimpute(double[] u2) {
        throw new UnsupportedOperationException();
    }

    public void setParameters(int p2) {
        throw new UnsupportedOperationException();
    }
}

