/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteBufferWriter;
import ai.h2o.com.google.protobuf.ByteOutput;
import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.RopeByteString;
import ai.h2o.com.google.protobuf.Utf8;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

final class NioByteString
extends ByteString.LeafByteString {
    private final ByteBuffer buffer;

    NioByteString(ByteBuffer buffer) {
        Internal.checkNotNull(buffer, "buffer");
        this.buffer = buffer.slice().order(ByteOrder.nativeOrder());
    }

    private Object writeReplace() {
        return ByteString.copyFrom(this.buffer.slice());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("NioByteString instances are not to be serialized directly");
    }

    @Override
    public final byte byteAt(int index) {
        try {
            return this.buffer.get(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = arrayIndexOutOfBoundsException;
            throw arrayIndexOutOfBoundsException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public final byte internalByteAt(int index) {
        return this.byteAt(index);
    }

    @Override
    public final int size() {
        return this.buffer.remaining();
    }

    @Override
    public final ByteString substring(int beginIndex, int endIndex) {
        try {
            ByteBuffer byteBuffer = this.slice(beginIndex, endIndex);
            return new NioByteString(byteBuffer);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = arrayIndexOutOfBoundsException;
            throw arrayIndexOutOfBoundsException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
        }
    }

    @Override
    protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        ByteBuffer byteBuffer = this.buffer.slice();
        byteBuffer.position(sourceOffset);
        byteBuffer.get(target, targetOffset, numberToCopy);
    }

    @Override
    public final void copyTo(ByteBuffer target) {
        target.put(this.buffer.slice());
    }

    @Override
    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }

    @Override
    final boolean equalsRange(ByteString other, int offset, int length) {
        int n2 = offset;
        return this.substring(0, length).equals(other.substring(n2, n2 + length));
    }

    @Override
    final void writeToInternal(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        if (this.buffer.hasArray()) {
            int n2 = this.buffer.arrayOffset() + this.buffer.position() + sourceOffset;
            out.write(this.buffer.array(), n2, numberToWrite);
            return;
        }
        int n3 = sourceOffset;
        ByteBufferWriter.write(this.slice(n3, n3 + numberToWrite), out);
    }

    @Override
    final void writeTo(ByteOutput output) throws IOException {
        output.writeLazy(this.buffer.slice());
    }

    @Override
    public final ByteBuffer asReadOnlyByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public final List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    @Override
    protected final String toStringInternal(Charset charset) {
        int n2;
        int n3;
        byte[] byArray;
        if (this.buffer.hasArray()) {
            byArray = this.buffer.array();
            n3 = this.buffer.arrayOffset() + this.buffer.position();
            n2 = this.buffer.remaining();
        } else {
            byArray = this.toByteArray();
            n3 = 0;
            n2 = byArray.length;
        }
        return new String(byArray, n3, n2, charset);
    }

    @Override
    public final boolean isValidUtf8() {
        return Utf8.isValidUtf8(this.buffer);
    }

    @Override
    protected final int partialIsValidUtf8(int state, int offset, int length) {
        int n2 = offset;
        return Utf8.partialIsValidUtf8(state, this.buffer, n2, n2 + length);
    }

    @Override
    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)other;
        if (this.size() != byteString.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof NioByteString) {
            return this.buffer.equals(((NioByteString)other).buffer);
        }
        if (other instanceof RopeByteString) {
            return other.equals(this);
        }
        return this.buffer.equals(byteString.asReadOnlyByteBuffer());
    }

    @Override
    protected final int partialHash(int h2, int offset, int length) {
        for (int i2 = offset; i2 < offset + length; ++i2) {
            h2 = h2 * 31 + this.buffer.get(i2);
        }
        return h2;
    }

    @Override
    public final InputStream newInput() {
        return new InputStream(){
            private final ByteBuffer buf;
            {
                this.buf = NioByteString.this.buffer.slice();
            }

            @Override
            public void mark(int readlimit) {
                this.buf.mark();
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public void reset() throws IOException {
                try {
                    this.buf.reset();
                    return;
                }
                catch (InvalidMarkException invalidMarkException) {
                    throw new IOException(invalidMarkException);
                }
            }

            @Override
            public int available() throws IOException {
                return this.buf.remaining();
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, len);
                return len;
            }
        };
    }

    @Override
    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.buffer, true);
    }

    private ByteBuffer slice(int beginIndex, int endIndex) {
        if (beginIndex < this.buffer.position() || endIndex > this.buffer.limit() || beginIndex > endIndex) {
            throw new IllegalArgumentException(String.format("Invalid indices [%d, %d]", beginIndex, endIndex));
        }
        ByteBuffer byteBuffer = this.buffer.slice();
        byteBuffer.position(beginIndex - this.buffer.position());
        byteBuffer.limit(endIndex - this.buffer.position());
        return byteBuffer;
    }
}

