# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from memsource_cli.models.tag_metadata_dto import TagMetadataDto  # noqa: F401,E501


class SearchTMRequestDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'segment': 'str',
        'workflow_level': 'int',
        'score_threshold': 'float',
        'previous_segment': 'str',
        'next_segment': 'str',
        'context_key': 'str',
        'max_segments': 'int',
        'max_sub_segments': 'int',
        'tag_metadata': 'list[TagMetadataDto]',
        'target_langs': 'list[str]'
    }

    attribute_map = {
        'segment': 'segment',
        'workflow_level': 'workflowLevel',
        'score_threshold': 'scoreThreshold',
        'previous_segment': 'previousSegment',
        'next_segment': 'nextSegment',
        'context_key': 'contextKey',
        'max_segments': 'maxSegments',
        'max_sub_segments': 'maxSubSegments',
        'tag_metadata': 'tagMetadata',
        'target_langs': 'targetLangs'
    }

    def __init__(self, segment=None, workflow_level=None, score_threshold=None, previous_segment=None, next_segment=None, context_key=None, max_segments=None, max_sub_segments=None, tag_metadata=None, target_langs=None):  # noqa: E501
        """SearchTMRequestDto - a model defined in Swagger"""  # noqa: E501

        self._segment = None
        self._workflow_level = None
        self._score_threshold = None
        self._previous_segment = None
        self._next_segment = None
        self._context_key = None
        self._max_segments = None
        self._max_sub_segments = None
        self._tag_metadata = None
        self._target_langs = None
        self.discriminator = None

        self.segment = segment
        if workflow_level is not None:
            self.workflow_level = workflow_level
        if score_threshold is not None:
            self.score_threshold = score_threshold
        if previous_segment is not None:
            self.previous_segment = previous_segment
        if next_segment is not None:
            self.next_segment = next_segment
        if context_key is not None:
            self.context_key = context_key
        if max_segments is not None:
            self.max_segments = max_segments
        if max_sub_segments is not None:
            self.max_sub_segments = max_sub_segments
        if tag_metadata is not None:
            self.tag_metadata = tag_metadata
        self.target_langs = target_langs

    @property
    def segment(self):
        """Gets the segment of this SearchTMRequestDto.  # noqa: E501


        :return: The segment of this SearchTMRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._segment

    @segment.setter
    def segment(self, segment):
        """Sets the segment of this SearchTMRequestDto.


        :param segment: The segment of this SearchTMRequestDto.  # noqa: E501
        :type: str
        """
        if segment is None:
            raise ValueError("Invalid value for `segment`, must not be `None`")  # noqa: E501

        self._segment = segment

    @property
    def workflow_level(self):
        """Gets the workflow_level of this SearchTMRequestDto.  # noqa: E501


        :return: The workflow_level of this SearchTMRequestDto.  # noqa: E501
        :rtype: int
        """
        return self._workflow_level

    @workflow_level.setter
    def workflow_level(self, workflow_level):
        """Sets the workflow_level of this SearchTMRequestDto.


        :param workflow_level: The workflow_level of this SearchTMRequestDto.  # noqa: E501
        :type: int
        """
        if workflow_level is not None and workflow_level > 15:  # noqa: E501
            raise ValueError("Invalid value for `workflow_level`, must be a value less than or equal to `15`")  # noqa: E501
        if workflow_level is not None and workflow_level < 1:  # noqa: E501
            raise ValueError("Invalid value for `workflow_level`, must be a value greater than or equal to `1`")  # noqa: E501

        self._workflow_level = workflow_level

    @property
    def score_threshold(self):
        """Gets the score_threshold of this SearchTMRequestDto.  # noqa: E501


        :return: The score_threshold of this SearchTMRequestDto.  # noqa: E501
        :rtype: float
        """
        return self._score_threshold

    @score_threshold.setter
    def score_threshold(self, score_threshold):
        """Sets the score_threshold of this SearchTMRequestDto.


        :param score_threshold: The score_threshold of this SearchTMRequestDto.  # noqa: E501
        :type: float
        """
        if score_threshold is not None and score_threshold > 1.01:  # noqa: E501
            raise ValueError("Invalid value for `score_threshold`, must be a value less than or equal to `1.01`")  # noqa: E501
        if score_threshold is not None and score_threshold < 0.0:  # noqa: E501
            raise ValueError("Invalid value for `score_threshold`, must be a value greater than or equal to `0.0`")  # noqa: E501

        self._score_threshold = score_threshold

    @property
    def previous_segment(self):
        """Gets the previous_segment of this SearchTMRequestDto.  # noqa: E501


        :return: The previous_segment of this SearchTMRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._previous_segment

    @previous_segment.setter
    def previous_segment(self, previous_segment):
        """Sets the previous_segment of this SearchTMRequestDto.


        :param previous_segment: The previous_segment of this SearchTMRequestDto.  # noqa: E501
        :type: str
        """

        self._previous_segment = previous_segment

    @property
    def next_segment(self):
        """Gets the next_segment of this SearchTMRequestDto.  # noqa: E501


        :return: The next_segment of this SearchTMRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._next_segment

    @next_segment.setter
    def next_segment(self, next_segment):
        """Sets the next_segment of this SearchTMRequestDto.


        :param next_segment: The next_segment of this SearchTMRequestDto.  # noqa: E501
        :type: str
        """

        self._next_segment = next_segment

    @property
    def context_key(self):
        """Gets the context_key of this SearchTMRequestDto.  # noqa: E501


        :return: The context_key of this SearchTMRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._context_key

    @context_key.setter
    def context_key(self, context_key):
        """Sets the context_key of this SearchTMRequestDto.


        :param context_key: The context_key of this SearchTMRequestDto.  # noqa: E501
        :type: str
        """

        self._context_key = context_key

    @property
    def max_segments(self):
        """Gets the max_segments of this SearchTMRequestDto.  # noqa: E501

        Default: 5  # noqa: E501

        :return: The max_segments of this SearchTMRequestDto.  # noqa: E501
        :rtype: int
        """
        return self._max_segments

    @max_segments.setter
    def max_segments(self, max_segments):
        """Sets the max_segments of this SearchTMRequestDto.

        Default: 5  # noqa: E501

        :param max_segments: The max_segments of this SearchTMRequestDto.  # noqa: E501
        :type: int
        """
        if max_segments is not None and max_segments > 5:  # noqa: E501
            raise ValueError("Invalid value for `max_segments`, must be a value less than or equal to `5`")  # noqa: E501
        if max_segments is not None and max_segments < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_segments`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_segments = max_segments

    @property
    def max_sub_segments(self):
        """Gets the max_sub_segments of this SearchTMRequestDto.  # noqa: E501

        Default: 5  # noqa: E501

        :return: The max_sub_segments of this SearchTMRequestDto.  # noqa: E501
        :rtype: int
        """
        return self._max_sub_segments

    @max_sub_segments.setter
    def max_sub_segments(self, max_sub_segments):
        """Sets the max_sub_segments of this SearchTMRequestDto.

        Default: 5  # noqa: E501

        :param max_sub_segments: The max_sub_segments of this SearchTMRequestDto.  # noqa: E501
        :type: int
        """
        if max_sub_segments is not None and max_sub_segments > 5:  # noqa: E501
            raise ValueError("Invalid value for `max_sub_segments`, must be a value less than or equal to `5`")  # noqa: E501
        if max_sub_segments is not None and max_sub_segments < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_sub_segments`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_sub_segments = max_sub_segments

    @property
    def tag_metadata(self):
        """Gets the tag_metadata of this SearchTMRequestDto.  # noqa: E501


        :return: The tag_metadata of this SearchTMRequestDto.  # noqa: E501
        :rtype: list[TagMetadataDto]
        """
        return self._tag_metadata

    @tag_metadata.setter
    def tag_metadata(self, tag_metadata):
        """Sets the tag_metadata of this SearchTMRequestDto.


        :param tag_metadata: The tag_metadata of this SearchTMRequestDto.  # noqa: E501
        :type: list[TagMetadataDto]
        """

        self._tag_metadata = tag_metadata

    @property
    def target_langs(self):
        """Gets the target_langs of this SearchTMRequestDto.  # noqa: E501


        :return: The target_langs of this SearchTMRequestDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_langs

    @target_langs.setter
    def target_langs(self, target_langs):
        """Sets the target_langs of this SearchTMRequestDto.


        :param target_langs: The target_langs of this SearchTMRequestDto.  # noqa: E501
        :type: list[str]
        """
        if target_langs is None:
            raise ValueError("Invalid value for `target_langs`, must not be `None`")  # noqa: E501

        self._target_langs = target_langs

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SearchTMRequestDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchTMRequestDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
