# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from memsource_cli.models.tag_metadata_dto import TagMetadataDto  # noqa: F401,E501


class SearchRequestDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query': 'str',
        'source_lang': 'str',
        'target_langs': 'list[str]',
        'previous_segment': 'str',
        'next_segment': 'str',
        'tag_metadata': 'list[TagMetadataDto]',
        'trim_query': 'bool',
        'phrase_query': 'bool'
    }

    attribute_map = {
        'query': 'query',
        'source_lang': 'sourceLang',
        'target_langs': 'targetLangs',
        'previous_segment': 'previousSegment',
        'next_segment': 'nextSegment',
        'tag_metadata': 'tagMetadata',
        'trim_query': 'trimQuery',
        'phrase_query': 'phraseQuery'
    }

    def __init__(self, query=None, source_lang=None, target_langs=None, previous_segment=None, next_segment=None, tag_metadata=None, trim_query=None, phrase_query=None):  # noqa: E501
        """SearchRequestDto - a model defined in Swagger"""  # noqa: E501

        self._query = None
        self._source_lang = None
        self._target_langs = None
        self._previous_segment = None
        self._next_segment = None
        self._tag_metadata = None
        self._trim_query = None
        self._phrase_query = None
        self.discriminator = None

        self.query = query
        self.source_lang = source_lang
        if target_langs is not None:
            self.target_langs = target_langs
        if previous_segment is not None:
            self.previous_segment = previous_segment
        if next_segment is not None:
            self.next_segment = next_segment
        if tag_metadata is not None:
            self.tag_metadata = tag_metadata
        if trim_query is not None:
            self.trim_query = trim_query
        if phrase_query is not None:
            self.phrase_query = phrase_query

    @property
    def query(self):
        """Gets the query of this SearchRequestDto.  # noqa: E501


        :return: The query of this SearchRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this SearchRequestDto.


        :param query: The query of this SearchRequestDto.  # noqa: E501
        :type: str
        """
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")  # noqa: E501

        self._query = query

    @property
    def source_lang(self):
        """Gets the source_lang of this SearchRequestDto.  # noqa: E501


        :return: The source_lang of this SearchRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._source_lang

    @source_lang.setter
    def source_lang(self, source_lang):
        """Sets the source_lang of this SearchRequestDto.


        :param source_lang: The source_lang of this SearchRequestDto.  # noqa: E501
        :type: str
        """
        if source_lang is None:
            raise ValueError("Invalid value for `source_lang`, must not be `None`")  # noqa: E501

        self._source_lang = source_lang

    @property
    def target_langs(self):
        """Gets the target_langs of this SearchRequestDto.  # noqa: E501


        :return: The target_langs of this SearchRequestDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_langs

    @target_langs.setter
    def target_langs(self, target_langs):
        """Sets the target_langs of this SearchRequestDto.


        :param target_langs: The target_langs of this SearchRequestDto.  # noqa: E501
        :type: list[str]
        """

        self._target_langs = target_langs

    @property
    def previous_segment(self):
        """Gets the previous_segment of this SearchRequestDto.  # noqa: E501


        :return: The previous_segment of this SearchRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._previous_segment

    @previous_segment.setter
    def previous_segment(self, previous_segment):
        """Sets the previous_segment of this SearchRequestDto.


        :param previous_segment: The previous_segment of this SearchRequestDto.  # noqa: E501
        :type: str
        """

        self._previous_segment = previous_segment

    @property
    def next_segment(self):
        """Gets the next_segment of this SearchRequestDto.  # noqa: E501


        :return: The next_segment of this SearchRequestDto.  # noqa: E501
        :rtype: str
        """
        return self._next_segment

    @next_segment.setter
    def next_segment(self, next_segment):
        """Sets the next_segment of this SearchRequestDto.


        :param next_segment: The next_segment of this SearchRequestDto.  # noqa: E501
        :type: str
        """

        self._next_segment = next_segment

    @property
    def tag_metadata(self):
        """Gets the tag_metadata of this SearchRequestDto.  # noqa: E501


        :return: The tag_metadata of this SearchRequestDto.  # noqa: E501
        :rtype: list[TagMetadataDto]
        """
        return self._tag_metadata

    @tag_metadata.setter
    def tag_metadata(self, tag_metadata):
        """Sets the tag_metadata of this SearchRequestDto.


        :param tag_metadata: The tag_metadata of this SearchRequestDto.  # noqa: E501
        :type: list[TagMetadataDto]
        """

        self._tag_metadata = tag_metadata

    @property
    def trim_query(self):
        """Gets the trim_query of this SearchRequestDto.  # noqa: E501

        Remove leading and trailing whitespace from query. Default: true  # noqa: E501

        :return: The trim_query of this SearchRequestDto.  # noqa: E501
        :rtype: bool
        """
        return self._trim_query

    @trim_query.setter
    def trim_query(self, trim_query):
        """Sets the trim_query of this SearchRequestDto.

        Remove leading and trailing whitespace from query. Default: true  # noqa: E501

        :param trim_query: The trim_query of this SearchRequestDto.  # noqa: E501
        :type: bool
        """

        self._trim_query = trim_query

    @property
    def phrase_query(self):
        """Gets the phrase_query of this SearchRequestDto.  # noqa: E501

        Return both wildcard and exact search results. Default: true  # noqa: E501

        :return: The phrase_query of this SearchRequestDto.  # noqa: E501
        :rtype: bool
        """
        return self._phrase_query

    @phrase_query.setter
    def phrase_query(self, phrase_query):
        """Sets the phrase_query of this SearchRequestDto.

        Return both wildcard and exact search results. Default: true  # noqa: E501

        :param phrase_query: The phrase_query of this SearchRequestDto.  # noqa: E501
        :type: bool
        """

        self._phrase_query = phrase_query

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SearchRequestDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchRequestDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
