# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from memsource_cli.models.net_rate_scheme_reference import NetRateSchemeReference  # noqa: F401,E501
from memsource_cli.models.price_list_reference import PriceListReference  # noqa: F401,E501
from memsource_cli.models.provider_reference import ProviderReference  # noqa: F401,E501
from memsource_cli.models.user_reference import UserReference  # noqa: F401,E501
from memsource_cli.models.workflow_step_reference import WorkflowStepReference  # noqa: F401,E501


class QuoteDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'name': 'str',
        'status': 'str',
        'currency': 'str',
        'billing_unit': 'str',
        'created_by': 'UserReference',
        'date_created': 'datetime',
        'total_price': 'float',
        'net_rate_scheme': 'NetRateSchemeReference',
        'price_list': 'PriceListReference',
        'workflow_step_list': 'list[WorkflowStepReference]',
        'provider': 'ProviderReference',
        'customer_email': 'str',
        'quote_type': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'status': 'status',
        'currency': 'currency',
        'billing_unit': 'billingUnit',
        'created_by': 'createdBy',
        'date_created': 'dateCreated',
        'total_price': 'totalPrice',
        'net_rate_scheme': 'netRateScheme',
        'price_list': 'priceList',
        'workflow_step_list': 'workflowStepList',
        'provider': 'provider',
        'customer_email': 'customerEmail',
        'quote_type': 'quoteType'
    }

    def __init__(self, id=None, name=None, status=None, currency=None, billing_unit=None, created_by=None, date_created=None, total_price=None, net_rate_scheme=None, price_list=None, workflow_step_list=None, provider=None, customer_email=None, quote_type=None):  # noqa: E501
        """QuoteDto - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._name = None
        self._status = None
        self._currency = None
        self._billing_unit = None
        self._created_by = None
        self._date_created = None
        self._total_price = None
        self._net_rate_scheme = None
        self._price_list = None
        self._workflow_step_list = None
        self._provider = None
        self._customer_email = None
        self._quote_type = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if status is not None:
            self.status = status
        if currency is not None:
            self.currency = currency
        if billing_unit is not None:
            self.billing_unit = billing_unit
        if created_by is not None:
            self.created_by = created_by
        if date_created is not None:
            self.date_created = date_created
        if total_price is not None:
            self.total_price = total_price
        if net_rate_scheme is not None:
            self.net_rate_scheme = net_rate_scheme
        if price_list is not None:
            self.price_list = price_list
        if workflow_step_list is not None:
            self.workflow_step_list = workflow_step_list
        if provider is not None:
            self.provider = provider
        if customer_email is not None:
            self.customer_email = customer_email
        if quote_type is not None:
            self.quote_type = quote_type

    @property
    def id(self):
        """Gets the id of this QuoteDto.  # noqa: E501


        :return: The id of this QuoteDto.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this QuoteDto.


        :param id: The id of this QuoteDto.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this QuoteDto.  # noqa: E501


        :return: The name of this QuoteDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this QuoteDto.


        :param name: The name of this QuoteDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def status(self):
        """Gets the status of this QuoteDto.  # noqa: E501


        :return: The status of this QuoteDto.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this QuoteDto.


        :param status: The status of this QuoteDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["APPROVED", "DECLINED", "DRAFT", "FOR_APPROVAL", "NEW"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def currency(self):
        """Gets the currency of this QuoteDto.  # noqa: E501


        :return: The currency of this QuoteDto.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this QuoteDto.


        :param currency: The currency of this QuoteDto.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def billing_unit(self):
        """Gets the billing_unit of this QuoteDto.  # noqa: E501


        :return: The billing_unit of this QuoteDto.  # noqa: E501
        :rtype: str
        """
        return self._billing_unit

    @billing_unit.setter
    def billing_unit(self, billing_unit):
        """Sets the billing_unit of this QuoteDto.


        :param billing_unit: The billing_unit of this QuoteDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["Character", "Word", "Page"]  # noqa: E501
        if billing_unit not in allowed_values:
            raise ValueError(
                "Invalid value for `billing_unit` ({0}), must be one of {1}"  # noqa: E501
                .format(billing_unit, allowed_values)
            )

        self._billing_unit = billing_unit

    @property
    def created_by(self):
        """Gets the created_by of this QuoteDto.  # noqa: E501


        :return: The created_by of this QuoteDto.  # noqa: E501
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this QuoteDto.


        :param created_by: The created_by of this QuoteDto.  # noqa: E501
        :type: UserReference
        """

        self._created_by = created_by

    @property
    def date_created(self):
        """Gets the date_created of this QuoteDto.  # noqa: E501


        :return: The date_created of this QuoteDto.  # noqa: E501
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """Sets the date_created of this QuoteDto.


        :param date_created: The date_created of this QuoteDto.  # noqa: E501
        :type: datetime
        """

        self._date_created = date_created

    @property
    def total_price(self):
        """Gets the total_price of this QuoteDto.  # noqa: E501


        :return: The total_price of this QuoteDto.  # noqa: E501
        :rtype: float
        """
        return self._total_price

    @total_price.setter
    def total_price(self, total_price):
        """Sets the total_price of this QuoteDto.


        :param total_price: The total_price of this QuoteDto.  # noqa: E501
        :type: float
        """

        self._total_price = total_price

    @property
    def net_rate_scheme(self):
        """Gets the net_rate_scheme of this QuoteDto.  # noqa: E501


        :return: The net_rate_scheme of this QuoteDto.  # noqa: E501
        :rtype: NetRateSchemeReference
        """
        return self._net_rate_scheme

    @net_rate_scheme.setter
    def net_rate_scheme(self, net_rate_scheme):
        """Sets the net_rate_scheme of this QuoteDto.


        :param net_rate_scheme: The net_rate_scheme of this QuoteDto.  # noqa: E501
        :type: NetRateSchemeReference
        """

        self._net_rate_scheme = net_rate_scheme

    @property
    def price_list(self):
        """Gets the price_list of this QuoteDto.  # noqa: E501


        :return: The price_list of this QuoteDto.  # noqa: E501
        :rtype: PriceListReference
        """
        return self._price_list

    @price_list.setter
    def price_list(self, price_list):
        """Sets the price_list of this QuoteDto.


        :param price_list: The price_list of this QuoteDto.  # noqa: E501
        :type: PriceListReference
        """

        self._price_list = price_list

    @property
    def workflow_step_list(self):
        """Gets the workflow_step_list of this QuoteDto.  # noqa: E501


        :return: The workflow_step_list of this QuoteDto.  # noqa: E501
        :rtype: list[WorkflowStepReference]
        """
        return self._workflow_step_list

    @workflow_step_list.setter
    def workflow_step_list(self, workflow_step_list):
        """Sets the workflow_step_list of this QuoteDto.


        :param workflow_step_list: The workflow_step_list of this QuoteDto.  # noqa: E501
        :type: list[WorkflowStepReference]
        """

        self._workflow_step_list = workflow_step_list

    @property
    def provider(self):
        """Gets the provider of this QuoteDto.  # noqa: E501


        :return: The provider of this QuoteDto.  # noqa: E501
        :rtype: ProviderReference
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """Sets the provider of this QuoteDto.


        :param provider: The provider of this QuoteDto.  # noqa: E501
        :type: ProviderReference
        """

        self._provider = provider

    @property
    def customer_email(self):
        """Gets the customer_email of this QuoteDto.  # noqa: E501


        :return: The customer_email of this QuoteDto.  # noqa: E501
        :rtype: str
        """
        return self._customer_email

    @customer_email.setter
    def customer_email(self, customer_email):
        """Sets the customer_email of this QuoteDto.


        :param customer_email: The customer_email of this QuoteDto.  # noqa: E501
        :type: str
        """

        self._customer_email = customer_email

    @property
    def quote_type(self):
        """Gets the quote_type of this QuoteDto.  # noqa: E501


        :return: The quote_type of this QuoteDto.  # noqa: E501
        :rtype: str
        """
        return self._quote_type

    @quote_type.setter
    def quote_type(self, quote_type):
        """Sets the quote_type of this QuoteDto.


        :param quote_type: The quote_type of this QuoteDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["BUYER", "PROVIDER"]  # noqa: E501
        if quote_type not in allowed_values:
            raise ValueError(
                "Invalid value for `quote_type` ({0}), must be one of {1}"  # noqa: E501
                .format(quote_type, allowed_values)
            )

        self._quote_type = quote_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(QuoteDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuoteDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
