# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from memsource_cli.models.id_reference import IdReference  # noqa: F401,E501
from memsource_cli.models.uid_reference import UidReference  # noqa: F401,E501


class HumanTranslateJobsDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'jobs': 'list[UidReference]',
        'human_translate_settings': 'IdReference',
        'comment': 'str',
        'glossary_id': 'str',
        'use_preferred_translators': 'bool',
        'level': 'str',
        'callback_url': 'str'
    }

    attribute_map = {
        'jobs': 'jobs',
        'human_translate_settings': 'humanTranslateSettings',
        'comment': 'comment',
        'glossary_id': 'glossaryId',
        'use_preferred_translators': 'usePreferredTranslators',
        'level': 'level',
        'callback_url': 'callbackUrl'
    }

    def __init__(self, jobs=None, human_translate_settings=None, comment=None, glossary_id=None, use_preferred_translators=None, level=None, callback_url=None):  # noqa: E501
        """HumanTranslateJobsDto - a model defined in Swagger"""  # noqa: E501

        self._jobs = None
        self._human_translate_settings = None
        self._comment = None
        self._glossary_id = None
        self._use_preferred_translators = None
        self._level = None
        self._callback_url = None
        self.discriminator = None

        self.jobs = jobs
        self.human_translate_settings = human_translate_settings
        if comment is not None:
            self.comment = comment
        if glossary_id is not None:
            self.glossary_id = glossary_id
        if use_preferred_translators is not None:
            self.use_preferred_translators = use_preferred_translators
        if level is not None:
            self.level = level
        if callback_url is not None:
            self.callback_url = callback_url

    @property
    def jobs(self):
        """Gets the jobs of this HumanTranslateJobsDto.  # noqa: E501


        :return: The jobs of this HumanTranslateJobsDto.  # noqa: E501
        :rtype: list[UidReference]
        """
        return self._jobs

    @jobs.setter
    def jobs(self, jobs):
        """Sets the jobs of this HumanTranslateJobsDto.


        :param jobs: The jobs of this HumanTranslateJobsDto.  # noqa: E501
        :type: list[UidReference]
        """
        if jobs is None:
            raise ValueError("Invalid value for `jobs`, must not be `None`")  # noqa: E501

        self._jobs = jobs

    @property
    def human_translate_settings(self):
        """Gets the human_translate_settings of this HumanTranslateJobsDto.  # noqa: E501


        :return: The human_translate_settings of this HumanTranslateJobsDto.  # noqa: E501
        :rtype: IdReference
        """
        return self._human_translate_settings

    @human_translate_settings.setter
    def human_translate_settings(self, human_translate_settings):
        """Sets the human_translate_settings of this HumanTranslateJobsDto.


        :param human_translate_settings: The human_translate_settings of this HumanTranslateJobsDto.  # noqa: E501
        :type: IdReference
        """
        if human_translate_settings is None:
            raise ValueError("Invalid value for `human_translate_settings`, must not be `None`")  # noqa: E501

        self._human_translate_settings = human_translate_settings

    @property
    def comment(self):
        """Gets the comment of this HumanTranslateJobsDto.  # noqa: E501


        :return: The comment of this HumanTranslateJobsDto.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this HumanTranslateJobsDto.


        :param comment: The comment of this HumanTranslateJobsDto.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def glossary_id(self):
        """Gets the glossary_id of this HumanTranslateJobsDto.  # noqa: E501


        :return: The glossary_id of this HumanTranslateJobsDto.  # noqa: E501
        :rtype: str
        """
        return self._glossary_id

    @glossary_id.setter
    def glossary_id(self, glossary_id):
        """Sets the glossary_id of this HumanTranslateJobsDto.


        :param glossary_id: The glossary_id of this HumanTranslateJobsDto.  # noqa: E501
        :type: str
        """

        self._glossary_id = glossary_id

    @property
    def use_preferred_translators(self):
        """Gets the use_preferred_translators of this HumanTranslateJobsDto.  # noqa: E501


        :return: The use_preferred_translators of this HumanTranslateJobsDto.  # noqa: E501
        :rtype: bool
        """
        return self._use_preferred_translators

    @use_preferred_translators.setter
    def use_preferred_translators(self, use_preferred_translators):
        """Sets the use_preferred_translators of this HumanTranslateJobsDto.


        :param use_preferred_translators: The use_preferred_translators of this HumanTranslateJobsDto.  # noqa: E501
        :type: bool
        """

        self._use_preferred_translators = use_preferred_translators

    @property
    def level(self):
        """Gets the level of this HumanTranslateJobsDto.  # noqa: E501


        :return: The level of this HumanTranslateJobsDto.  # noqa: E501
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """Sets the level of this HumanTranslateJobsDto.


        :param level: The level of this HumanTranslateJobsDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["STANDARD", "PRO"]  # noqa: E501
        if level not in allowed_values:
            raise ValueError(
                "Invalid value for `level` ({0}), must be one of {1}"  # noqa: E501
                .format(level, allowed_values)
            )

        self._level = level

    @property
    def callback_url(self):
        """Gets the callback_url of this HumanTranslateJobsDto.  # noqa: E501


        :return: The callback_url of this HumanTranslateJobsDto.  # noqa: E501
        :rtype: str
        """
        return self._callback_url

    @callback_url.setter
    def callback_url(self, callback_url):
        """Sets the callback_url of this HumanTranslateJobsDto.


        :param callback_url: The callback_url of this HumanTranslateJobsDto.  # noqa: E501
        :type: str
        """

        self._callback_url = callback_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HumanTranslateJobsDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HumanTranslateJobsDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
