# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class TranslationMemoryApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_target_lang_to_trans_memory(self, trans_memory_id, **kwargs):  # noqa: E501
        """Add target language to translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_target_lang_to_trans_memory(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param TargetLanguageDto body:
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_target_lang_to_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_target_lang_to_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def add_target_lang_to_trans_memory_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Add target language to translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_target_lang_to_trans_memory_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param TargetLanguageDto body:
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_target_lang_to_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `add_target_lang_to_trans_memory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/targetLanguages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransMemoryDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clear_trans_memory(self, trans_memory_id, **kwargs):  # noqa: E501
        """Delete all segments  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_trans_memory(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.clear_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.clear_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def clear_trans_memory_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Delete all segments  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_trans_memory_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `clear_trans_memory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/segments', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_trans_memory(self, **kwargs):  # noqa: E501
        """Create translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_trans_memory(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransMemoryCreateDto body:
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_trans_memory_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_trans_memory_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_trans_memory_with_http_info(self, **kwargs):  # noqa: E501
        """Create translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_trans_memory_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransMemoryCreateDto body:
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransMemoryDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_source_and_translations(self, trans_memory_id, segment_id, **kwargs):  # noqa: E501
        """Delete both source and translation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_source_and_translations(trans_memory_id, segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str segment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_source_and_translations_with_http_info(trans_memory_id, segment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_source_and_translations_with_http_info(trans_memory_id, segment_id, **kwargs)  # noqa: E501
            return data

    def delete_source_and_translations_with_http_info(self, trans_memory_id, segment_id, **kwargs):  # noqa: E501
        """Delete both source and translation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_source_and_translations_with_http_info(trans_memory_id, segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str segment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'segment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_source_and_translations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `delete_source_and_translations`")  # noqa: E501
        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params or
                params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `delete_source_and_translations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/segments/{segmentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_trans_memory(self, trans_memory_id, **kwargs):  # noqa: E501
        """Delete translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_trans_memory(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param bool purge:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def delete_trans_memory_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Delete translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_trans_memory_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param bool purge:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'purge']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `delete_trans_memory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []
        if 'purge' in params:
            query_params.append(('purge', params['purge']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_translation(self, trans_memory_id, segment_id, lang, **kwargs):  # noqa: E501
        """Delete segment of given language  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_translation(trans_memory_id, segment_id, lang, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str segment_id: (required)
        :param str lang: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_translation_with_http_info(trans_memory_id, segment_id, lang, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_translation_with_http_info(trans_memory_id, segment_id, lang, **kwargs)  # noqa: E501
            return data

    def delete_translation_with_http_info(self, trans_memory_id, segment_id, lang, **kwargs):  # noqa: E501
        """Delete segment of given language  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_translation_with_http_info(trans_memory_id, segment_id, lang, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str segment_id: (required)
        :param str lang: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'segment_id', 'lang']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_translation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `delete_translation`")  # noqa: E501
        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params or
                params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `delete_translation`")  # noqa: E501
        # verify the required parameter 'lang' is set
        if ('lang' not in params or
                params['lang'] is None):
            raise ValueError("Missing the required parameter `lang` when calling `delete_translation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']  # noqa: E501
        if 'lang' in params:
            path_params['lang'] = params['lang']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/segments/{segmentId}/lang/{lang}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_search_result(self, async_request_id, **kwargs):  # noqa: E501
        """Download export  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_search_result(async_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str async_request_id: Request ID (required)
        :param str format:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_search_result_with_http_info(async_request_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_search_result_with_http_info(async_request_id, **kwargs)  # noqa: E501
            return data

    def download_search_result_with_http_info(self, async_request_id, **kwargs):  # noqa: E501
        """Download export  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_search_result_with_http_info(async_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str async_request_id: Request ID (required)
        :param str format:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['async_request_id', 'format', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_search_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'async_request_id' is set
        if ('async_request_id' not in params or
                params['async_request_id'] is None):
            raise ValueError("Missing the required parameter `async_request_id` when calling `download_search_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'async_request_id' in params:
            path_params['asyncRequestId'] = params['async_request_id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/downloadExport/{asyncRequestId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_trans_memory(self, trans_memory_id, **kwargs):  # noqa: E501
        """Edit translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_trans_memory(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param TransMemoryEditDto body:
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def edit_trans_memory_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Edit translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_trans_memory_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param TransMemoryEditDto body:
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `edit_trans_memory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransMemoryDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export(self, trans_memory_id, **kwargs):  # noqa: E501
        """Export translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str format:
        :param list[str] target_lang:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def export_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Export translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str format:
        :param list[str] target_lang:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'format', 'target_lang', 'token', 'async_req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'target_lang' in params:
            query_params.append(('targetLang', params['target_lang']))  # noqa: E501
            collection_formats['targetLang'] = 'multi'  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'async_req' in params:
            query_params.append(('async_req', params['async_req']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_by_query_async(self, trans_memory_id, **kwargs):  # noqa: E501
        """Search translation memory  # noqa: E501

        Use GET searchExport/{asyncRequestId} to download result  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_by_query_async(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param ExportByQueryDto body:
        :return: AsyncExportTMResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_by_query_async_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_by_query_async_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def export_by_query_async_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Search translation memory  # noqa: E501

        Use GET searchExport/{asyncRequestId} to download result  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_by_query_async_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param ExportByQueryDto body:
        :return: AsyncExportTMResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_by_query_async" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `export_by_query_async`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/exportByQueryAsync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncExportTMResponseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_background_tasks(self, trans_memory_id, **kwargs):  # noqa: E501
        """Get last task information  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_background_tasks(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :return: BackgroundTasksTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_background_tasks_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_background_tasks_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def get_background_tasks_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Get last task information  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_background_tasks_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :return: BackgroundTasksTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_background_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `get_background_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/lastBackgroundTask', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BackgroundTasksTmDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata(self, trans_memory_id, **kwargs):  # noqa: E501
        """Get translation memory metadata  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param bool by_language:
        :return: MetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metadata_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_metadata_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def get_metadata_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Get translation memory metadata  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param bool by_language:
        :return: MetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'by_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `get_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []
        if 'by_language' in params:
            query_params.append(('byLanguage', params['by_language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_template_trans_memories(self, project_template_id, **kwargs):  # noqa: E501
        """Get translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_trans_memories(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_project_template_trans_memories_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_trans_memories_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_template_trans_memories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_project_template_trans_memories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/transMemories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTransMemoryListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_related_projects(self, trans_memory_id, **kwargs):  # noqa: E501
        """List related projects  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_related_projects(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoAbstractProjectDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_related_projects_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_related_projects_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def get_related_projects_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """List related projects  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_related_projects_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoAbstractProjectDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_related_projects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `get_related_projects`")  # noqa: E501

        if 'page_number' in params and params['page_number'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_number` when calling `get_related_projects`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_related_projects`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_related_projects`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/relatedProjects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoAbstractProjectDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trans_memory(self, trans_memory_id, **kwargs):  # noqa: E501
        """Get translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trans_memory(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def get_trans_memory_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Get translation memory  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trans_memory_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :return: TransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `get_trans_memory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransMemoryDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_translation_resources(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Get translation resources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_translation_resources(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :return: TranslationResourcesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_translation_resources_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_translation_resources_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
            return data

    def get_translation_resources_with_http_info(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Get translation resources  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_translation_resources_with_http_info(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :return: TranslationResourcesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'job_uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_translation_resources" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `get_translation_resources`")  # noqa: E501
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `get_translation_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/translationResources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationResourcesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_trans_memory(self, trans_memory_id, content_disposition, **kwargs):  # noqa: E501
        """Import segments  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_trans_memory(trans_memory_id, content_disposition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str content_disposition: must match pattern `filename\\*=UTF-8''(.+)` (required)
        :param InputStream body:
        :param bool strict_lang_matching:
        :param bool strip_native_codes:
        :param bool exclude_not_confirmed_segments:
        :return: ImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_trans_memory_with_http_info(trans_memory_id, content_disposition, **kwargs)  # noqa: E501
        else:
            (data) = self.import_trans_memory_with_http_info(trans_memory_id, content_disposition, **kwargs)  # noqa: E501
            return data

    def import_trans_memory_with_http_info(self, trans_memory_id, content_disposition, **kwargs):  # noqa: E501
        """Import segments  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_trans_memory_with_http_info(trans_memory_id, content_disposition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str content_disposition: must match pattern `filename\\*=UTF-8''(.+)` (required)
        :param InputStream body:
        :param bool strict_lang_matching:
        :param bool strip_native_codes:
        :param bool exclude_not_confirmed_segments:
        :return: ImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'content_disposition', 'body', 'strict_lang_matching', 'strip_native_codes', 'exclude_not_confirmed_segments']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `import_trans_memory`")  # noqa: E501
        # verify the required parameter 'content_disposition' is set
        if ('content_disposition' not in params or
                params['content_disposition'] is None):
            raise ValueError("Missing the required parameter `content_disposition` when calling `import_trans_memory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []
        if 'strict_lang_matching' in params:
            query_params.append(('strictLangMatching', params['strict_lang_matching']))  # noqa: E501
        if 'strip_native_codes' in params:
            query_params.append(('stripNativeCodes', params['strip_native_codes']))  # noqa: E501
        if 'exclude_not_confirmed_segments' in params:
            query_params.append(('excludeNotConfirmedSegments', params['exclude_not_confirmed_segments']))  # noqa: E501

        header_params = {}
        if 'content_disposition' in params:
            header_params['Content-Disposition'] = params['content_disposition']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_to_trans_memory(self, trans_memory_id, **kwargs):  # noqa: E501
        """Insert segment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_to_trans_memory(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param SegmentDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_to_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_to_trans_memory_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def insert_to_trans_memory_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Insert segment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_to_trans_memory_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param SegmentDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_to_trans_memory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `insert_to_trans_memory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/segments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_trans_memories(self, **kwargs):  # noqa: E501
        """List translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_trans_memories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param str source_lang:
        :param str target_lang:
        :param str client_id:
        :param str domain_id:
        :param str sub_domain_id:
        :param str business_unit_id:
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoTransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_trans_memories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_trans_memories_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_trans_memories_with_http_info(self, **kwargs):  # noqa: E501
        """List translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_trans_memories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param str source_lang:
        :param str target_lang:
        :param str client_id:
        :param str domain_id:
        :param str sub_domain_id:
        :param str business_unit_id:
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoTransMemoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'source_lang', 'target_lang', 'client_id', 'domain_id', 'sub_domain_id', 'business_unit_id', 'page_number', 'page_size', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_trans_memories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'source_lang' in params:
            query_params.append(('sourceLang', params['source_lang']))  # noqa: E501
        if 'target_lang' in params:
            query_params.append(('targetLang', params['target_lang']))  # noqa: E501
        if 'client_id' in params:
            query_params.append(('clientId', params['client_id']))  # noqa: E501
        if 'domain_id' in params:
            query_params.append(('domainId', params['domain_id']))  # noqa: E501
        if 'sub_domain_id' in params:
            query_params.append(('subDomainId', params['sub_domain_id']))  # noqa: E501
        if 'business_unit_id' in params:
            query_params.append(('businessUnitId', params['business_unit_id']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoTransMemoryDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search(self, trans_memory_id, **kwargs):  # noqa: E501
        """Search translation memory (sync)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param SearchRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.search_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def search_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Search translation memory (sync)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param SearchRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResponseListTmDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_by_job3(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Search job's translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_by_job3(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param SearchTMByJobRequestDtoV3 body:
        :return: SearchResponseListTmDtoV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_by_job3_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.search_by_job3_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
            return data

    def search_by_job3_with_http_info(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Search job's translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_by_job3_with_http_info(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param SearchTMByJobRequestDtoV3 body:
        :return: SearchResponseListTmDtoV3
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'job_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_by_job3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `search_by_job3`")  # noqa: E501
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `search_by_job3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v3/projects/{projectUid}/jobs/{jobUid}/transMemories/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResponseListTmDtoV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_segment(self, project_uid, **kwargs):  # noqa: E501
        """Search translation memory for segment in the project  # noqa: E501

        Returns at most <i>maxSegments</i>             records with <i>score >= scoreThreshold</i> and at most <i>maxSubsegments</i> records which are subsegment,             i.e. the source text is substring of the query text.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_segment(project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param SearchTMRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_segment_with_http_info(project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.search_segment_with_http_info(project_uid, **kwargs)  # noqa: E501
            return data

    def search_segment_with_http_info(self, project_uid, **kwargs):  # noqa: E501
        """Search translation memory for segment in the project  # noqa: E501

        Returns at most <i>maxSegments</i>             records with <i>score >= scoreThreshold</i> and at most <i>maxSubsegments</i> records which are subsegment,             i.e. the source text is substring of the query text.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_segment_with_http_info(project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param SearchTMRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `search_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/transMemories/searchSegmentInProject', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResponseListTmDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_segment_by_job(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Search translation memory for segment by job  # noqa: E501

        Returns at most <i>maxSegments</i>             records with <i>score >= scoreThreshold</i> and at most <i>maxSubsegments</i> records which are subsegment,             i.e. the source text is substring of the query text.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_segment_by_job(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param SearchTMByJobRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_segment_by_job_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.search_segment_by_job_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
            return data

    def search_segment_by_job_with_http_info(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Search translation memory for segment by job  # noqa: E501

        Returns at most <i>maxSegments</i>             records with <i>score >= scoreThreshold</i> and at most <i>maxSubsegments</i> records which are subsegment,             i.e. the source text is substring of the query text.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_segment_by_job_with_http_info(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param SearchTMByJobRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'job_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_segment_by_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `search_segment_by_job`")  # noqa: E501
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `search_segment_by_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/transMemories/searchSegment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResponseListTmDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_project_template_trans_memories(self, project_template_id, **kwargs):  # noqa: E501
        """Edit translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_trans_memories(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTransMemoriesDto body:
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def set_project_template_trans_memories_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Edit translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_trans_memories_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTransMemoriesDto body:
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_project_template_trans_memories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `set_project_template_trans_memories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/transMemories', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTransMemoryListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_translation(self, trans_memory_id, segment_id, **kwargs):  # noqa: E501
        """Edit segment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_translation(trans_memory_id, segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str segment_id: (required)
        :param TranslationDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_translation_with_http_info(trans_memory_id, segment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_translation_with_http_info(trans_memory_id, segment_id, **kwargs)  # noqa: E501
            return data

    def update_translation_with_http_info(self, trans_memory_id, segment_id, **kwargs):  # noqa: E501
        """Edit segment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_translation_with_http_info(trans_memory_id, segment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param str segment_id: (required)
        :param TranslationDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'segment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_translation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `update_translation`")  # noqa: E501
        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params or
                params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `update_translation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/segments/{segmentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wild_card_search_by_job3(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Wildcard search job's translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wild_card_search_by_job3(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param WildCardSearchByJobRequestDtoV3 body:
        :return: SearchResponseListTmDtoV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wild_card_search_by_job3_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.wild_card_search_by_job3_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501
            return data

    def wild_card_search_by_job3_with_http_info(self, project_uid, job_uid, **kwargs):  # noqa: E501
        """Wildcard search job's translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wild_card_search_by_job3_with_http_info(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :param str job_uid: (required)
        :param WildCardSearchByJobRequestDtoV3 body:
        :return: SearchResponseListTmDtoV3
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid', 'job_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wild_card_search_by_job3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `wild_card_search_by_job3`")  # noqa: E501
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `wild_card_search_by_job3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v3/projects/{projectUid}/jobs/{jobUid}/transMemories/wildCardSearch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResponseListTmDtoV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wildcard_search(self, trans_memory_id, **kwargs):  # noqa: E501
        """Wildcard search  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wildcard_search(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param WildCardSearchRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wildcard_search_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.wildcard_search_with_http_info(trans_memory_id, **kwargs)  # noqa: E501
            return data

    def wildcard_search_with_http_info(self, trans_memory_id, **kwargs):  # noqa: E501
        """Wildcard search  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wildcard_search_with_http_info(trans_memory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int trans_memory_id: (required)
        :param WildCardSearchRequestDto body:
        :return: SearchResponseListTmDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trans_memory_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wildcard_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'trans_memory_id' is set
        if ('trans_memory_id' not in params or
                params['trans_memory_id'] is None):
            raise ValueError("Missing the required parameter `trans_memory_id` when calling `wildcard_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'trans_memory_id' in params:
            path_params['transMemoryId'] = params['trans_memory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/transMemories/{transMemoryId}/wildCardSearch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResponseListTmDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
