# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class ProjectTemplateApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assign_linguists_from_template(self, template_id, project_uid, **kwargs):  # noqa: E501
        """Assigns providers from template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_linguists_from_template(template_id, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: (required)
        :param str project_uid: (required)
        :return: JobPartsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_linguists_from_template_with_http_info(template_id, project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_linguists_from_template_with_http_info(template_id, project_uid, **kwargs)  # noqa: E501
            return data

    def assign_linguists_from_template_with_http_info(self, template_id, project_uid, **kwargs):  # noqa: E501
        """Assigns providers from template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_linguists_from_template_with_http_info(template_id, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: (required)
        :param str project_uid: (required)
        :return: JobPartsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'project_uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_linguists_from_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `assign_linguists_from_template`")  # noqa: E501
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `assign_linguists_from_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/applyTemplate/{templateId}/assignProviders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobPartsDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_linguists_from_template_to_job_parts(self, template_id, project_uid, **kwargs):  # noqa: E501
        """Assigns providers from template (specific jobs)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_linguists_from_template_to_job_parts(template_id, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: (required)
        :param str project_uid: (required)
        :param JobPartReferences body:
        :return: JobPartsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_linguists_from_template_to_job_parts_with_http_info(template_id, project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_linguists_from_template_to_job_parts_with_http_info(template_id, project_uid, **kwargs)  # noqa: E501
            return data

    def assign_linguists_from_template_to_job_parts_with_http_info(self, template_id, project_uid, **kwargs):  # noqa: E501
        """Assigns providers from template (specific jobs)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_linguists_from_template_to_job_parts_with_http_info(template_id, project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: (required)
        :param str project_uid: (required)
        :param JobPartReferences body:
        :return: JobPartsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'project_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_linguists_from_template_to_job_parts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `assign_linguists_from_template_to_job_parts`")  # noqa: E501
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `assign_linguists_from_template_to_job_parts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/applyTemplate/{templateId}/assignProviders/forJobParts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobPartsDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assignable_templates(self, project_uid, **kwargs):  # noqa: E501
        """List assignable templates  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assignable_templates(project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :return: AssignableTemplatesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assignable_templates_with_http_info(project_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.assignable_templates_with_http_info(project_uid, **kwargs)  # noqa: E501
            return data

    def assignable_templates_with_http_info(self, project_uid, **kwargs):  # noqa: E501
        """List assignable templates  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assignable_templates_with_http_info(project_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_uid: (required)
        :return: AssignableTemplatesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assignable_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_uid' is set
        if ('project_uid' not in params or
                params['project_uid'] is None):
            raise ValueError("Missing the required parameter `project_uid` when calling `assignable_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_uid' in params:
            path_params['projectUid'] = params['project_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/assignableTemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssignableTemplatesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project_from_template_v2(self, template_id, **kwargs):  # noqa: E501
        """Create project from template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_from_template_v2(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: (required)
        :param CreateProjectFromTemplateV2Dto body:
        :return: AbstractProjectDtoV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_project_from_template_v2_with_http_info(template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_project_from_template_v2_with_http_info(template_id, **kwargs)  # noqa: E501
            return data

    def create_project_from_template_v2_with_http_info(self, template_id, **kwargs):  # noqa: E501
        """Create project from template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_from_template_v2_with_http_info(template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int template_id: (required)
        :param CreateProjectFromTemplateV2Dto body:
        :return: AbstractProjectDtoV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_from_template_v2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `create_project_from_template_v2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v2/projects/applyTemplate/{templateId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AbstractProjectDtoV2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project_template(self, body, **kwargs):  # noqa: E501
        """Create project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_template(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectTemplateCreateActionDto body: (required)
        :return: ProjectTemplateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_project_template_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_project_template_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_project_template_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_template_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectTemplateCreateActionDto body: (required)
        :return: ProjectTemplateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_project_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_template(self, project_template_id, **kwargs):  # noqa: E501
        """Delete project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_template(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_template_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def delete_project_template_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Delete project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_template_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_template_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `delete_project_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_project_template(self, project_template_id, body, **kwargs):  # noqa: E501
        """Edit project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_project_template(project_template_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_template_id: (required)
        :param ProjectTemplateEditDto body: (required)
        :return: ProjectTemplateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_project_template_with_http_info(project_template_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_project_template_with_http_info(project_template_id, body, **kwargs)  # noqa: E501
            return data

    def edit_project_template_with_http_info(self, project_template_id, body, **kwargs):  # noqa: E501
        """Edit project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_project_template_with_http_info(project_template_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_template_id: (required)
        :param ProjectTemplateEditDto body: (required)
        :return: ProjectTemplateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_project_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `edit_project_template`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `edit_project_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analyse_settings_for_project_template(self, project_template_id, **kwargs):  # noqa: E501
        """Get analyse settings  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analyse_settings_for_project_template(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: AnalyseSettingsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_analyse_settings_for_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_analyse_settings_for_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_analyse_settings_for_project_template_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get analyse settings  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_analyse_settings_for_project_template_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: AnalyseSettingsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analyse_settings_for_project_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_analyse_settings_for_project_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/analyseSettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalyseSettingsDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_machine_translate_settings_for_project_template(self, project_template_id, **kwargs):  # noqa: E501
        """Get machine translate settings  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_translate_settings_for_project_template(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: MTSettingsPerLanguageListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_machine_translate_settings_for_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_machine_translate_settings_for_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_machine_translate_settings_for_project_template_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get machine translate settings  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_machine_translate_settings_for_project_template_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: MTSettingsPerLanguageListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_machine_translate_settings_for_project_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_machine_translate_settings_for_project_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/mtSettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MTSettingsPerLanguageListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pre_translate_settings_for_project_template(self, project_template_id, **kwargs):  # noqa: E501
        """Get Pre-translate settings  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_translate_settings_for_project_template(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: PreTranslateSettingsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pre_translate_settings_for_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_pre_translate_settings_for_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_pre_translate_settings_for_project_template_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get Pre-translate settings  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_translate_settings_for_project_template_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: PreTranslateSettingsDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pre_translate_settings_for_project_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_pre_translate_settings_for_project_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/preTranslateSettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PreTranslateSettingsDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_template(self, project_template_id, **kwargs):  # noqa: E501
        """Get project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_template_id: (required)
        :return: ProjectTemplateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_template_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_project_template_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_template_id: (required)
        :return: ProjectTemplateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id','token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_project_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_template_term_bases(self, project_template_id, **kwargs):  # noqa: E501
        """Get term bases  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_term_bases(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_project_template_term_bases_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get term bases  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_term_bases_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_template_term_bases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_project_template_term_bases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/termBases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTermBaseListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_template_trans_memories(self, project_template_id, **kwargs):  # noqa: E501
        """Get translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_trans_memories(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def get_project_template_trans_memories_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Get translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_template_trans_memories_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_template_trans_memories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `get_project_template_trans_memories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/transMemories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTransMemoryListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_templates(self, **kwargs):  # noqa: E501
        """List project templates  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param int client_id:
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoProjectTemplateReference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_templates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_project_templates_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_project_templates_with_http_info(self, **kwargs):  # noqa: E501
        """List project templates  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param int client_id:
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoProjectTemplateReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'client_id', 'page_number', 'page_size', 'token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_templates" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_number' in params and params['page_number'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_number` when calling `get_project_templates`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_project_templates`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_project_templates`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'client_id' in params:
            query_params.append(('clientId', params['client_id']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        
        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoProjectTemplateReference',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_project_template_term_bases(self, project_template_id, **kwargs):  # noqa: E501
        """Edit term bases in project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_term_bases(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTermBaseDto body:
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_project_template_term_bases_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def set_project_template_term_bases_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Edit term bases in project template  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_term_bases_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTermBaseDto body:
        :return: ProjectTemplateTermBaseListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_project_template_term_bases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `set_project_template_term_bases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/termBases', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTermBaseListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_project_template_trans_memories(self, project_template_id, **kwargs):  # noqa: E501
        """Edit translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_trans_memories(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTransMemoriesDto body:
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_project_template_trans_memories_with_http_info(project_template_id, **kwargs)  # noqa: E501
            return data

    def set_project_template_trans_memories_with_http_info(self, project_template_id, **kwargs):  # noqa: E501
        """Edit translation memories  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_project_template_trans_memories_with_http_info(project_template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_template_id: (required)
        :param SetProjectTemplateTransMemoriesDto body:
        :return: ProjectTemplateTransMemoryListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_template_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_project_template_trans_memories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_template_id' is set
        if ('project_template_id' not in params or
                params['project_template_id'] is None):
            raise ValueError("Missing the required parameter `project_template_id` when calling `set_project_template_trans_memories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_template_id' in params:
            path_params['projectTemplateId'] = params['project_template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/projectTemplates/{projectTemplateId}/transMemories', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectTemplateTransMemoryListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
