# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class ConnectorApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_connector(self, connector_id, **kwargs):  # noqa: E501
        """Get a connector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector(connector_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :return: ConnectorDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_connector_with_http_info(connector_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_connector_with_http_info(connector_id, **kwargs)  # noqa: E501
            return data

    def get_connector_with_http_info(self, connector_id, **kwargs):  # noqa: E501
        """Get a connector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector_with_http_info(connector_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :return: ConnectorDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connector_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connector_id' is set
        if ('connector_id' not in params or
                params['connector_id'] is None):
            raise ValueError("Missing the required parameter `connector_id` when calling `get_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connector_id' in params:
            path_params['connectorId'] = params['connector_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConnectorDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_connector_list(self, **kwargs):  # noqa: E501
        """List connectors  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type:
        :return: ConnectorListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_connector_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_connector_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_connector_list_with_http_info(self, **kwargs):  # noqa: E501
        """List connectors  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type:
        :return: ConnectorListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connector_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/connectors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConnectorListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file(self, connector_id, folder, file, **kwargs):  # noqa: E501
        """Download file  # noqa: E501

        Download a file from a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file(connector_id, folder, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str folder: (required)
        :param str file: (required)
        :return: InputStreamLength
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_with_http_info(connector_id, folder, file, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_with_http_info(connector_id, folder, file, **kwargs)  # noqa: E501
            return data

    def get_file_with_http_info(self, connector_id, folder, file, **kwargs):  # noqa: E501
        """Download file  # noqa: E501

        Download a file from a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_with_http_info(connector_id, folder, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str folder: (required)
        :param str file: (required)
        :return: InputStreamLength
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connector_id', 'folder', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connector_id' is set
        if ('connector_id' not in params or
                params['connector_id'] is None):
            raise ValueError("Missing the required parameter `connector_id` when calling `get_file`")  # noqa: E501
        # verify the required parameter 'folder' is set
        if ('folder' not in params or
                params['folder'] is None):
            raise ValueError("Missing the required parameter `folder` when calling `get_file`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connector_id' in params:
            path_params['connectorId'] = params['connector_id']  # noqa: E501
        if 'folder' in params:
            path_params['folder'] = params['folder']  # noqa: E501
        if 'file' in params:
            path_params['file'] = params['file']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders/{folder}/files/{file}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InputStreamLength',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_folder(self, connector_id, folder, **kwargs):  # noqa: E501
        """List files in a subfolder  # noqa: E501

        List files in a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder(connector_id, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str folder: (required)
        :param str file_type:
        :param str sort:
        :param str direction:
        :return: FileListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_folder_with_http_info(connector_id, folder, **kwargs)  # noqa: E501
        else:
            (data) = self.get_folder_with_http_info(connector_id, folder, **kwargs)  # noqa: E501
            return data

    def get_folder_with_http_info(self, connector_id, folder, **kwargs):  # noqa: E501
        """List files in a subfolder  # noqa: E501

        List files in a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder_with_http_info(connector_id, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str folder: (required)
        :param str file_type:
        :param str sort:
        :param str direction:
        :return: FileListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connector_id', 'folder', 'file_type', 'sort', 'direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connector_id' is set
        if ('connector_id' not in params or
                params['connector_id'] is None):
            raise ValueError("Missing the required parameter `connector_id` when calling `get_folder`")  # noqa: E501
        # verify the required parameter 'folder' is set
        if ('folder' not in params or
                params['folder'] is None):
            raise ValueError("Missing the required parameter `folder` when calling `get_folder`")  # noqa: E501

        if 'file_type' in params and not re.search(r'ALL|FILES_ONLY|FOLDERS_ONLY', params['file_type']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_type` when calling `get_folder`, must conform to the pattern `/ALL|FILES_ONLY|FOLDERS_ONLY/`")  # noqa: E501
        if 'sort' in params and not re.search(r'NAME|SIZE|LAST_MODIFIED', params['sort']):  # noqa: E501
            raise ValueError("Invalid value for parameter `sort` when calling `get_folder`, must conform to the pattern `/NAME|SIZE|LAST_MODIFIED/`")  # noqa: E501
        if 'direction' in params and not re.search(r'ASCENDING|DESCENDING', params['direction']):  # noqa: E501
            raise ValueError("Invalid value for parameter `direction` when calling `get_folder`, must conform to the pattern `/ASCENDING|DESCENDING/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'connector_id' in params:
            path_params['connectorId'] = params['connector_id']  # noqa: E501
        if 'folder' in params:
            path_params['folder'] = params['folder']  # noqa: E501

        query_params = []
        if 'file_type' in params:
            query_params.append(('fileType', params['file_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders/{folder}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_root_folder(self, connector_id, **kwargs):  # noqa: E501
        """List files in root  # noqa: E501

        List files in a root folder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_root_folder(connector_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str file_type:
        :param str sort:
        :param str direction:
        :return: FileListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_root_folder_with_http_info(connector_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_root_folder_with_http_info(connector_id, **kwargs)  # noqa: E501
            return data

    def get_root_folder_with_http_info(self, connector_id, **kwargs):  # noqa: E501
        """List files in root  # noqa: E501

        List files in a root folder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_root_folder_with_http_info(connector_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str file_type:
        :param str sort:
        :param str direction:
        :return: FileListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connector_id', 'file_type', 'sort', 'direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_root_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connector_id' is set
        if ('connector_id' not in params or
                params['connector_id'] is None):
            raise ValueError("Missing the required parameter `connector_id` when calling `get_root_folder`")  # noqa: E501

        if 'file_type' in params and not re.search(r'ALL|FILES_ONLY|FOLDERS_ONLY', params['file_type']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_type` when calling `get_root_folder`, must conform to the pattern `/ALL|FILES_ONLY|FOLDERS_ONLY/`")  # noqa: E501
        if 'sort' in params and not re.search(r'NAME|SIZE|LAST_MODIFIED', params['sort']):  # noqa: E501
            raise ValueError("Invalid value for parameter `sort` when calling `get_root_folder`, must conform to the pattern `/NAME|SIZE|LAST_MODIFIED/`")  # noqa: E501
        if 'direction' in params and not re.search(r'ASCENDING|DESCENDING', params['direction']):  # noqa: E501
            raise ValueError("Invalid value for parameter `direction` when calling `get_root_folder`, must conform to the pattern `/ASCENDING|DESCENDING/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'connector_id' in params:
            path_params['connectorId'] = params['connector_id']  # noqa: E501

        query_params = []
        if 'file_type' in params:
            query_params.append(('fileType', params['file_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_file(self, connector_id, folder, content_type, file, **kwargs):  # noqa: E501
        """Upload a file to a subfolder of the selected connector  # noqa: E501

        Upload a file to a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file(connector_id, folder, content_type, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str folder: (required)
        :param str content_type: (required)
        :param file file: Translated file to upload (required)
        :param str source_file_name: Name or ID of the original file
        :param str subfolder_name: Optional subfolder to upload the file to
        :param str mime_type: Mime type of the file to upload
        :param str commit_message: Commit message for upload to Git, etc.
        :return: UploadResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_file_with_http_info(connector_id, folder, content_type, file, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_file_with_http_info(connector_id, folder, content_type, file, **kwargs)  # noqa: E501
            return data

    def upload_file_with_http_info(self, connector_id, folder, content_type, file, **kwargs):  # noqa: E501
        """Upload a file to a subfolder of the selected connector  # noqa: E501

        Upload a file to a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_file_with_http_info(connector_id, folder, content_type, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str connector_id: (required)
        :param str folder: (required)
        :param str content_type: (required)
        :param file file: Translated file to upload (required)
        :param str source_file_name: Name or ID of the original file
        :param str subfolder_name: Optional subfolder to upload the file to
        :param str mime_type: Mime type of the file to upload
        :param str commit_message: Commit message for upload to Git, etc.
        :return: UploadResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connector_id', 'folder', 'content_type', 'file', 'source_file_name', 'subfolder_name', 'mime_type', 'commit_message']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connector_id' is set
        if ('connector_id' not in params or
                params['connector_id'] is None):
            raise ValueError("Missing the required parameter `connector_id` when calling `upload_file`")  # noqa: E501
        # verify the required parameter 'folder' is set
        if ('folder' not in params or
                params['folder'] is None):
            raise ValueError("Missing the required parameter `folder` when calling `upload_file`")  # noqa: E501
        # verify the required parameter 'content_type' is set
        if ('content_type' not in params or
                params['content_type'] is None):
            raise ValueError("Missing the required parameter `content_type` when calling `upload_file`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connector_id' in params:
            path_params['connectorId'] = params['connector_id']  # noqa: E501
        if 'folder' in params:
            path_params['folder'] = params['folder']  # noqa: E501

        query_params = []

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'source_file_name' in params:
            form_params.append(('sourceFileName', params['source_file_name']))  # noqa: E501
        if 'subfolder_name' in params:
            form_params.append(('subfolderName', params['subfolder_name']))  # noqa: E501
        if 'mime_type' in params:
            form_params.append(('mimeType', params['mime_type']))  # noqa: E501
        if 'commit_message' in params:
            form_params.append(('commitMessage', params['commit_message']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders/{folder}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
